/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.MultiParagraphKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.ParagraphInfo;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphKt;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B)\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0017J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000bJ\u000e\u00109\u001a\u0002032\u0006\u00108\u001a\u00020\u000bJ\u000e\u0010:\u001a\u0002032\u0006\u00108\u001a\u00020\u000bJ\u0016\u0010;\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\rJ\u000e\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u0018\u0010?\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000b2\b\b\u0002\u0010@\u001a\u00020\rJ\u000e\u0010A\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000bJ\u000e\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u000fJ\u000e\u0010D\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010E\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010F\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010G\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010H\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000bJ\u001b\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020L\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bM\u0010NJ\u000e\u0010O\u001a\u0002072\u0006\u00108\u001a\u00020\u000bJ\u0016\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u000bJ\u001e\u0010T\u001a\u00020U2\u0006\u00108\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010WJ\u000e\u0010X\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u000bJ=\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\b\b\u0002\u0010]\u001a\u00020^2\n\b\u0002\u0010_\u001a\u0004\u0018\u00010`2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bc\u0010dJ\u0010\u0010e\u001a\u00020Z2\u0006\u00108\u001a\u00020\u000bH\u0002J\u0010\u0010f\u001a\u00020Z2\u0006\u00108\u001a\u00020\u000bH\u0002J\u0010\u0010g\u001a\u00020Z2\u0006\u0010>\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001fR\u0011\u0010&\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010(R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001fR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0019\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00101R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006h"}, d2={"Landroidx/compose/ui/text/MultiParagraph;", "", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "maxLines", "", "ellipsis", "", "width", "", "density", "Landroidx/compose/ui/unit/Density;", "resourceLoader", "Landroidx/compose/ui/text/font/Font$ResourceLoader;", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;IZFLandroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/Font$ResourceLoader;)V", "intrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "(Landroidx/compose/ui/text/MultiParagraphIntrinsics;IZF)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "firstBaseline", "getFirstBaseline", "()F", "height", "getHeight", "getIntrinsics", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "lastBaseline", "getLastBaseline", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "paragraphInfoList", "Landroidx/compose/ui/text/ParagraphInfo;", "getParagraphInfoList$ui_text_release", "()Ljava/util/List;", "placeholderRects", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "getWidth", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/compose/ui/text/TextRange;", "getWordBoundary--jx7JFs", "(I)J", "isLineEllipsized", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "decoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "requireIndexInRange", "requireIndexInRangeInclusiveEnd", "requireLineIndexInRange", "ui-text_release"})
public final class MultiParagraph {
    @NotNull
    private final MultiParagraphIntrinsics intrinsics;
    private final int maxLines;
    private final boolean didExceedMaxLines;
    private final float width;
    private final float height;
    private final int lineCount;
    @NotNull
    private final List<Rect> placeholderRects;
    @NotNull
    private final List<ParagraphInfo> paragraphInfoList;

    /*
     * WARNING - void declaration
     */
    public MultiParagraph(@NotNull MultiParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, float width) {
        List list;
        void it;
        void $this$fastFlatMap$iv;
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        this.intrinsics = intrinsics;
        this.maxLines = maxLines;
        float currentHeight = 0.0f;
        int currentLineCount = 0;
        boolean didExceedMaxLines = false;
        List paragraphInfoList = new ArrayList();
        List<ParagraphIntrinsicInfo> infoList = this.intrinsics.getInfoList$ui_text_release();
        int n = 0;
        int n2 = infoList.size();
        while (n < n2) {
            int endLineIndex;
            float paragraphBottom;
            int index = n++;
            ParagraphIntrinsicInfo paragraphInfo = infoList.get(index);
            Paragraph paragraph = ParagraphKt.Paragraph(paragraphInfo.getIntrinsics(), this.maxLines - currentLineCount, ellipsis, width);
            float paragraphTop = currentHeight;
            currentHeight = paragraphBottom = currentHeight + paragraph.getHeight();
            int startLineIndex = currentLineCount;
            currentLineCount = endLineIndex = startLineIndex + paragraph.getLineCount();
            paragraphInfoList.add(new ParagraphInfo(paragraph, paragraphInfo.getStartIndex(), paragraphInfo.getEndIndex(), startLineIndex, endLineIndex, paragraphTop, paragraphBottom));
            if (!paragraph.getDidExceedMaxLines() && (endLineIndex != this.maxLines || index == CollectionsKt.getLastIndex(this.intrinsics.getInfoList$ui_text_release()))) continue;
            didExceedMaxLines = true;
            break;
        }
        this.height = currentHeight;
        this.lineCount = currentLineCount;
        this.didExceedMaxLines = didExceedMaxLines;
        this.paragraphInfoList = paragraphInfoList;
        this.width = width;
        List list2 = paragraphInfoList;
        MultiParagraph multiParagraph = this;
        boolean $i$f$fastFlatMap22 = false;
        ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
        void $this$fastForEach$iv$iv = $this$fastFlatMap$iv;
        boolean $i$f$fastForEach = false;
        int n3 = 0;
        int n4 = $this$fastForEach$iv$iv.size();
        while (n3 < n4) {
            Object item$iv$iv;
            int index$iv$iv = n3++;
            Object e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            ParagraphInfo paragraphInfo = (ParagraphInfo)e$iv;
            boolean bl2 = false;
            ParagraphInfo $this$lambda_u2d3_u24lambda_u2d2 = paragraphInfo;
            boolean bl3 = false;
            List<Rect> $this$fastMap$iv = $this$lambda_u2d3_u24lambda_u2d2.getParagraph().getPlaceholderRects();
            boolean $i$f$fastMap = false;
            ArrayList target$iv2 = new ArrayList($this$fastMap$iv.size());
            List<Rect> $this$fastForEach$iv$iv2 = $this$fastMap$iv;
            boolean $i$f$fastForEach2 = false;
            int n5 = 0;
            int n6 = $this$fastForEach$iv$iv2.size();
            while (n5 < n6) {
                void it2;
                Rect item$iv$iv2;
                int index$iv$iv2 = n5++;
                Rect it$iv = item$iv$iv2 = $this$fastForEach$iv$iv2.get(index$iv$iv2);
                boolean bl4 = false;
                Rect rect = it$iv;
                Collection collection = target$iv2;
                boolean bl5 = false;
                void v0 = it2;
                collection.add(v0 == null ? null : $this$lambda_u2d3_u24lambda_u2d2.toGlobal((Rect)v0));
            }
            Iterable list$iv = target$iv2;
            CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
        }
        List $i$f$fastFlatMap22 = target$iv;
        boolean bl = false;
        if (it.size() < this.getIntrinsics().getPlaceholders().size()) {
            int n7 = this.getIntrinsics().getPlaceholders().size() - it.size();
            Collection collection = (Collection)it;
            ArrayList<Object> arrayList = new ArrayList<Object>(n7);
            n4 = 0;
            while (n4 < n7) {
                int n8;
                int n9;
                int e$iv = n9 = (n8 = n4++);
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl6 = false;
                arrayList2.add(null);
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)arrayList);
        } else {
            list = it;
        }
        multiParagraph.placeholderRects = list;
    }

    public /* synthetic */ MultiParagraph(MultiParagraphIntrinsics multiParagraphIntrinsics, int n, boolean bl, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(multiParagraphIntrinsics, n, bl, f);
    }

    @NotNull
    public final MultiParagraphIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public MultiParagraph(@NotNull AnnotatedString annotatedString, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, int maxLines, boolean ellipsis, float width, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this(new MultiParagraphIntrinsics(annotatedString, style, placeholders, density, resourceLoader), maxLines, ellipsis, width);
    }

    public /* synthetic */ MultiParagraph(AnnotatedString annotatedString, TextStyle textStyle, List list, int n, boolean bl, float f, Density density, Font.ResourceLoader resourceLoader, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(annotatedString, textStyle, list, n, bl, f, density, resourceLoader);
    }

    private final AnnotatedString getAnnotatedString() {
        return this.intrinsics.getAnnotatedString();
    }

    public final float getMinIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final float getMaxIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getFirstBaseline() {
        return this.paragraphInfoList.isEmpty() ? 0.0f : this.paragraphInfoList.get(0).getParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        float f;
        if (this.paragraphInfoList.isEmpty()) {
            f = 0.0f;
        } else {
            ParagraphInfo $this$_get_lastBaseline__u24lambda_u2d0 = (ParagraphInfo)CollectionsKt.last(this.paragraphInfoList);
            boolean bl = false;
            f = $this$_get_lastBaseline__u24lambda_u2d0.toGlobalYPosition($this$_get_lastBaseline__u24lambda_u2d0.getParagraph().getLastBaseline());
        }
        return f;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final List<ParagraphInfo> getParagraphInfoList$ui_text_release() {
        return this.paragraphInfoList;
    }

    public final void paint-RPmYEkk(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration decoration) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        List<ParagraphInfo> $this$fastForEach$iv = this.paragraphInfoList;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            ParagraphInfo item$iv;
            int index$iv = n++;
            ParagraphInfo it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            it.getParagraph().paint-RPmYEkk(canvas, color, shadow, decoration);
            canvas.translate(0.0f, it.getParagraph().getHeight());
        }
        canvas.restore();
    }

    public static /* synthetic */ void paint-RPmYEkk$default(MultiParagraph multiParagraph, Canvas canvas, long l, Shadow shadow, TextDecoration textDecoration, int n, Object object) {
        if ((n & 2) != 0) {
            l = Color.Companion.getUnspecified-0d7_KjU();
        }
        if ((n & 4) != 0) {
            shadow = null;
        }
        if ((n & 8) != 0) {
            textDecoration = null;
        }
        multiParagraph.paint-RPmYEkk(canvas, l, shadow, textDecoration);
    }

    @NotNull
    public final Path getPathForRange(int start, int end) {
        int i;
        ParagraphInfo p;
        if (!((0 <= start ? start <= end : false) && end <= this.getAnnotatedString().getText().length())) {
            boolean $i$a$-require-MultiParagraph$getPathForRange$22 = false;
            String $i$a$-require-MultiParagraph$getPathForRange$22 = "Start(" + start + ") or End(" + end + ") is out of range [0.." + this.getAnnotatedString().getText().length() + "), or start > end!";
            throw new IllegalArgumentException($i$a$-require-MultiParagraph$getPathForRange$22.toString());
        }
        if (start == end) {
            return AndroidPath_androidKt.Path();
        }
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, start);
        Path path = AndroidPath_androidKt.Path();
        int n = paragraphIndex;
        int n2 = this.paragraphInfoList.size();
        while (n < n2 && (p = this.paragraphInfoList.get(i = n++)).getStartIndex() < end) {
            if (p.getStartIndex() == p.getEndIndex()) continue;
            ParagraphInfo $this$getPathForRange_u24lambda_u2d8 = p;
            boolean bl = false;
            Path.DefaultImpls.addPath-Uv8p0NA$default((Path)path, (Path)$this$getPathForRange_u24lambda_u2d8.toGlobal($this$getPathForRange_u24lambda_u2d8.getParagraph().getPathForRange($this$getPathForRange_u24lambda_u2d8.toLocalIndex(start), $this$getPathForRange_u24lambda_u2d8.toLocalIndex(end))), (long)0L, (int)2, null);
        }
        return path;
    }

    public final int getLineForVerticalPosition(float vertical) {
        int paragraphIndex = vertical <= 0.0f ? 0 : (vertical >= this.height ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByY(this.paragraphInfoList, vertical));
        ParagraphInfo $this$getLineForVerticalPosition_u24lambda_u2d9 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineForVerticalPosition_u24lambda_u2d9.getLength() == 0 ? Math.max(0, $this$getLineForVerticalPosition_u24lambda_u2d9.getStartIndex() - 1) : $this$getLineForVerticalPosition_u24lambda_u2d9.toGlobalLineIndex($this$getLineForVerticalPosition_u24lambda_u2d9.getParagraph().getLineForVerticalPosition($this$getLineForVerticalPosition_u24lambda_u2d9.toLocalYPosition(vertical)));
    }

    public final int getOffsetForPosition-k-4lQ0M(long position) {
        int paragraphIndex = Offset.getY-impl((long)position) <= 0.0f ? 0 : (Offset.getY-impl((long)position) >= this.height ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByY(this.paragraphInfoList, Offset.getY-impl((long)position)));
        ParagraphInfo $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10.getLength() == 0 ? Math.max(0, $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10.getStartIndex() - 1) : $this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10.toGlobalIndex($this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10.getParagraph().getOffsetForPosition-k-4lQ0M($this$getOffsetForPosition_k_4lQ0M_u24lambda_u2d10.toLocal-MK-Hz9U(position)));
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getBoundingBox_u24lambda_u2d11 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getBoundingBox_u24lambda_u2d11.toGlobal($this$getBoundingBox_u24lambda_u2d11.getParagraph().getBoundingBox($this$getBoundingBox_u24lambda_u2d11.toLocalIndex(offset)));
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getHorizontalPosition_u24lambda_u2d12 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getHorizontalPosition_u24lambda_u2d12.getParagraph().getHorizontalPosition($this$getHorizontalPosition_u24lambda_u2d12.toLocalIndex(offset), usePrimaryDirection);
    }

    @NotNull
    public final ResolvedTextDirection getParagraphDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getParagraphDirection_u24lambda_u2d13 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getParagraphDirection_u24lambda_u2d13.getParagraph().getParagraphDirection($this$getParagraphDirection_u24lambda_u2d13.toLocalIndex(offset));
    }

    @NotNull
    public final ResolvedTextDirection getBidiRunDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getBidiRunDirection_u24lambda_u2d14 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getBidiRunDirection_u24lambda_u2d14.getParagraph().getBidiRunDirection($this$getBidiRunDirection_u24lambda_u2d14.toLocalIndex(offset));
    }

    public final long getWordBoundary--jx7JFs(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getWordBoundary__jx7JFs_u24lambda_u2d15 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getWordBoundary__jx7JFs_u24lambda_u2d15.toGlobal-GEjPoXI($this$getWordBoundary__jx7JFs_u24lambda_u2d15.getParagraph().getWordBoundary--jx7JFs($this$getWordBoundary__jx7JFs_u24lambda_u2d15.toLocalIndex(offset)));
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getCursorRect_u24lambda_u2d16 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getCursorRect_u24lambda_u2d16.toGlobal($this$getCursorRect_u24lambda_u2d16.getParagraph().getCursorRect($this$getCursorRect_u24lambda_u2d16.toLocalIndex(offset)));
    }

    public final int getLineForOffset(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == this.getAnnotatedString().length() ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo $this$getLineForOffset_u24lambda_u2d17 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineForOffset_u24lambda_u2d17.toGlobalLineIndex($this$getLineForOffset_u24lambda_u2d17.getParagraph().getLineForOffset($this$getLineForOffset_u24lambda_u2d17.toLocalIndex(offset)));
    }

    public final float getLineLeft(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineLeft_u24lambda_u2d18 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineLeft_u24lambda_u2d18.getParagraph().getLineLeft($this$getLineLeft_u24lambda_u2d18.toLocalLineIndex(lineIndex));
    }

    public final float getLineRight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineRight_u24lambda_u2d19 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineRight_u24lambda_u2d19.getParagraph().getLineRight($this$getLineRight_u24lambda_u2d19.toLocalLineIndex(lineIndex));
    }

    public final float getLineTop(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineTop_u24lambda_u2d20 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineTop_u24lambda_u2d20.toGlobalYPosition($this$getLineTop_u24lambda_u2d20.getParagraph().getLineTop($this$getLineTop_u24lambda_u2d20.toLocalLineIndex(lineIndex)));
    }

    public final float getLineBottom(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineBottom_u24lambda_u2d21 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineBottom_u24lambda_u2d21.toGlobalYPosition($this$getLineBottom_u24lambda_u2d21.getParagraph().getLineBottom($this$getLineBottom_u24lambda_u2d21.toLocalLineIndex(lineIndex)));
    }

    public final float getLineHeight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineHeight_u24lambda_u2d22 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineHeight_u24lambda_u2d22.getParagraph().getLineHeight($this$getLineHeight_u24lambda_u2d22.toLocalLineIndex(lineIndex));
    }

    public final float getLineWidth(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineWidth_u24lambda_u2d23 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineWidth_u24lambda_u2d23.getParagraph().getLineWidth($this$getLineWidth_u24lambda_u2d23.toLocalLineIndex(lineIndex));
    }

    public final int getLineStart(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineStart_u24lambda_u2d24 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineStart_u24lambda_u2d24.toGlobalIndex($this$getLineStart_u24lambda_u2d24.getParagraph().getLineStart($this$getLineStart_u24lambda_u2d24.toLocalLineIndex(lineIndex)));
    }

    public final int getLineEnd(int lineIndex, boolean visibleEnd) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$getLineEnd_u24lambda_u2d25 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$getLineEnd_u24lambda_u2d25.toGlobalIndex($this$getLineEnd_u24lambda_u2d25.getParagraph().getLineEnd($this$getLineEnd_u24lambda_u2d25.toLocalLineIndex(lineIndex), visibleEnd));
    }

    public static /* synthetic */ int getLineEnd$default(MultiParagraph multiParagraph, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return multiParagraph.getLineEnd(n, bl);
    }

    public final boolean isLineEllipsized(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo $this$isLineEllipsized_u24lambda_u2d26 = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        return $this$isLineEllipsized_u24lambda_u2d26.getParagraph().isLineEllipsized(lineIndex);
    }

    private final void requireIndexInRange(int offset) {
        if (!(0 <= offset ? offset < this.getAnnotatedString().getText().length() : false)) {
            boolean bl = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + this.getAnnotatedString().length() + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void requireIndexInRangeInclusiveEnd(int offset) {
        if (!(0 <= offset ? offset <= this.getAnnotatedString().getText().length() : false)) {
            boolean bl = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + this.getAnnotatedString().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void requireLineIndexInRange(int lineIndex) {
        if (!(0 <= lineIndex ? lineIndex < this.lineCount : false)) {
            boolean bl = false;
            String string = "lineIndex(" + lineIndex + ") is out of bounds [0, " + lineIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }
}

