/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.googlefonts;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import androidx.annotation.WorkerThread;
import androidx.compose.ui.text.googlefonts.FontProviderHelperKt;
import androidx.compose.ui.text.googlefonts.GoogleFont;
import androidx.core.content.res.FontResourcesParserCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0003\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u001a$\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00050\u0005*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"ByteArrayComparator", "Ljava/util/Comparator;", "", "kotlin.jvm.PlatformType", "convertToByteArrayList", "", "signatures", "", "Landroid/content/pm/Signature;", "([Landroid/content/pm/Signature;)Ljava/util/List;", "repr", "", "b", "throwFormattedCertsMissError", "", "checkAvailable", "", "Landroidx/compose/ui/text/googlefonts/GoogleFont$Provider;", "packageManager", "Landroid/content/pm/PackageManager;", "resources", "Landroid/content/res/Resources;", "getSignatures", "packageName", "loadCertsIfNeeded", "ui-text-google-fonts_release"})
@SourceDebugExtension(value={"SMAP\nFontProviderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontProviderHelper.kt\nandroidx/compose/ui/text/googlefonts/FontProviderHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1747#2,3:112\n*S KotlinDebug\n*F\n+ 1 FontProviderHelper.kt\nandroidx/compose/ui/text/googlefonts/FontProviderHelperKt\n*L\n43#1:112,3\n*E\n"})
public final class FontProviderHelperKt {
    @NotNull
    private static final Comparator<byte[]> ByteArrayComparator = FontProviderHelperKt::ByteArrayComparator$lambda$1;

    @SuppressLint(value={"ListIterator"})
    @WorkerThread
    public static final boolean checkAvailable(@NotNull GoogleFont.Provider $this$checkAvailable, @NotNull PackageManager packageManager, @NotNull Resources resources) {
        boolean certsMatched;
        List<byte[]> signatures;
        block10: {
            boolean bl;
            ProviderInfo providerInfo = packageManager.resolveContentProvider($this$checkAvailable.getProviderAuthority$ui_text_google_fonts_release(), 0);
            if (providerInfo == null) {
                return false;
            }
            ProviderInfo providerInfo2 = providerInfo;
            if (!Intrinsics.areEqual((Object)providerInfo2.packageName, (Object)$this$checkAvailable.getProviderPackage$ui_text_google_fonts_release())) {
                return false;
            }
            signatures = FontProviderHelperKt.getSignatures(packageManager, providerInfo2.packageName);
            List sortedSignatures = CollectionsKt.sortedWith((Iterable)signatures, ByteArrayComparator);
            List<List<byte[]>> allExpectedCerts = FontProviderHelperKt.loadCertsIfNeeded($this$checkAvailable, resources);
            Iterable $this$any$iv = allExpectedCerts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block9: {
                        List expected;
                        List certList = (List)element$iv;
                        boolean bl3 = false;
                        List list = certList;
                        List list2 = expected = list != null ? CollectionsKt.sortedWith((Iterable)list, ByteArrayComparator) : null;
                        if (!(list2 != null ? list2.size() == sortedSignatures.size() : false)) {
                            bl2 = false;
                        } else {
                            int n = expected.size();
                            for (int i = 0; i < n; ++i) {
                                if (Arrays.equals((byte[])expected.get(i), (byte[])sortedSignatures.get(i))) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block10;
                }
                bl = certsMatched = false;
            }
        }
        if (!certsMatched) {
            FontProviderHelperKt.throwFormattedCertsMissError(signatures);
            throw new KotlinNothingValueException();
        }
        return true;
    }

    @SuppressLint(value={"ListIterator"})
    private static final Void throwFormattedCertsMissError(List<byte[]> signatures) {
        String fullDescription2 = CollectionsKt.joinToString$default((Iterable)signatures, (CharSequence)",", (CharSequence)"listOf(listOf(", (CharSequence)"))", (int)0, null, (Function1)throwFormattedCertsMissError.fullDescription.1.INSTANCE, (int)24, null);
        throw new IllegalStateException("Provided signatures did not match. Actual signatures of package are:\n\n" + fullDescription2);
    }

    private static final String repr(byte[] b) {
        return ArraysKt.joinToString$default((byte[])b, (CharSequence)",", (CharSequence)"byteArrayOf(", (CharSequence)")", (int)0, null, null, (int)56, null);
    }

    private static final List<List<byte[]>> loadCertsIfNeeded(GoogleFont.Provider $this$loadCertsIfNeeded, Resources resources) {
        if ($this$loadCertsIfNeeded.getCertificates$ui_text_google_fonts_release() != null) {
            return $this$loadCertsIfNeeded.getCertificates$ui_text_google_fonts_release();
        }
        return FontResourcesParserCompat.readCerts((Resources)resources, (int)$this$loadCertsIfNeeded.getCertificatesRes$ui_text_google_fonts_release());
    }

    private static final List<byte[]> getSignatures(PackageManager $this$getSignatures, String packageName) {
        PackageInfo packageInfo = $this$getSignatures.getPackageInfo(packageName, 64);
        return FontProviderHelperKt.convertToByteArrayList(packageInfo.signatures);
    }

    private static final List<byte[]> convertToByteArrayList(Signature[] signatures) {
        List shaList = new ArrayList();
        for (Signature signature : signatures) {
            shaList.add(signature.toByteArray());
        }
        return shaList;
    }

    private static final int ByteArrayComparator$lambda$1(byte[] l, byte[] r) {
        if (l.length != r.length) {
            return l.length - r.length;
        }
        for (int i = 0; i < l.length; ++i) {
            if (l[i] == r[i]) continue;
            return l[i] - r[i];
        }
        return 0;
    }

    public static final /* synthetic */ String access$repr(byte[] b) {
        return FontProviderHelperKt.repr(b);
    }
}

