/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.selection;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.android.selection.SegmentFinder;
import androidx.compose.ui.text.android.selection.WordIterator;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/text/android/selection/WordSegmentFinder;", "Landroidx/compose/ui/text/android/selection/SegmentFinder;", "text", "", "wordIterator", "Landroidx/compose/ui/text/android/selection/WordIterator;", "(Ljava/lang/CharSequence;Landroidx/compose/ui/text/android/selection/WordIterator;)V", "nextEndBoundary", "", "offset", "nextStartBoundary", "previousEndBoundary", "previousStartBoundary", "ui-text_release"})
@StabilityInferred(parameters=0)
public final class WordSegmentFinder
implements SegmentFinder {
    @NotNull
    private final CharSequence text;
    @NotNull
    private final WordIterator wordIterator;
    public static final int $stable = 8;

    public WordSegmentFinder(@NotNull CharSequence text, @NotNull WordIterator wordIterator) {
        this.text = text;
        this.wordIterator = wordIterator;
    }

    @Override
    public int previousStartBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.wordIterator.prevBoundary(boundary)) != -1) continue;
            return -1;
        } while (Character.isWhitespace(this.text.charAt(boundary)));
        return boundary;
    }

    @Override
    public int previousEndBoundary(int offset) {
        int boundary = offset;
        do {
            boundary = this.wordIterator.prevBoundary(boundary);
            switch (boundary) {
                case -1: 
                case 0: {
                    return -1;
                }
            }
        } while (Character.isWhitespace(this.text.charAt(boundary - 1)));
        return boundary;
    }

    @Override
    public int nextStartBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.wordIterator.nextBoundary(boundary)) != -1 && boundary != this.text.length()) continue;
            return -1;
        } while (Character.isWhitespace(this.text.charAt(boundary)));
        return boundary;
    }

    @Override
    public int nextEndBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.wordIterator.nextBoundary(boundary)) != -1) continue;
            return -1;
        } while (Character.isWhitespace(this.text.charAt(boundary - 1)));
        return boundary;
    }
}

