/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AndroidParagraph_androidKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.android.LayoutIntrinsics;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.selection.WordBoundary;
import androidx.compose.ui.text.android.style.PlaceholderSpan;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.AndroidParagraphHelper_androidKt;
import androidx.compose.ui.text.platform.AndroidParagraphIntrinsics;
import androidx.compose.ui.text.platform.AndroidTextPaint;
import androidx.compose.ui.text.platform.style.ShaderBrushSpan;
import androidx.compose.ui.text.style.LineBreak;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001Bg\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016B%\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019JJ\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020\r2\u0006\u0010S\u001a\u00020\r2\b\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020\r2\u0006\u0010Y\u001a\u00020\rH\u0002J,\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\b\b\u0001\u0010`\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010bJ\u0010\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\rH\u0016J\u0010\u0010f\u001a\u00020<2\u0006\u0010e\u001a\u00020\rH\u0016J\u0010\u0010g\u001a\u00020<2\u0006\u0010e\u001a\u00020\rH\u0016J\u0018\u0010h\u001a\u00020(2\u0006\u0010e\u001a\u00020\r2\u0006\u0010i\u001a\u00020\u000fH\u0016J\u0015\u0010j\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0000\u00a2\u0006\u0002\blJ\u0015\u0010m\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bnJ\u0010\u0010o\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u0015\u0010p\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bqJ\u0018\u0010r\u001a\u00020\r2\u0006\u0010k\u001a\u00020\r2\u0006\u0010s\u001a\u00020\u000fH\u0016J\u0010\u0010t\u001a\u00020\r2\u0006\u0010e\u001a\u00020\rH\u0016J\u0010\u0010u\u001a\u00020\r2\u0006\u0010v\u001a\u00020(H\u0016J\u0010\u0010w\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u0010\u0010x\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u0010\u0010y\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u0010\u0010z\u001a\u00020\r2\u0006\u0010k\u001a\u00020\rH\u0016J\u0010\u0010{\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u0010\u0010|\u001a\u00020(2\u0006\u0010k\u001a\u00020\rH\u0016J\u001c\u0010}\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u007fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J\u0011\u0010\u0082\u0001\u001a\u00020d2\u0006\u0010e\u001a\u00020\rH\u0016J\u001c\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020\r2\u0007\u0010\u0086\u0001\u001a\u00020\rH\u0016J\u001f\u0010M\u001a\u00020]2\u0006\u0010e\u001a\u00020\rH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001J\u0011\u0010\u0089\u0001\u001a\u00020\u000f2\u0006\u0010k\u001a\u00020\rH\u0016J\u0013\u0010\u008a\u0001\u001a\u00020[2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0002J`\u0010\u008a\u0001\u001a\u00020[2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020(2\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u00012\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0098\u0001\u0010\u0099\u0001JA\u0010\u008a\u0001\u001a\u00020[2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u00012\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009c\u0001\u0010\u009d\u0001JW\u0010\u008a\u0001\u001a\u00020[2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u00012\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009e\u0001\u0010\u009f\u0001J\u001b\u0010\u00a0\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a2\u00010\u00a1\u0001*\u000200H\u0002\u00a2\u0006\u0003\u0010\u00a3\u0001R\u001c\u0010\u001a\u001a\u00020\u001b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010*R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00103R\u0014\u00107\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010*R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001c\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010<0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bA\u0010\u001d\u001a\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020E8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bF\u0010\u001d\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010*R\u001b\u0010K\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bM\u0010N\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00a4\u0001"}, d2={"Landroidx/compose/ui/text/AndroidParagraph;", "Landroidx/compose/ui/text/Paragraph;", "text", "", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "density", "Landroidx/compose/ui/unit/Density;", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;IZJLandroidx/compose/ui/text/font/FontFamily$Resolver;Landroidx/compose/ui/unit/Density;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;", "(Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;IZJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "charSequence", "", "getCharSequence$ui_text_release$annotations", "()V", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "getConstraints-msEJaDk", "()J", "J", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layout", "Landroidx/compose/ui/text/android/TextLayout;", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "getParagraphIntrinsics", "()Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;", "placeholderRects", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "textLocale", "Ljava/util/Locale;", "getTextLocale$ui_text_release$annotations", "getTextLocale$ui_text_release", "()Ljava/util/Locale;", "textPaint", "Landroidx/compose/ui/text/platform/AndroidTextPaint;", "getTextPaint$ui_text_release$annotations", "getTextPaint$ui_text_release", "()Landroidx/compose/ui/text/platform/AndroidTextPaint;", "width", "getWidth", "wordBoundary", "Landroidx/compose/ui/text/android/selection/WordBoundary;", "getWordBoundary", "()Landroidx/compose/ui/text/android/selection/WordBoundary;", "wordBoundary$delegate", "Lkotlin/Lazy;", "constructTextLayout", "alignment", "justificationMode", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "hyphens", "breakStrategy", "lineBreakStyle", "lineBreakWordStyle", "fillBoundingBoxes", "", "range", "Landroidx/compose/ui/text/TextRange;", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineAscent", "lineIndex", "getLineAscent$ui_text_release", "getLineBaseline", "getLineBaseline$ui_text_release", "getLineBottom", "getLineDescent", "getLineDescent$ui_text_release", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getWordBoundary--jx7JFs", "(I)J", "isLineEllipsized", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "color", "Landroidx/compose/ui/graphics/Color;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "getShaderBrushSpans", "", "Landroidx/compose/ui/text/platform/style/ShaderBrushSpan;", "(Landroidx/compose/ui/text/android/TextLayout;)[Landroidx/compose/ui/text/platform/style/ShaderBrushSpan;", "ui-text_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidParagraph.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidParagraph.android.kt\nandroidx/compose/ui/text/AndroidParagraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,623:1\n1#2:624\n13579#3,2:625\n11335#3:627\n11670#3,3:628\n26#4:631\n26#4:632\n*S KotlinDebug\n*F\n+ 1 AndroidParagraph.android.kt\nandroidx/compose/ui/text/AndroidParagraph\n*L\n205#1:625,2\n245#1:627\n245#1:628,3\n441#1:631\n445#1:632\n*E\n"})
public final class AndroidParagraph
implements Paragraph {
    @NotNull
    private final AndroidParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final boolean ellipsis;
    private final long constraints;
    @NotNull
    private final TextLayout layout;
    @NotNull
    private final CharSequence charSequence;
    @NotNull
    private final List<Rect> placeholderRects;
    @NotNull
    private final Lazy wordBoundary$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private AndroidParagraph(AndroidParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, long constraints) {
        List list;
        void $this$placeholderRects_u24lambda_u246;
        int calculatedMaxLines;
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.constraints = constraints;
        if (!(Constraints.getMinHeight-impl((long)this.constraints) == 0 && Constraints.getMinWidth-impl((long)this.constraints) == 0)) {
            boolean $i$a$-require-AndroidParagraph$32 = false;
            String $i$a$-require-AndroidParagraph$32 = "Setting Constraints.minWidth and Constraints.minHeight is not supported, these should be the default zero values instead.";
            throw new IllegalArgumentException($i$a$-require-AndroidParagraph$32.toString());
        }
        if (!(this.maxLines >= 1)) {
            boolean $i$a$-require-AndroidParagraph$42 = false;
            String $i$a$-require-AndroidParagraph$42 = "maxLines should be greater than 0";
            throw new IllegalArgumentException($i$a$-require-AndroidParagraph$42.toString());
        }
        TextStyle style = this.paragraphIntrinsics.getStyle();
        this.charSequence = AndroidParagraph_androidKt.access$shouldAttachIndentationFixSpan(style, this.ellipsis) ? AndroidParagraph_androidKt.access$attachIndentationFixSpan(this.paragraphIntrinsics.getCharSequence$ui_text_release()) : this.paragraphIntrinsics.getCharSequence$ui_text_release();
        int alignment22 = AndroidParagraph_androidKt.access$toLayoutAlign-aXe7zB0(style.getTextAlign-e0LSkKk());
        int justificationMode = TextAlign.equals-impl0(style.getTextAlign-e0LSkKk(), TextAlign.Companion.getJustify-e0LSkKk()) ? 1 : 0;
        int hyphens = AndroidParagraph_androidKt.access$toLayoutHyphenationFrequency--3fSNIE(style.getParagraphStyle$ui_text_release().getHyphens-vmbZdU8());
        int breakStrategy = AndroidParagraph_androidKt.access$toLayoutBreakStrategy-xImikfE(LineBreak.getStrategy-fcGXIks(style.getLineBreak-rAG3T2k()));
        int lineBreakStyle2 = AndroidParagraph_androidKt.access$toLayoutLineBreakStyle-hpcqdu8(LineBreak.getStrictness-usljTpc(style.getLineBreak-rAG3T2k()));
        int lineBreakWordStyle = AndroidParagraph_androidKt.access$toLayoutLineBreakWordStyle-wPN0Rpw(LineBreak.getWordBreak-jp8hJ3c(style.getLineBreak-rAG3T2k()));
        TextUtils.TruncateAt ellipsize = this.ellipsis ? TextUtils.TruncateAt.END : null;
        TextLayout firstLayout = this.constructTextLayout(alignment22, justificationMode, ellipsize, this.maxLines, hyphens, breakStrategy, lineBreakStyle2, lineBreakWordStyle);
        this.layout = this.ellipsis && firstLayout.getHeight() > Constraints.getMaxHeight-impl((long)this.constraints) && this.maxLines > 1 ? ((calculatedMaxLines = AndroidParagraph_androidKt.access$numberOfLinesThatFitMaxHeight(firstLayout, Constraints.getMaxHeight-impl((long)this.constraints))) >= 0 && calculatedMaxLines != this.maxLines ? this.constructTextLayout(alignment22, justificationMode, ellipsize, RangesKt.coerceAtLeast((int)calculatedMaxLines, (int)1), hyphens, breakStrategy, lineBreakStyle2, lineBreakWordStyle) : firstLayout) : firstLayout;
        this.getTextPaint$ui_text_release().setBrush-12SF9DM(style.getBrush(), SizeKt.Size((float)this.getWidth(), (float)this.getHeight()), style.getAlpha());
        ShaderBrushSpan[] $this$forEach$iv = this.getShaderBrushSpans(this.layout);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ShaderBrushSpan element$iv;
            ShaderBrushSpan shaderBrushSpan = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            shaderBrushSpan.setSize-uvyYCjk(SizeKt.Size((float)this.getWidth(), (float)this.getHeight()));
        }
        CharSequence alignment22 = this.charSequence;
        AndroidParagraph androidParagraph = this;
        boolean bl = false;
        if (!($this$placeholderRects_u24lambda_u246 instanceof Spanned)) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv = ((Spanned)$this$placeholderRects_u24lambda_u246).getSpans(0, $this$placeholderRects_u24lambda_u246.length(), PlaceholderSpan.class);
            boolean $i$f$map = false;
            Object[] lineBreakStyle2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                Rect rect;
                boolean isPlaceholderSpanTruncated;
                void span;
                PlaceholderSpan placeholderSpan = (PlaceholderSpan)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                int start = ((Spanned)$this$placeholderRects_u24lambda_u246).getSpanStart((Object)span);
                int end = ((Spanned)$this$placeholderRects_u24lambda_u246).getSpanEnd((Object)span);
                int line = this.layout.getLineForOffset(start);
                boolean exceedsMaxLines = line >= this.maxLines;
                boolean isPlaceholderSpanEllipsized = this.layout.getLineEllipsisCount(line) > 0 && end > this.layout.getLineEllipsisOffset(line);
                boolean bl3 = isPlaceholderSpanTruncated = end > this.layout.getLineEnd(line);
                if (isPlaceholderSpanEllipsized || isPlaceholderSpanTruncated || exceedsMaxLines) {
                    rect = null;
                } else {
                    float f;
                    float f2;
                    ResolvedTextDirection direction = this.getBidiRunDirection(start);
                    switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                        case 1: {
                            f2 = this.getHorizontalPosition(start, true);
                            break;
                        }
                        case 2: {
                            f2 = this.getHorizontalPosition(start, true) - (float)span.getWidthPx();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    float left = f2;
                    float right = left + (float)span.getWidthPx();
                    TextLayout $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244 = this.layout;
                    boolean bl4 = false;
                    switch (span.getVerticalAlign()) {
                        case 0: {
                            f = $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBaseline(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 1: {
                            f = $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineTop(line);
                            break;
                        }
                        case 2: {
                            f = $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBottom(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 3: {
                            f = ($this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineTop(line) + $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBottom(line) - (float)span.getHeightPx()) / (float)2;
                            break;
                        }
                        case 4: {
                            f = (float)span.getFontMetrics().ascent + $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBaseline(line);
                            break;
                        }
                        case 5: {
                            f = (float)span.getFontMetrics().descent + $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBaseline(line) - (float)span.getHeightPx();
                            break;
                        }
                        case 6: {
                            Paint.FontMetricsInt $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = span.getFontMetrics();
                            boolean bl5 = false;
                            f = (float)(($this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.ascent + $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.descent - span.getHeightPx()) / 2) + $this$placeholderRects_u24lambda_u246_u24lambda_u245_u24lambda_u244.getLineBaseline(line);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unexpected verticalAlignment");
                        }
                    }
                    float top = f;
                    float bottom = top + (float)span.getHeightPx();
                    rect = new Rect(left, top, right, bottom);
                }
                collection.add(rect);
            }
            list = (List)destination$iv$iv;
        }
        androidParagraph.placeholderRects = list;
        this.wordBoundary$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<WordBoundary>(this){
            final /* synthetic */ AndroidParagraph this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WordBoundary invoke() {
                return new WordBoundary(this.this$0.getTextLocale$ui_text_release(), AndroidParagraph.access$getLayout$p(this.this$0).getText());
            }
        }));
    }

    @NotNull
    public final AndroidParagraphIntrinsics getParagraphIntrinsics() {
        return this.paragraphIntrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    private AndroidParagraph(String text, TextStyle style, List<AnnotatedString.Range<SpanStyle>> spanStyles, List<AnnotatedString.Range<Placeholder>> placeholders, int maxLines, boolean ellipsis, long constraints, FontFamily.Resolver fontFamilyResolver, Density density) {
        this(new AndroidParagraphIntrinsics(text, style, spanStyles, placeholders, fontFamilyResolver, density), maxLines, ellipsis, constraints, null);
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.charSequence;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCharSequence$ui_text_release$annotations() {
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl((long)this.constraints);
    }

    @Override
    public float getHeight() {
        return this.layout.getHeight();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        return this.getLineBaseline$ui_text_release(0);
    }

    @Override
    public float getLastBaseline() {
        return this.getLineBaseline$ui_text_release(this.getLineCount() - 1);
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.layout.getDidExceedMaxLines();
    }

    @NotNull
    public final Locale getTextLocale$ui_text_release() {
        return this.paragraphIntrinsics.getTextPaint$ui_text_release().getTextLocale();
    }

    @VisibleForTesting
    public static /* synthetic */ void getTextLocale$ui_text_release$annotations() {
    }

    @Override
    public int getLineCount() {
        return this.layout.getLineCount();
    }

    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final AndroidTextPaint getTextPaint$ui_text_release() {
        return this.paragraphIntrinsics.getTextPaint$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void getTextPaint$ui_text_release$annotations() {
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        return this.layout.getLineForVertical((int)vertical);
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        int line = this.layout.getLineForVertical((int)Offset.getY-impl((long)position));
        return this.layout.getOffsetForHorizontal(line, Offset.getX-impl((long)position));
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        RectF rectF;
        if (!(0 <= offset ? offset < this.charSequence.length() : false)) {
            boolean $i$a$-require-AndroidParagraph$getBoundingBox$22 = false;
            String $i$a$-require-AndroidParagraph$getBoundingBox$22 = "offset(" + offset + ") is out of bounds [0," + this.charSequence.length() + ')';
            throw new IllegalArgumentException($i$a$-require-AndroidParagraph$getBoundingBox$22.toString());
        }
        RectF $this$getBoundingBox_u24lambda_u248 = rectF = this.layout.getBoundingBox(offset);
        boolean bl = false;
        return new Rect($this$getBoundingBox_u24lambda_u248.left, $this$getBoundingBox_u24lambda_u248.top, $this$getBoundingBox_u24lambda_u248.right, $this$getBoundingBox_u24lambda_u248.bottom);
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long range, @NotNull float[] array, @IntRange(from=0L) int arrayStart) {
        this.layout.fillBoundingBoxes(TextRange.getMin-impl(range), TextRange.getMax-impl(range), array, arrayStart);
    }

    @Override
    @NotNull
    public Path getPathForRange(int start, int end) {
        if (!((0 <= start ? start <= end : false) && end <= this.charSequence.length())) {
            boolean bl = false;
            String string = "start(" + start + ") or end(" + end + ") is out of range [0.." + this.charSequence.length() + "], or start > end!";
            throw new IllegalArgumentException(string.toString());
        }
        android.graphics.Path path = new android.graphics.Path();
        this.layout.getSelectionPath(start, end, path);
        return AndroidPath_androidKt.asComposePath((android.graphics.Path)path);
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        if (!(0 <= offset ? offset <= this.charSequence.length() : false)) {
            boolean $i$a$-require-AndroidParagraph$getCursorRect$22 = false;
            String $i$a$-require-AndroidParagraph$getCursorRect$22 = "offset(" + offset + ") is out of bounds [0," + this.charSequence.length() + ']';
            throw new IllegalArgumentException($i$a$-require-AndroidParagraph$getCursorRect$22.toString());
        }
        float horizontal = TextLayout.getPrimaryHorizontal$default(this.layout, offset, false, 2, null);
        int line = this.layout.getLineForOffset(offset);
        return new Rect(horizontal, this.layout.getLineTop(line), horizontal, this.layout.getLineBottom(line));
    }

    private final WordBoundary getWordBoundary() {
        Lazy lazy = this.wordBoundary$delegate;
        return (WordBoundary)lazy.getValue();
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        return TextRangeKt.TextRange(this.getWordBoundary().getWordStart(offset), this.getWordBoundary().getWordEnd(offset));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex);
    }

    @Override
    public float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex);
    }

    @Override
    public float getLineTop(int lineIndex) {
        return this.layout.getLineTop(lineIndex);
    }

    public final float getLineAscent$ui_text_release(int lineIndex) {
        return this.layout.getLineAscent(lineIndex);
    }

    public final float getLineBaseline$ui_text_release(int lineIndex) {
        return this.layout.getLineBaseline(lineIndex);
    }

    public final float getLineDescent$ui_text_release(int lineIndex) {
        return this.layout.getLineDescent(lineIndex);
    }

    @Override
    public float getLineBottom(int lineIndex) {
        return this.layout.getLineBottom(lineIndex);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        return this.layout.getLineHeight(lineIndex);
    }

    @Override
    public float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    @Override
    public int getLineStart(int lineIndex) {
        return this.layout.getLineStart(lineIndex);
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        return visibleEnd ? this.layout.getLineVisibleEnd(lineIndex) : this.layout.getLineEnd(lineIndex);
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return this.layout.isLineEllipsized(lineIndex);
    }

    @Override
    public int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        return usePrimaryDirection ? TextLayout.getPrimaryHorizontal$default(this.layout, offset, false, 2, null) : TextLayout.getSecondaryHorizontal$default(this.layout, offset, false, 2, null);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        int lineIndex = this.layout.getLineForOffset(offset);
        int direction = this.layout.getParagraphDirection(lineIndex);
        return direction == 1 ? ResolvedTextDirection.Ltr : ResolvedTextDirection.Rtl;
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        return this.layout.isRtlCharAt(offset) ? ResolvedTextDirection.Rtl : ResolvedTextDirection.Ltr;
    }

    private final ShaderBrushSpan[] getShaderBrushSpans(TextLayout $this$getShaderBrushSpans) {
        if (!($this$getShaderBrushSpans.getText() instanceof Spanned)) {
            boolean $i$f$emptyArray = false;
            return new ShaderBrushSpan[0];
        }
        CharSequence charSequence = $this$getShaderBrushSpans.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        ShaderBrushSpan[] brushSpans = (ShaderBrushSpan[])((Spanned)charSequence).getSpans(0, $this$getShaderBrushSpans.getText().length(), ShaderBrushSpan.class);
        if (brushSpans.length == 0) {
            boolean $i$f$emptyArray = false;
            return new ShaderBrushSpan[0];
        }
        return brushSpans;
    }

    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        AndroidTextPaint $this$paint_RPmYEkk_u24lambda_u2411 = this.getTextPaint$ui_text_release();
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u2411.setColor-8_81llA(color);
        $this$paint_RPmYEkk_u24lambda_u2411.setShadow(shadow);
        $this$paint_RPmYEkk_u24lambda_u2411.setTextDecoration(textDecoration);
        this.paint(canvas);
    }

    @Override
    public void paint-LG529CI(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        int currBlendMode = this.getTextPaint$ui_text_release().getBlendMode-0nO6VwU();
        AndroidTextPaint $this$paint_LG529CI_u24lambda_u2412 = this.getTextPaint$ui_text_release();
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2412.setColor-8_81llA(color);
        $this$paint_LG529CI_u24lambda_u2412.setShadow(shadow);
        $this$paint_LG529CI_u24lambda_u2412.setTextDecoration(textDecoration);
        $this$paint_LG529CI_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        this.paint(canvas);
        this.getTextPaint$ui_text_release().setBlendMode-s9anfk8(currBlendMode);
    }

    @Override
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        int currBlendMode = this.getTextPaint$ui_text_release().getBlendMode-0nO6VwU();
        AndroidTextPaint $this$paint_hn5TExg_u24lambda_u2413 = this.getTextPaint$ui_text_release();
        boolean bl = false;
        $this$paint_hn5TExg_u24lambda_u2413.setBrush-12SF9DM(brush, SizeKt.Size((float)this.getWidth(), (float)this.getHeight()), alpha);
        $this$paint_hn5TExg_u24lambda_u2413.setShadow(shadow);
        $this$paint_hn5TExg_u24lambda_u2413.setTextDecoration(textDecoration);
        $this$paint_hn5TExg_u24lambda_u2413.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2413.setBlendMode-s9anfk8(blendMode);
        this.paint(canvas);
        this.getTextPaint$ui_text_release().setBlendMode-s9anfk8(currBlendMode);
    }

    private final void paint(Canvas canvas) {
        android.graphics.Canvas nativeCanvas = AndroidCanvas_androidKt.getNativeCanvas((Canvas)canvas);
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.save();
            nativeCanvas.clipRect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        this.layout.paint(nativeCanvas);
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.restore();
        }
    }

    private final TextLayout constructTextLayout(int alignment, int justificationMode, TextUtils.TruncateAt ellipsize, int maxLines, int hyphens, int breakStrategy, int lineBreakStyle, int lineBreakWordStyle) {
        CharSequence charSequence = this.charSequence;
        float f = this.getWidth();
        AndroidTextPaint androidTextPaint = this.getTextPaint$ui_text_release();
        int n = this.paragraphIntrinsics.getTextDirectionHeuristic$ui_text_release();
        LayoutIntrinsics layoutIntrinsics = this.paragraphIntrinsics.getLayoutIntrinsics$ui_text_release();
        boolean bl = AndroidParagraphHelper_androidKt.isIncludeFontPaddingEnabled(this.paragraphIntrinsics.getStyle());
        return new TextLayout(charSequence, f, androidTextPaint, alignment, ellipsize, n, 1.0f, 0.0f, bl, true, maxLines, breakStrategy, lineBreakStyle, lineBreakWordStyle, hyphens, justificationMode, null, null, layoutIntrinsics, 196736, null);
    }

    public /* synthetic */ AndroidParagraph(AndroidParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(paragraphIntrinsics, maxLines, ellipsis, constraints);
    }

    public /* synthetic */ AndroidParagraph(String text, TextStyle style, List spanStyles, List placeholders, int maxLines, boolean ellipsis, long constraints, FontFamily.Resolver fontFamilyResolver, Density density, DefaultConstructorMarker $constructor_marker) {
        this(text, style, spanStyles, placeholders, maxLines, ellipsis, constraints, fontFamilyResolver, density);
    }

    public static final /* synthetic */ TextLayout access$getLayout$p(AndroidParagraph $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResolvedTextDirection.values().length];
            try {
                nArray[ResolvedTextDirection.Ltr.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolvedTextDirection.Rtl.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

