/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import androidx.compose.ui.text.android.PaintExtensionsKt;
import androidx.compose.ui.text.android.StaticLayoutFactory;
import androidx.compose.ui.text.android.TextAndroidCanvas;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.VerticalPaddings;
import androidx.compose.ui.text.android.style.LineHeightStyleSpan;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a1\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u001f\u0010\u0017\u001a\u00020\u0003*\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u0011\u0010\u001b\u001a\u00020\u0003*\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0004\u00a8\u0006!"}, d2={"SharedTextAndroidCanvas", "Landroidx/compose/ui/text/android/TextAndroidCanvas;", "ZeroVerticalPadding", "Landroidx/compose/ui/text/android/VerticalPaddings;", "J", "VerticalPaddings", "topPadding", "", "bottomPadding", "(II)J", "getTextDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "textDirectionHeuristic", "getLastLineMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "Landroidx/compose/ui/text/android/TextLayout;", "textPaint", "Landroid/text/TextPaint;", "frameworkTextDir", "lineHeightSpans", "", "Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "(Landroidx/compose/ui/text/android/TextLayout;Landroid/text/TextPaint;Landroid/text/TextDirectionHeuristic;[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;)Landroid/graphics/Paint$FontMetricsInt;", "getLineHeightPaddings", "(Landroidx/compose/ui/text/android/TextLayout;[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;)J", "getLineHeightSpans", "(Landroidx/compose/ui/text/android/TextLayout;)[Landroidx/compose/ui/text/android/style/LineHeightStyleSpan;", "getVerticalPaddings", "(Landroidx/compose/ui/text/android/TextLayout;)J", "isLineEllipsized", "", "Landroid/text/Layout;", "lineIndex", "ui-text_release"})
@SourceDebugExtension(value={"SMAP\nTextLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayout.kt\nandroidx/compose/ui/text/android/TextLayoutKt\n+ 2 InlineClassUtils.kt\nandroidx/compose/ui/text/android/InlineClassUtilsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,1031:1\n25#2:1032\n26#3:1033\n26#3:1034\n*S KotlinDebug\n*F\n+ 1 TextLayout.kt\nandroidx/compose/ui/text/android/TextLayoutKt\n*L\n884#1:1032\n1022#1:1033\n1026#1:1034\n*E\n"})
public final class TextLayoutKt {
    @NotNull
    private static final TextAndroidCanvas SharedTextAndroidCanvas = new TextAndroidCanvas();
    private static final long ZeroVerticalPadding = TextLayoutKt.VerticalPaddings(0, 0);

    @NotNull
    public static final TextDirectionHeuristic getTextDirectionHeuristic(int textDirectionHeuristic) {
        TextDirectionHeuristic textDirectionHeuristic2;
        switch (textDirectionHeuristic) {
            case 0: {
                textDirectionHeuristic2 = TextDirectionHeuristics.LTR;
                break;
            }
            case 5: {
                textDirectionHeuristic2 = TextDirectionHeuristics.LOCALE;
                break;
            }
            case 1: {
                textDirectionHeuristic2 = TextDirectionHeuristics.RTL;
                break;
            }
            case 3: {
                textDirectionHeuristic2 = TextDirectionHeuristics.FIRSTSTRONG_RTL;
                break;
            }
            case 4: {
                textDirectionHeuristic2 = TextDirectionHeuristics.ANYRTL_LTR;
                break;
            }
            case 2: {
                textDirectionHeuristic2 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
                break;
            }
            default: {
                textDirectionHeuristic2 = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
        }
        return textDirectionHeuristic2;
    }

    public static final long VerticalPaddings(int topPadding, int bottomPadding) {
        boolean $i$f$packInts = false;
        return VerticalPaddings.constructor-impl((long)topPadding << 32 | (long)bottomPadding & 0xFFFFFFFFL);
    }

    private static final long getVerticalPaddings(TextLayout $this$getVerticalPaddings) {
        Rect rect;
        int topPadding;
        if ($this$getVerticalPaddings.getIncludePadding() || $this$getVerticalPaddings.isFallbackLinespacingApplied$ui_text_release()) {
            return ZeroVerticalPadding;
        }
        TextPaint paint = $this$getVerticalPaddings.getLayout().getPaint();
        CharSequence text = $this$getVerticalPaddings.getLayout().getText();
        Rect firstLineTextBounds = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(0), $this$getVerticalPaddings.getLayout().getLineEnd(0));
        int ascent = $this$getVerticalPaddings.getLayout().getLineAscent(0);
        int n = topPadding = firstLineTextBounds.top < ascent ? ascent - firstLineTextBounds.top : $this$getVerticalPaddings.getLayout().getTopPadding();
        if ($this$getVerticalPaddings.getLineCount() == 1) {
            rect = firstLineTextBounds;
        } else {
            int line = $this$getVerticalPaddings.getLineCount() - 1;
            rect = PaintExtensionsKt.getCharSequenceBounds(paint, text, $this$getVerticalPaddings.getLayout().getLineStart(line), $this$getVerticalPaddings.getLayout().getLineEnd(line));
        }
        Rect lastLineTextBounds = rect;
        int descent = $this$getVerticalPaddings.getLayout().getLineDescent($this$getVerticalPaddings.getLineCount() - 1);
        int bottomPadding = lastLineTextBounds.bottom > descent ? lastLineTextBounds.bottom - descent : $this$getVerticalPaddings.getLayout().getBottomPadding();
        return topPadding == 0 && bottomPadding == 0 ? ZeroVerticalPadding : TextLayoutKt.VerticalPaddings(topPadding, bottomPadding);
    }

    private static final long getLineHeightPaddings(TextLayout $this$getLineHeightPaddings, LineHeightStyleSpan[] lineHeightSpans) {
        int firstAscentDiff = 0;
        int lastDescentDiff = 0;
        for (LineHeightStyleSpan span : lineHeightSpans) {
            if (span.getFirstAscentDiff() < 0) {
                firstAscentDiff = Math.max(firstAscentDiff, Math.abs(span.getFirstAscentDiff()));
            }
            if (span.getLastDescentDiff() >= 0) continue;
            lastDescentDiff = Math.max(firstAscentDiff, Math.abs(span.getLastDescentDiff()));
        }
        return firstAscentDiff == 0 && lastDescentDiff == 0 ? ZeroVerticalPadding : TextLayoutKt.VerticalPaddings(firstAscentDiff, lastDescentDiff);
    }

    private static final Paint.FontMetricsInt getLastLineMetrics(TextLayout $this$getLastLineMetrics, TextPaint textPaint, TextDirectionHeuristic frameworkTextDir, LineHeightStyleSpan[] lineHeightSpans) {
        int lastLine = $this$getLastLineMetrics.getLineCount() - 1;
        if ($this$getLastLineMetrics.getLayout().getLineStart(lastLine) == $this$getLastLineMetrics.getLayout().getLineEnd(lastLine) && !(lineHeightSpans.length == 0)) {
            Paint.FontMetricsInt fontMetricsInt;
            SpannableString emptyText = new SpannableString((CharSequence)"\u200b");
            LineHeightStyleSpan lineHeightSpan = (LineHeightStyleSpan)ArraysKt.first((Object[])lineHeightSpans);
            LineHeightStyleSpan newLineHeightSpan = lineHeightSpan.copy$ui_text_release(0, emptyText.length(), lastLine != 0 && lineHeightSpan.getTrimLastLineBottom() ? false : lineHeightSpan.getTrimLastLineBottom());
            emptyText.setSpan((Object)newLineHeightSpan, 0, emptyText.length(), 33);
            StaticLayout tmpLayout = StaticLayoutFactory.create$default(StaticLayoutFactory.INSTANCE, (CharSequence)emptyText, textPaint, Integer.MAX_VALUE, 0, emptyText.length(), frameworkTextDir, null, 0, null, 0, 0.0f, 0.0f, 0, $this$getLastLineMetrics.getIncludePadding(), $this$getLastLineMetrics.getFallbackLineSpacing(), 0, 0, 0, 0, null, null, 2072512, null);
            Paint.FontMetricsInt $this$getLastLineMetrics_u24lambda_u240 = fontMetricsInt = new Paint.FontMetricsInt();
            boolean bl = false;
            $this$getLastLineMetrics_u24lambda_u240.ascent = tmpLayout.getLineAscent(0);
            $this$getLastLineMetrics_u24lambda_u240.descent = tmpLayout.getLineDescent(0);
            $this$getLastLineMetrics_u24lambda_u240.top = tmpLayout.getLineTop(0);
            $this$getLastLineMetrics_u24lambda_u240.bottom = tmpLayout.getLineBottom(0);
            Paint.FontMetricsInt lastLineFontMetrics = fontMetricsInt;
            return lastLineFontMetrics;
        }
        return null;
    }

    private static final LineHeightStyleSpan[] getLineHeightSpans(TextLayout $this$getLineHeightSpans) {
        if (!($this$getLineHeightSpans.getText() instanceof Spanned)) {
            boolean $i$f$emptyArray = false;
            return new LineHeightStyleSpan[0];
        }
        CharSequence charSequence = $this$getLineHeightSpans.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        LineHeightStyleSpan[] lineHeightStyleSpans = (LineHeightStyleSpan[])((Spanned)charSequence).getSpans(0, $this$getLineHeightSpans.getText().length(), LineHeightStyleSpan.class);
        if (lineHeightStyleSpans.length == 0) {
            boolean $i$f$emptyArray = false;
            return new LineHeightStyleSpan[0];
        }
        return lineHeightStyleSpans;
    }

    public static final boolean isLineEllipsized(@NotNull Layout $this$isLineEllipsized, int lineIndex) {
        return $this$isLineEllipsized.getEllipsisCount(lineIndex) > 0;
    }

    public static final /* synthetic */ long access$getVerticalPaddings(TextLayout $receiver) {
        return TextLayoutKt.getVerticalPaddings($receiver);
    }

    public static final /* synthetic */ LineHeightStyleSpan[] access$getLineHeightSpans(TextLayout $receiver) {
        return TextLayoutKt.getLineHeightSpans($receiver);
    }

    public static final /* synthetic */ long access$getLineHeightPaddings(TextLayout $receiver, LineHeightStyleSpan[] lineHeightSpans) {
        return TextLayoutKt.getLineHeightPaddings($receiver, lineHeightSpans);
    }

    public static final /* synthetic */ Paint.FontMetricsInt access$getLastLineMetrics(TextLayout $receiver, TextPaint textPaint, TextDirectionHeuristic frameworkTextDir, LineHeightStyleSpan[] lineHeightSpans) {
        return TextLayoutKt.getLastLineMetrics($receiver, textPaint, frameworkTextDir, lineHeightSpans);
    }

    public static final /* synthetic */ TextAndroidCanvas access$getSharedTextAndroidCanvas$p() {
        return SharedTextAndroidCanvas;
    }
}

