/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import android.graphics.Typeface;
import androidx.compose.runtime.State;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.android.LayoutIntrinsics;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.TypefaceResult;
import androidx.compose.ui.text.platform.AndroidParagraphHelper_androidKt;
import androidx.compose.ui.text.platform.AndroidParagraphIntrinsics_androidKt;
import androidx.compose.ui.text.platform.AndroidTextPaint;
import androidx.compose.ui.text.platform.EmojiCompatStatus;
import androidx.compose.ui.text.platform.TypefaceDirtyTrackerLinkedList;
import androidx.compose.ui.text.platform.extensions.TextPaintExtensions_androidKt;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u000206X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Landroidx/compose/ui/text/platform/AndroidParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "text", "", "style", "Landroidx/compose/ui/text/TextStyle;", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "density", "Landroidx/compose/ui/unit/Density;", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/text/font/FontFamily$Resolver;Landroidx/compose/ui/unit/Density;)V", "charSequence", "", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "emojiCompatProcessed", "", "getFontFamilyResolver", "()Landroidx/compose/ui/text/font/FontFamily$Resolver;", "hasStaleResolvedFonts", "getHasStaleResolvedFonts", "()Z", "layoutIntrinsics", "Landroidx/compose/ui/text/android/LayoutIntrinsics;", "getLayoutIntrinsics$ui_text_release", "()Landroidx/compose/ui/text/android/LayoutIntrinsics;", "maxIntrinsicWidth", "", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "getPlaceholders", "()Ljava/util/List;", "resolvedTypefaces", "Landroidx/compose/ui/text/platform/TypefaceDirtyTrackerLinkedList;", "getSpanStyles", "getStyle", "()Landroidx/compose/ui/text/TextStyle;", "getText", "()Ljava/lang/String;", "textDirectionHeuristic", "", "getTextDirectionHeuristic$ui_text_release", "()I", "textPaint", "Landroidx/compose/ui/text/platform/AndroidTextPaint;", "getTextPaint$ui_text_release", "()Landroidx/compose/ui/text/platform/AndroidTextPaint;", "ui-text_release"})
public final class AndroidParagraphIntrinsics
implements ParagraphIntrinsics {
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final List<AnnotatedString.Range<SpanStyle>> spanStyles;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @NotNull
    private final Density density;
    @NotNull
    private final AndroidTextPaint textPaint;
    @NotNull
    private final CharSequence charSequence;
    @NotNull
    private final LayoutIntrinsics layoutIntrinsics;
    @Nullable
    private TypefaceDirtyTrackerLinkedList resolvedTypefaces;
    private final boolean emojiCompatProcessed;
    private final int textDirectionHeuristic;

    /*
     * WARNING - void declaration
     */
    public AndroidParagraphIntrinsics(@NotNull String text, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull FontFamily.Resolver fontFamilyResolver, @NotNull Density density) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.text = text;
        this.style = style;
        this.spanStyles = spanStyles;
        this.placeholders = placeholders;
        this.fontFamilyResolver = fontFamilyResolver;
        this.density = density;
        this.textPaint = new AndroidTextPaint(1, this.density.getDensity());
        this.emojiCompatProcessed = !AndroidParagraphIntrinsics_androidKt.access$getHasEmojiCompat(this.style) ? false : (Boolean)EmojiCompatStatus.INSTANCE.getFontLoaded().getValue();
        this.textDirectionHeuristic = AndroidParagraphIntrinsics_androidKt.resolveTextDirectionHeuristics-9GRLPo0(this.style.getTextDirection-mmuk1to(), this.style.getLocaleList());
        Function4 resolveTypeface2 = (Function4)new Function4<FontFamily, FontWeight, FontStyle, FontSynthesis, Typeface>(this){
            final /* synthetic */ AndroidParagraphIntrinsics this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final Typeface invoke-DPcqOEQ(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle, int fontSynthesis) {
                Typeface typeface2;
                Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
                State<Object> result2 = this.this$0.getFontFamilyResolver().resolve-DPcqOEQ(fontFamily, fontWeight, fontStyle, fontSynthesis);
                if (!(result2 instanceof TypefaceResult.Immutable)) {
                    TypefaceDirtyTrackerLinkedList newHead = new TypefaceDirtyTrackerLinkedList(result2, AndroidParagraphIntrinsics.access$getResolvedTypefaces$p(this.this$0));
                    AndroidParagraphIntrinsics.access$setResolvedTypefaces$p(this.this$0, newHead);
                    typeface2 = newHead.getTypeface();
                } else {
                    Object object = result2.getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.graphics.Typeface");
                    typeface2 = (Typeface)object;
                }
                return typeface2;
            }
        };
        TextPaintExtensions_androidKt.setTextMotion(this.textPaint, this.style.getTextMotion());
        SpanStyle notAppliedStyle = TextPaintExtensions_androidKt.applySpanStyle(this.textPaint, this.style.toSpanStyle(), (Function4<? super FontFamily, ? super FontWeight, ? super FontStyle, ? super FontSynthesis, ? extends Typeface>)resolveTypeface2, this.density, !((Collection)this.spanStyles).isEmpty());
        if (notAppliedStyle != null) {
            int n = this.spanStyles.size() + 1;
            ArrayList<AnnotatedString.Range<SpanStyle>> arrayList = new ArrayList<AnnotatedString.Range<SpanStyle>>(n);
            for (int i = 0; i < n; ++i) {
                AnnotatedString.Range<SpanStyle> range;
                void position;
                int n2;
                int n3 = n2 = i;
                ArrayList<AnnotatedString.Range<SpanStyle>> arrayList2 = arrayList;
                boolean bl = false;
                if (position == false) {
                    AnnotatedString.Range<SpanStyle> range2;
                    range = range2;
                    super(notAppliedStyle, 0, this.text.length());
                } else {
                    range = this.spanStyles.get((int)(position - true));
                }
                arrayList2.add(range);
            }
            list = arrayList;
        } else {
            list = this.spanStyles;
        }
        List finalSpanStyles = list;
        this.charSequence = AndroidParagraphHelper_androidKt.createCharSequence(this.text, this.textPaint.getTextSize(), this.style, finalSpanStyles, this.placeholders, this.density, (Function4<? super FontFamily, ? super FontWeight, ? super FontStyle, ? super FontSynthesis, ? extends Typeface>)resolveTypeface2, this.emojiCompatProcessed);
        this.layoutIntrinsics = new LayoutIntrinsics(this.charSequence, this.textPaint, this.textDirectionHeuristic);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final List<AnnotatedString.Range<SpanStyle>> getSpanStyles() {
        return this.spanStyles;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @NotNull
    public final FontFamily.Resolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final AndroidTextPaint getTextPaint$ui_text_release() {
        return this.textPaint;
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.charSequence;
    }

    @NotNull
    public final LayoutIntrinsics getLayoutIntrinsics$ui_text_release() {
        return this.layoutIntrinsics;
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.layoutIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.layoutIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public boolean getHasStaleResolvedFonts() {
        TypefaceDirtyTrackerLinkedList typefaceDirtyTrackerLinkedList = this.resolvedTypefaces;
        return (typefaceDirtyTrackerLinkedList != null ? typefaceDirtyTrackerLinkedList.isStaleResolvedFont() : false) || !this.emojiCompatProcessed && AndroidParagraphIntrinsics_androidKt.access$getHasEmojiCompat(this.style) && (Boolean)EmojiCompatStatus.INSTANCE.getFontLoaded().getValue() != false;
    }

    public final int getTextDirectionHeuristic$ui_text_release() {
        return this.textDirectionHeuristic;
    }

    public static final /* synthetic */ TypefaceDirtyTrackerLinkedList access$getResolvedTypefaces$p(AndroidParagraphIntrinsics $this) {
        return $this.resolvedTypefaces;
    }

    public static final /* synthetic */ void access$setResolvedTypefaces$p(AndroidParagraphIntrinsics $this, TypefaceDirtyTrackerLinkedList typefaceDirtyTrackerLinkedList) {
        $this.resolvedTypefaces = typefaceDirtyTrackerLinkedList;
    }
}

