/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.test.InputDispatcherState;
import androidx.compose.ui.test.MouseInputState;
import androidx.compose.ui.test.PartialGesture;
import androidx.compose.ui.test.TestContext;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u001f\b \u0018\u0000 c2\u00020\u0001:\u0001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\fJ\u0006\u0010)\u001a\u00020'J\u0006\u0010*\u001a\u00020'J\u001b\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b-\u0010\u000fJ\u001b\u0010.\u001a\u00020'2\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b/\u0010\u000fJ\u001b\u00100\u001a\u00020'2\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u0010\u000fJ\u000e\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020'2\u0006\u00103\u001a\u000204J#\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b;\u0010<J\u0006\u0010=\u001a\u00020'J#\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u0002042\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b@\u0010AJ\u0006\u0010B\u001a\u00020'J+\u0010C\u001a\u00020'2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\f0E2\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0E0E\u00f8\u0001\u0000J\u000e\u0010G\u001a\u00020'2\u0006\u0010?\u001a\u000204J\b\u0010H\u001a\u00020'H&J\u001e\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010?\u001a\u000204\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\bJJ\u001d\u0010K\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\bH\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bL\u0010MJ\b\u0010N\u001a\u00020'H\u0014J\u0012\u0010O\u001a\u00020'2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\u001b\u0010P\u001a\u00020'2\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bQ\u0010\u000fJ#\u0010R\u001a\u00020'2\u0006\u0010?\u001a\u0002042\u0006\u0010,\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bS\u0010AJ\f\u0010T\u001a\u00020'*\u00020\u0014H$J\f\u0010T\u001a\u00020'*\u00020\u001aH$J\u0014\u0010U\u001a\u00020'*\u00020\u001a2\u0006\u0010?\u001a\u000204H$J\f\u0010V\u001a\u00020'*\u00020\u0014H$J\f\u0010W\u001a\u00020'*\u00020\u0014H$J\f\u0010X\u001a\u00020'*\u00020\u0014H$J\f\u0010X\u001a\u00020'*\u00020\u001aH$J1\u0010Y\u001a\u00020'*\u00020\u001a2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\f0E2\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0E0EH$\u00f8\u0001\u0000J\u0014\u0010Z\u001a\u00020'*\u00020\u00142\u0006\u00103\u001a\u000204H$J\u0014\u0010[\u001a\u00020'*\u00020\u00142\u0006\u00103\u001a\u000204H$J)\u0010\\\u001a\u00020'*\u00020\u00142\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H$\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b]\u0010^J\u0014\u0010_\u001a\u00020'*\u00020\u001a2\u0006\u0010?\u001a\u000204H$J\f\u0010`\u001a\u00020'*\u00020\u0014H\u0002J\f\u0010a\u001a\u00020'*\u00020\u0014H\u0002J\f\u0010b\u001a\u00020'*\u00020\u001aH\u0002R\u001a\u0010\u0007\u001a\u00020\b8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\u00020 *\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010\u000b\u001a\u00020\f*\u00020\u00038BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010$\u001a\u0004\b\r\u0010%\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006d"}, d2={"Landroidx/compose/ui/test/InputDispatcher;", "", "testContext", "Landroidx/compose/ui/test/TestContext;", "root", "Landroidx/compose/ui/node/RootForTest;", "(Landroidx/compose/ui/test/TestContext;Landroidx/compose/ui/node/RootForTest;)V", "currentMousePosition", "Landroidx/compose/ui/geometry/Offset;", "getCurrentMousePosition-F1C5BW0", "()J", "currentTime", "", "getCurrentTime", "setCurrentTime", "(J)V", "isTouchInProgress", "", "()Z", "mouseInputState", "Landroidx/compose/ui/test/MouseInputState;", "getMouseInputState", "()Landroidx/compose/ui/test/MouseInputState;", "setMouseInputState", "(Landroidx/compose/ui/test/MouseInputState;)V", "partialGesture", "Landroidx/compose/ui/test/PartialGesture;", "getPartialGesture", "()Landroidx/compose/ui/test/PartialGesture;", "setPartialGesture", "(Landroidx/compose/ui/test/PartialGesture;)V", "bounds", "Landroidx/compose/ui/geometry/Rect;", "getBounds", "(Landroidx/compose/ui/node/RootForTest;)Landroidx/compose/ui/geometry/Rect;", "getCurrentTime$annotations", "(Landroidx/compose/ui/test/TestContext;)V", "(Landroidx/compose/ui/test/TestContext;)J", "advanceEventTime", "", "durationMillis", "dispose", "enqueueMouseCancel", "enqueueMouseEnter", "position", "enqueueMouseEnter-k-4lQ0M", "enqueueMouseExit", "enqueueMouseExit-k-4lQ0M", "enqueueMouseMove", "enqueueMouseMove-k-4lQ0M", "enqueueMousePress", "buttonId", "", "enqueueMouseRelease", "enqueueMouseScroll", "delta", "", "scrollWheel", "Landroidx/compose/ui/test/ScrollWheel;", "enqueueMouseScroll-I7Dg0i0", "(FI)V", "enqueueTouchCancel", "enqueueTouchDown", "pointerId", "enqueueTouchDown-Uv8p0NA", "(IJ)V", "enqueueTouchMove", "enqueueTouchMoves", "relativeHistoricalTimes", "", "historicalCoordinates", "enqueueTouchUp", "flush", "getCurrentTouchPosition", "getCurrentTouchPosition-x-9fifI", "isWithinRootBounds", "isWithinRootBounds-k-4lQ0M", "(J)Z", "onDispose", "saveState", "updateMousePosition", "updateMousePosition-k-4lQ0M", "updateTouchPointer", "updateTouchPointer-Uv8p0NA", "enqueueCancel", "enqueueDown", "enqueueEnter", "enqueueExit", "enqueueMove", "enqueueMoves", "enqueuePress", "enqueueRelease", "enqueueScroll", "enqueueScroll-0Rp_h_E", "(Landroidx/compose/ui/test/MouseInputState;FI)V", "enqueueUp", "enterHover", "exitHover", "flushPointerUpdates", "Companion", "ui-test_release"})
public abstract class InputDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestContext testContext;
    @NotNull
    private final RootForTest root;
    private long currentTime;
    @Nullable
    private PartialGesture partialGesture;
    @NotNull
    private MouseInputState mouseInputState;
    private static long eventPeriodMillis = 16L;

    public InputDispatcher(@NotNull TestContext testContext, @NotNull RootForTest root) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.testContext = testContext;
        this.root = root;
        this.currentTime = this.getCurrentTime(this.testContext);
        this.mouseInputState = new MouseInputState();
        InputDispatcherState state = this.testContext.getStates$ui_test_release().remove(this.root);
        if (state != null) {
            this.partialGesture = state.getPartialGesture();
            this.mouseInputState = state.getMouseInputState();
        }
    }

    protected final long getCurrentTime() {
        return this.currentTime;
    }

    protected final void setCurrentTime(long l) {
        this.currentTime = l;
    }

    @Nullable
    protected final PartialGesture getPartialGesture() {
        return this.partialGesture;
    }

    protected final void setPartialGesture(@Nullable PartialGesture partialGesture) {
        this.partialGesture = partialGesture;
    }

    @NotNull
    protected final MouseInputState getMouseInputState() {
        return this.mouseInputState;
    }

    protected final void setMouseInputState(@NotNull MouseInputState mouseInputState) {
        Intrinsics.checkNotNullParameter((Object)mouseInputState, (String)"<set-?>");
        this.mouseInputState = mouseInputState;
    }

    public final boolean isTouchInProgress() {
        return this.partialGesture != null;
    }

    protected void saveState(@Nullable RootForTest root) {
        if (root != null) {
            Map<RootForTest, InputDispatcherState> map = this.testContext.getStates$ui_test_release();
            InputDispatcherState inputDispatcherState = new InputDispatcherState(this.partialGesture, this.mouseInputState);
            map.put(root, inputDispatcherState);
        }
    }

    private final long getCurrentTime(TestContext $this$currentTime) {
        return $this$currentTime.getTestOwner$ui_test_release().getMainClock().getCurrentTime();
    }

    private static /* synthetic */ void getCurrentTime$annotations(TestContext testContext) {
    }

    private final Rect getBounds(RootForTest $this$bounds) {
        return $this$bounds.getSemanticsOwner().getRootSemanticsNode().getBoundsInRoot();
    }

    protected final boolean isWithinRootBounds-k-4lQ0M(long position) {
        return this.getBounds(this.root).contains-k-4lQ0M(position);
    }

    public final void advanceEventTime(long durationMillis) {
        if (!(durationMillis >= 0L)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"duration of a delay can only be positive, not ", (Object)durationMillis);
            throw new IllegalArgumentException(string.toString());
        }
        this.currentTime += durationMillis;
    }

    public static /* synthetic */ void advanceEventTime$default(InputDispatcher inputDispatcher, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: advanceEventTime");
        }
        if ((n & 1) != 0) {
            l = eventPeriodMillis;
        }
        inputDispatcher.advanceEventTime(l);
    }

    @Nullable
    public final Offset getCurrentTouchPosition-x-9fifI(int pointerId) {
        Offset offset;
        PartialGesture partialGesture = this.partialGesture;
        if (partialGesture == null) {
            offset = null;
        } else {
            Map<Integer, Offset> map = partialGesture.getLastPositions();
            offset = map == null ? null : map.get(pointerId);
        }
        return offset;
    }

    public final long getCurrentMousePosition-F1C5BW0() {
        return this.mouseInputState.getLastPosition-F1C5BW0();
    }

    public final void enqueueTouchDown-Uv8p0NA(int pointerId, long position) {
        PartialGesture gesture = this.partialGesture;
        if (!(gesture == null || !gesture.getLastPositions().containsKey(pointerId))) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Cannot send DOWN event, a gesture is already in progress for pointer ", (Object)pointerId);
            throw new IllegalArgumentException(string.toString());
        }
        if (this.mouseInputState.getHasAnyButtonPressed()) {
            this.enqueueCancel(this.mouseInputState);
        } else if (this.mouseInputState.isEntered()) {
            this.exitHover(this.mouseInputState);
        }
        PartialGesture partialGesture = gesture;
        if (partialGesture != null) {
            this.flushPointerUpdates(partialGesture);
        }
        if (gesture == null) {
            this.partialGesture = gesture = new PartialGesture(this.currentTime, position, pointerId, null);
        } else {
            Map<Integer, Offset> map = gesture.getLastPositions();
            Integer n = pointerId;
            Offset offset = Offset.box-impl((long)position);
            map.put(n, offset);
        }
        this.enqueueDown(gesture, pointerId);
    }

    public final void enqueueTouchMove() {
        PartialGesture partialGesture = this.partialGesture;
        if (partialGesture == null) {
            boolean bl = false;
            String string = "Cannot send MOVE event, no gesture is in progress";
            throw new IllegalStateException(string.toString());
        }
        PartialGesture gesture = partialGesture;
        this.enqueueMove(gesture);
        gesture.setHasPointerUpdates(false);
    }

    public final void enqueueTouchMoves(@NotNull List<Long> relativeHistoricalTimes, @NotNull List<? extends List<Offset>> historicalCoordinates) {
        Intrinsics.checkNotNullParameter(relativeHistoricalTimes, (String)"relativeHistoricalTimes");
        Intrinsics.checkNotNullParameter(historicalCoordinates, (String)"historicalCoordinates");
        PartialGesture partialGesture = this.partialGesture;
        if (partialGesture == null) {
            boolean bl = false;
            String string = "Cannot send MOVE event, no gesture is in progress";
            throw new IllegalStateException(string.toString());
        }
        PartialGesture gesture = partialGesture;
        this.enqueueMoves(gesture, relativeHistoricalTimes, historicalCoordinates);
        gesture.setHasPointerUpdates(false);
    }

    public final void updateTouchPointer-Uv8p0NA(int pointerId, long position) {
        PartialGesture gesture = this.partialGesture;
        if (!(gesture != null)) {
            boolean $i$a$-check-InputDispatcher$updateTouchPointer$22 = false;
            String $i$a$-check-InputDispatcher$updateTouchPointer$22 = "Cannot move pointers, no gesture is in progress";
            throw new IllegalStateException($i$a$-check-InputDispatcher$updateTouchPointer$22.toString());
        }
        if (!gesture.getLastPositions().containsKey(pointerId)) {
            boolean bl = false;
            String string = "Cannot move pointer " + pointerId + ", it is not active in the current gesture";
            throw new IllegalArgumentException(string.toString());
        }
        Map<Integer, Offset> map = gesture.getLastPositions();
        Integer n = pointerId;
        Offset offset = Offset.box-impl((long)position);
        map.put(n, offset);
        gesture.setHasPointerUpdates(true);
    }

    public final void enqueueTouchUp(int pointerId) {
        PartialGesture gesture = this.partialGesture;
        if (!(gesture != null)) {
            boolean $i$a$-check-InputDispatcher$enqueueTouchUp$22 = false;
            String $i$a$-check-InputDispatcher$enqueueTouchUp$22 = "Cannot send UP event, no gesture is in progress";
            throw new IllegalStateException($i$a$-check-InputDispatcher$enqueueTouchUp$22.toString());
        }
        if (!gesture.getLastPositions().containsKey(pointerId)) {
            boolean bl = false;
            String string = "Cannot send UP event for pointer " + pointerId + ", it is not active in the current gesture";
            throw new IllegalArgumentException(string.toString());
        }
        this.enqueueUp(gesture, pointerId);
        gesture.getLastPositions().remove(pointerId);
        if (gesture.getLastPositions().isEmpty()) {
            this.partialGesture = null;
        }
    }

    public final void enqueueTouchCancel() {
        PartialGesture partialGesture = this.partialGesture;
        if (partialGesture == null) {
            boolean bl = false;
            String string = "Cannot send CANCEL event, no gesture is in progress";
            throw new IllegalStateException(string.toString());
        }
        PartialGesture gesture = partialGesture;
        this.enqueueCancel(gesture);
        this.partialGesture = null;
    }

    private final void flushPointerUpdates(PartialGesture $this$flushPointerUpdates) {
        if ($this$flushPointerUpdates.getHasPointerUpdates()) {
            this.enqueueTouchMove();
        }
    }

    public final void enqueueMousePress(int buttonId) {
        MouseInputState mouse = this.mouseInputState;
        if (!(!mouse.isButtonPressed(buttonId))) {
            boolean $i$a$-check-InputDispatcher$enqueueMousePress$32 = false;
            String $i$a$-check-InputDispatcher$enqueueMousePress$32 = "Cannot send mouse button down event, button " + buttonId + " is already pressed";
            throw new IllegalStateException($i$a$-check-InputDispatcher$enqueueMousePress$32.toString());
        }
        if (!(this.isWithinRootBounds-k-4lQ0M(this.getCurrentMousePosition-F1C5BW0()) || mouse.getHasAnyButtonPressed())) {
            boolean bl = false;
            String string = "Cannot start a mouse gesture outside the Compose root bounds, mouse position is " + Offset.toString-impl((long)this.getCurrentMousePosition-F1C5BW0()) + " and bounds are " + this.getBounds(this.root);
            throw new IllegalStateException(string.toString());
        }
        if (this.partialGesture != null) {
            this.enqueueTouchCancel();
        }
        if (mouse.getHasNoButtonsPressed()) {
            mouse.setDownTime(this.currentTime);
        }
        mouse.setButtonBit(buttonId);
        if (mouse.isEntered()) {
            this.exitHover(mouse);
        }
        this.enqueuePress(mouse, buttonId);
    }

    public final void enqueueMouseMove-k-4lQ0M(long position) {
        MouseInputState mouse = this.mouseInputState;
        if (this.partialGesture != null) {
            this.enqueueTouchCancel();
        }
        this.updateMousePosition-k-4lQ0M(position);
        boolean isWithinBounds = this.isWithinRootBounds-k-4lQ0M(position);
        if (isWithinBounds && !mouse.isEntered() && mouse.getHasNoButtonsPressed()) {
            this.enterHover(mouse);
        } else if (!isWithinBounds && mouse.isEntered()) {
            this.exitHover(mouse);
        }
        this.enqueueMove(mouse);
    }

    public final void updateMousePosition-k-4lQ0M(long position) {
        this.mouseInputState.setLastPosition-k-4lQ0M(position);
    }

    public final void enqueueMouseRelease(int buttonId) {
        MouseInputState mouse = this.mouseInputState;
        if (!mouse.isButtonPressed(buttonId)) {
            boolean $i$a$-check-InputDispatcher$enqueueMouseRelease$32 = false;
            String $i$a$-check-InputDispatcher$enqueueMouseRelease$32 = "Cannot send mouse button up event, button " + buttonId + " is not pressed";
            throw new IllegalStateException($i$a$-check-InputDispatcher$enqueueMouseRelease$32.toString());
        }
        if (!(this.partialGesture == null)) {
            boolean bl = false;
            String string = "Touch gesture can't be in progress, mouse buttons are down";
            throw new IllegalStateException(string.toString());
        }
        mouse.unsetButtonBit(buttonId);
        this.enqueueRelease(mouse, buttonId);
        if (mouse.getHasNoButtonsPressed() && this.isWithinRootBounds-k-4lQ0M(this.getCurrentMousePosition-F1C5BW0())) {
            this.enterHover(mouse);
            this.enqueueMove(mouse);
        }
    }

    public final void enqueueMouseEnter-k-4lQ0M(long position) {
        MouseInputState mouse = this.mouseInputState;
        if (!(!mouse.isEntered())) {
            boolean $i$a$-check-InputDispatcher$enqueueMouseEnter$42 = false;
            String $i$a$-check-InputDispatcher$enqueueMouseEnter$42 = "Cannot send mouse hover enter event, mouse is already hovering";
            throw new IllegalStateException($i$a$-check-InputDispatcher$enqueueMouseEnter$42.toString());
        }
        if (!mouse.getHasNoButtonsPressed()) {
            boolean $i$a$-check-InputDispatcher$enqueueMouseEnter$52 = false;
            String $i$a$-check-InputDispatcher$enqueueMouseEnter$52 = "Cannot send mouse hover enter event, mouse buttons are down";
            throw new IllegalStateException($i$a$-check-InputDispatcher$enqueueMouseEnter$52.toString());
        }
        if (!this.isWithinRootBounds-k-4lQ0M(position)) {
            boolean bl = false;
            String string = "Cannot send mouse hover enter event, " + Offset.toString-impl((long)position) + " is out of bounds";
            throw new IllegalStateException(string.toString());
        }
        this.updateMousePosition-k-4lQ0M(position);
        this.enterHover(mouse);
    }

    public final void enqueueMouseExit-k-4lQ0M(long position) {
        MouseInputState mouse = this.mouseInputState;
        if (!mouse.isEntered()) {
            boolean bl = false;
            String string = "Cannot send mouse hover exit event, mouse is not hovering";
            throw new IllegalStateException(string.toString());
        }
        this.updateMousePosition-k-4lQ0M(position);
        this.exitHover(mouse);
    }

    public final void enqueueMouseCancel() {
        MouseInputState mouse = this.mouseInputState;
        if (!mouse.getHasAnyButtonPressed()) {
            boolean bl = false;
            String string = "Cannot send mouse cancel event, no mouse buttons are pressed";
            throw new IllegalStateException(string.toString());
        }
        mouse.clearButtonState();
        this.enqueueCancel(mouse);
    }

    public final void enqueueMouseScroll-I7Dg0i0(float delta, int scrollWheel) {
        MouseInputState mouse = this.mouseInputState;
        this.enqueueMouseMove-k-4lQ0M(this.getCurrentMousePosition-F1C5BW0());
        if (this.isWithinRootBounds-k-4lQ0M(this.getCurrentMousePosition-F1C5BW0())) {
            this.enqueueScroll-0Rp_h_E(mouse, delta, scrollWheel);
        }
    }

    private final void enterHover(MouseInputState $this$enterHover) {
        this.enqueueEnter($this$enterHover);
        $this$enterHover.setEntered(true);
    }

    private final void exitHover(MouseInputState $this$exitHover) {
        this.enqueueExit($this$exitHover);
        $this$exitHover.setEntered(false);
    }

    public abstract void flush();

    protected abstract void enqueueDown(@NotNull PartialGesture var1, int var2);

    protected abstract void enqueueMove(@NotNull PartialGesture var1);

    protected abstract void enqueueMoves(@NotNull PartialGesture var1, @NotNull List<Long> var2, @NotNull List<? extends List<Offset>> var3);

    protected abstract void enqueueUp(@NotNull PartialGesture var1, int var2);

    protected abstract void enqueueCancel(@NotNull PartialGesture var1);

    protected abstract void enqueuePress(@NotNull MouseInputState var1, int var2);

    protected abstract void enqueueMove(@NotNull MouseInputState var1);

    protected abstract void enqueueRelease(@NotNull MouseInputState var1, int var2);

    protected abstract void enqueueEnter(@NotNull MouseInputState var1);

    protected abstract void enqueueExit(@NotNull MouseInputState var1);

    protected abstract void enqueueCancel(@NotNull MouseInputState var1);

    protected abstract void enqueueScroll-0Rp_h_E(@NotNull MouseInputState var1, float var2, int var3);

    public final void dispose() {
        this.saveState(this.root);
        this.onDispose();
    }

    protected void onDispose() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/test/InputDispatcher$Companion;", "", "()V", "<set-?>", "", "eventPeriodMillis", "getEventPeriodMillis", "()J", "setEventPeriodMillis$ui_test_release", "(J)V", "ui-test_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getEventPeriodMillis() {
            return eventPeriodMillis;
        }

        public final void setEventPeriodMillis$ui_test_release(long l) {
            eventPeriodMillis = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

