/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.OutputKt;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsSelector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a@\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a \u0010\u0012\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a \u0010\u0014\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0006H\u0000\u001a&\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0018"}, d2={"buildErrorMessageForAssertAllFail", "", "selector", "Landroidx/compose/ui/test/SemanticsSelector;", "nodesNotMatching", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "assertionMatcher", "Landroidx/compose/ui/test/SemanticsMatcher;", "buildErrorMessageForAssertAnyFail", "nodes", "buildErrorMessageForAtLeastOneNodeExpected", "errorMessage", "buildErrorMessageForCountMismatch", "foundNodes", "expectedCount", "", "foundNodesUnmerged", "buildErrorMessageForNodeMissingInTree", "lastSeenSemantics", "buildGeneralErrorMessage", "node", "buildIndexErrorMessage", "index", "ui-test_release"})
public final class ErrorMessagesKt {
    @NotNull
    public static final String buildErrorMessageForCountMismatch(@NotNull String errorMessage, @Nullable SemanticsSelector selector, @NotNull List<SemanticsNode> foundNodes, int expectedCount, @NotNull List<SemanticsNode> foundNodesUnmerged) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(foundNodes, (String)"foundNodes");
        Intrinsics.checkNotNullParameter(foundNodesUnmerged, (String)"foundNodesUnmerged");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        sb.append("Reason: ");
        switch (expectedCount) {
            case 0: {
                sb.append("Did not expect any node");
                break;
            }
            case 1: {
                sb.append("Expected exactly '1' node");
                break;
            }
            default: {
                sb.append("Expected '" + expectedCount + "' nodes");
            }
        }
        if (foundNodes.isEmpty()) {
            sb.append(" but could not find any");
        } else {
            sb.append(" but found '" + foundNodes.size() + '\'');
        }
        if (selector != null) {
            if (foundNodes.size() <= 1) {
                sb.append(" node that satisfies: (" + selector.getDescription() + ')');
            } else {
                sb.append(" nodes that satisfy: (" + selector.getDescription() + ')');
            }
        } else {
            sb.append(".");
        }
        if (foundNodes.isEmpty() && !((Collection)foundNodesUnmerged).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append('\\n')");
            sb.append("However, the unmerged tree contains ");
            if (foundNodesUnmerged.size() == 1) {
                sb.append("'1' node that matches. ");
            } else {
                sb.append("" + '\'' + foundNodesUnmerged.size() + "' nodes that match. ");
            }
            sb.append("Are you missing `useUnmergedNode = true` in your finder?");
        }
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append('\\n')");
        if (!((Collection)foundNodes).isEmpty()) {
            if (foundNodes.size() == 1) {
                StringBuilder stringBuilder = sb.append("Node found:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            } else {
                StringBuilder stringBuilder = sb.append("Nodes found:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            }
            StringBuilder stringBuilder = sb.append(OutputKt.printToString$default(foundNodes, 0, 1, null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String buildErrorMessageForCountMismatch$default(String string, SemanticsSelector semanticsSelector, List list, int n, List list2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ErrorMessagesKt.buildErrorMessageForCountMismatch(string, semanticsSelector, list, n, list2);
    }

    @NotNull
    public static final String buildErrorMessageForNodeMissingInTree(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull String lastSeenSemantics) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)lastSeenSemantics, (String)"lastSeenSemantics");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("\n");
        StringBuilder stringBuilder = sb.append("The node is no longer in the tree, last known semantics:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = sb.append(lastSeenSemantics);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        sb.append("Original selector: ");
        StringBuilder stringBuilder3 = sb.append(selector.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String buildErrorMessageForAssertAnyFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes, @NotNull SemanticsMatcher assertionMatcher) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append("Failed to assertAny(" + assertionMatcher.getDescription() + ')');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = sb.append("None of the following nodes match:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = sb.append(OutputKt.printToString$default(nodes, 0, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        StringBuilder stringBuilder4 = sb.append("'");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String buildErrorMessageForAssertAllFail(@NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodesNotMatching, @NotNull SemanticsMatcher assertionMatcher) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodesNotMatching, (String)"nodesNotMatching");
        Intrinsics.checkNotNullParameter((Object)assertionMatcher, (String)"assertionMatcher");
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append("Failed to assertAll(" + assertionMatcher.getDescription() + ')');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        sb.append("Found '" + nodesNotMatching.size() + "' ");
        sb.append(nodesNotMatching.size() == 1 ? "node" : "nodes");
        StringBuilder stringBuilder2 = sb.append(" not matching:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = sb.append(OutputKt.printToString$default(nodesNotMatching, 0, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: '");
        sb.append(selector.getDescription());
        StringBuilder stringBuilder4 = sb.append("'");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String buildErrorMessageForAtLeastOneNodeExpected(@NotNull String errorMessage, @NotNull SemanticsSelector selector) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        sb.append("Assert needs to receive at least 1 node but 0 nodes were found for selector: ");
        sb.append("'");
        sb.append(selector.getDescription());
        StringBuilder stringBuilder2 = sb.append("'");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String buildGeneralErrorMessage(@NotNull String errorMessage, @NotNull SemanticsSelector selector, @NotNull SemanticsNode node) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append(errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = sb.append("Semantics of the node:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = sb.append(OutputKt.printToString$default(node, 0, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        sb.append("Selector used: (");
        sb.append(selector.getDescription());
        StringBuilder stringBuilder4 = sb.append(")");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String buildIndexErrorMessage(int index, @NotNull SemanticsSelector selector, @NotNull List<SemanticsNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        StringBuilder sb = new StringBuilder();
        sb.append("Can't retrieve node at index '" + index + "' of '");
        sb.append(selector.getDescription());
        StringBuilder stringBuilder = sb.append("'");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        if (nodes.isEmpty()) {
            StringBuilder stringBuilder2 = sb.append("There are no existing nodes for that selector.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        } else if (nodes.size() == 1) {
            StringBuilder stringBuilder3 = sb.append("There is 1 node only:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder4 = sb.append(OutputKt.printToString$default(nodes, 0, 1, null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        } else {
            StringBuilder stringBuilder5 = sb.append("There are '" + nodes.size() + "' nodes only:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder6 = sb.append(OutputKt.printToString$default(nodes, 0, 1, null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

