/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Connector;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a8\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0010H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0000\u001a8\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001aH\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a8\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001aH\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\b\b\u0002\u0010 \u001a\u00020!H\u0007\u001a+\u0010\"\u001a\u00020#*\u00020\u001e2\b\b\u0002\u0010$\u001a\u00020\u001e2\b\b\u0002\u0010%\u001a\u00020&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010(\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"absRcpResponse", "", "x", "a", "b", "c", "d", "g", "absResponse", "chromaticAdaptation", "", "matrix", "srcWhitePoint", "dstWhitePoint", "compare", "", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "inverse3x3", "m", "mul3x3", "lhs", "rhs", "mul3x3Diag", "mul3x3Float3", "rcpResponse", "e", "f", "response", "adapt", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "whitePoint", "adaptation", "Landroidx/compose/ui/graphics/colorspace/Adaptation;", "connect", "Landroidx/compose/ui/graphics/colorspace/Connector;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "connect-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)Landroidx/compose/ui/graphics/colorspace/Connector;", "ui-graphics_release"})
public final class ColorSpaceKt {
    @NotNull
    public static final Connector connect-YBCOT_4(@NotNull ColorSpace $this$connect_u2dYBCOT_4, @NotNull ColorSpace destination, int intent) {
        Intrinsics.checkNotNullParameter((Object)$this$connect_u2dYBCOT_4, (String)"$this$connect");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if ($this$connect_u2dYBCOT_4 == destination) {
            return Connector.Companion.identity$ui_graphics_release($this$connect_u2dYBCOT_4);
        }
        return ColorModel.equals-impl0($this$connect_u2dYBCOT_4.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) && ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? (Connector)new Connector.RgbConnector((Rgb)$this$connect_u2dYBCOT_4, (Rgb)destination, intent, null) : new Connector($this$connect_u2dYBCOT_4, destination, intent, null);
    }

    public static /* synthetic */ Connector connect-YBCOT_4$default(ColorSpace colorSpace, ColorSpace colorSpace2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorSpace2 = ColorSpaces.INSTANCE.getSrgb();
        }
        if ((n2 & 2) != 0) {
            n = RenderIntent.Companion.getPerceptual-uksYyKA();
        }
        return ColorSpaceKt.connect-YBCOT_4(colorSpace, colorSpace2, n);
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint, @NotNull Adaptation adaptation) {
        Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)adaptation, (String)"adaptation");
        if (ColorModel.equals-impl0($this$adapt.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            Rgb rgb = (Rgb)$this$adapt;
            if (ColorSpaceKt.compare(rgb.getWhitePoint(), whitePoint)) {
                return $this$adapt;
            }
            float[] xyz = whitePoint.toXyz$ui_graphics_release();
            float[] adaptationTransform = ColorSpaceKt.chromaticAdaptation(adaptation.getTransform$ui_graphics_release(), rgb.getWhitePoint().toXyz$ui_graphics_release(), xyz);
            float[] transform = ColorSpaceKt.mul3x3(adaptationTransform, rgb.getTransform$ui_graphics_release());
            return new Rgb(rgb, transform, whitePoint);
        }
        return $this$adapt;
    }

    public static /* synthetic */ ColorSpace adapt$default(ColorSpace colorSpace, WhitePoint whitePoint, Adaptation adaptation, int n, Object object) {
        if ((n & 2) != 0) {
            adaptation = Adaptation.Companion.getBradford();
        }
        return ColorSpaceKt.adapt(colorSpace, whitePoint, adaptation);
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double g) {
        return x >= d * c ? (Math.pow(x, 1.0 / g) - b) / a : x / c;
    }

    public static final double response(double x, double a, double b, double c, double d, double g) {
        return x >= d ? Math.pow(a * x + b, g) : c * x;
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d * c ? (Math.pow(x - e, 1.0 / g) - b) / a : (x - f) / c;
    }

    public static final double response(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d ? Math.pow(a * x + b, g) + e : c * x + f;
    }

    public static final double absRcpResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.rcpResponse(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    public static final double absResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.response(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    public static final boolean compare(@NotNull TransferParameters a, @Nullable TransferParameters b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return b != null && Math.abs(a.getA() - b.getA()) < 0.001 && Math.abs(a.getB() - b.getB()) < 0.001 && Math.abs(a.getC() - b.getC()) < 0.001 && Math.abs(a.getD() - b.getD()) < 0.002 && Math.abs(a.getE() - b.getE()) < 0.001 && Math.abs(a.getF() - b.getF()) < 0.001 && Math.abs(a.getGamma() - b.getGamma()) < 0.001;
    }

    public static final boolean compare(@NotNull WhitePoint a, @NotNull WhitePoint b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        return Math.abs(a.getX() - b.getX()) < 0.001f && Math.abs(a.getY() - b.getY()) < 0.001f;
    }

    public static final boolean compare(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (Float.compare(a[i], b[i]) == 0 || !(Math.abs(a[i] - b[i]) > 0.001f)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final float[] inverse3x3(@NotNull float[] m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i = m[8];
        float xA = e * i - f * h;
        float xB = f * g - d * i;
        float xC = d * h - e * g;
        float det = a * xA + b * xB + c * xC;
        float[] inverted = new float[m.length];
        inverted[0] = xA / det;
        inverted[1] = xB / det;
        inverted[2] = xC / det;
        inverted[3] = (c * h - b * i) / det;
        inverted[4] = (a * i - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (c * d - a * f) / det;
        inverted[8] = (a * e - b * d) / det;
        return inverted;
    }

    @NotNull
    public static final float[] mul3x3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] r = new float[]{lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2], lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2], lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2], lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5], lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5], lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5], lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8], lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8], lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8]};
        return r;
    }

    @NotNull
    public static final float[] mul3x3Float3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    @NotNull
    public static final float[] mul3x3Diag(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] fArray = new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
        return fArray;
    }

    @NotNull
    public static final float[] chromaticAdaptation(@NotNull float[] matrix, @NotNull float[] srcWhitePoint, @NotNull float[] dstWhitePoint) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)srcWhitePoint, (String)"srcWhitePoint");
        Intrinsics.checkNotNullParameter((Object)dstWhitePoint, (String)"dstWhitePoint");
        float[] srcLMS = ColorSpaceKt.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpaceKt.mul3x3Float3(matrix, dstWhitePoint);
        float[] fArray = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        float[] LMS = fArray;
        return ColorSpaceKt.mul3x3(ColorSpaceKt.inverse3x3(matrix), ColorSpaceKt.mul3x3Diag(LMS, matrix));
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        return ColorSpaceKt.adapt$default($this$adapt, whitePoint, null, 2, null);
    }
}

