/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.ColorSpace;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007J\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/ColorSpaceVerificationHelper;", "", "()V", "androidColorSpace", "Landroid/graphics/ColorSpace;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "composeColorSpace", "ui-graphics_release"})
@RequiresApi(value=26)
final class ColorSpaceVerificationHelper {
    @NotNull
    public static final ColorSpaceVerificationHelper INSTANCE = new ColorSpaceVerificationHelper();

    private ColorSpaceVerificationHelper() {
    }

    @JvmStatic
    @DoNotInline
    @RequiresApi(value=26)
    @NotNull
    public static final android.graphics.ColorSpace androidColorSpace(@NotNull ColorSpace $this$androidColorSpace) {
        android.graphics.ColorSpace colorSpace;
        Intrinsics.checkNotNullParameter((Object)$this$androidColorSpace, (String)"<this>");
        ColorSpace colorSpace2 = $this$androidColorSpace;
        if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getSrgb())) {
            android.graphics.ColorSpace colorSpace3 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            colorSpace = colorSpace3;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace3, (String)"get(android.graphics.ColorSpace.Named.SRGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAces())) {
            android.graphics.ColorSpace colorSpace4 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACES);
            colorSpace = colorSpace4;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace4, (String)"get(android.graphics.ColorSpace.Named.ACES)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAcescg())) {
            android.graphics.ColorSpace colorSpace5 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACESCG);
            colorSpace = colorSpace5;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace5, (String)"get(android.graphics.ColorSpace.Named.ACESCG)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAdobeRgb())) {
            android.graphics.ColorSpace colorSpace6 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ADOBE_RGB);
            colorSpace = colorSpace6;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace6, (String)"get(android.graphics.ColorSpace.Named.ADOBE_RGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getBt2020())) {
            android.graphics.ColorSpace colorSpace7 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT2020);
            colorSpace = colorSpace7;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace7, (String)"get(android.graphics.ColorSpace.Named.BT2020)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getBt709())) {
            android.graphics.ColorSpace colorSpace8 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT709);
            colorSpace = colorSpace8;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace8, (String)"get(android.graphics.ColorSpace.Named.BT709)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getCieLab())) {
            android.graphics.ColorSpace colorSpace9 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_LAB);
            colorSpace = colorSpace9;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace9, (String)"get(android.graphics.ColorSpace.Named.CIE_LAB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getCieXyz())) {
            android.graphics.ColorSpace colorSpace10 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_XYZ);
            colorSpace = colorSpace10;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace10, (String)"get(android.graphics.ColorSpace.Named.CIE_XYZ)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getDciP3())) {
            android.graphics.ColorSpace colorSpace11 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DCI_P3);
            colorSpace = colorSpace11;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace11, (String)"get(android.graphics.ColorSpace.Named.DCI_P3)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getDisplayP3())) {
            android.graphics.ColorSpace colorSpace12 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DISPLAY_P3);
            colorSpace = colorSpace12;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace12, (String)"get(android.graphics.ColorSpace.Named.DISPLAY_P3)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getExtendedSrgb())) {
            android.graphics.ColorSpace colorSpace13 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.EXTENDED_SRGB);
            colorSpace = colorSpace13;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace13, (String)"get(android.graphics.Col\u2026pace.Named.EXTENDED_SRGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getLinearExtendedSrgb())) {
            android.graphics.ColorSpace colorSpace14 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_EXTENDED_SRGB);
            colorSpace = colorSpace14;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace14, (String)"get(android.graphics.Col\u2026med.LINEAR_EXTENDED_SRGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getLinearSrgb())) {
            android.graphics.ColorSpace colorSpace15 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_SRGB);
            colorSpace = colorSpace15;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace15, (String)"get(android.graphics.ColorSpace.Named.LINEAR_SRGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getNtsc1953())) {
            android.graphics.ColorSpace colorSpace16 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.NTSC_1953);
            colorSpace = colorSpace16;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace16, (String)"get(android.graphics.ColorSpace.Named.NTSC_1953)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getProPhotoRgb())) {
            android.graphics.ColorSpace colorSpace17 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.PRO_PHOTO_RGB);
            colorSpace = colorSpace17;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace17, (String)"get(android.graphics.Col\u2026pace.Named.PRO_PHOTO_RGB)");
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getSmpteC())) {
            android.graphics.ColorSpace colorSpace18 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SMPTE_C);
            colorSpace = colorSpace18;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace18, (String)"get(android.graphics.ColorSpace.Named.SMPTE_C)");
        } else {
            android.graphics.ColorSpace colorSpace19;
            if ($this$androidColorSpace instanceof Rgb) {
                float[] whitePointArray = ((Rgb)$this$androidColorSpace).getWhitePoint().toXyz$ui_graphics_release();
                TransferParameters transferParams = ((Rgb)$this$androidColorSpace).getTransferParameters();
                ColorSpace.Rgb.TransferParameters androidTransferParams = transferParams != null ? new ColorSpace.Rgb.TransferParameters(transferParams.getA(), transferParams.getB(), transferParams.getC(), transferParams.getD(), transferParams.getE(), transferParams.getF(), transferParams.getGamma()) : null;
                colorSpace19 = (android.graphics.ColorSpace)(androidTransferParams != null ? new ColorSpace.Rgb($this$androidColorSpace.getName(), ((Rgb)$this$androidColorSpace).getPrimaries$ui_graphics_release(), whitePointArray, androidTransferParams) : new ColorSpace.Rgb($this$androidColorSpace.getName(), ((Rgb)$this$androidColorSpace).getPrimaries$ui_graphics_release(), whitePointArray, arg_0 -> ColorSpaceVerificationHelper.androidColorSpace$lambda$0(((Rgb)$this$androidColorSpace).getOetf(), arg_0), arg_0 -> ColorSpaceVerificationHelper.androidColorSpace$lambda$1(((Rgb)$this$androidColorSpace).getEotf(), arg_0), $this$androidColorSpace.getMinValue(0), $this$androidColorSpace.getMaxValue(0)));
            } else {
                colorSpace19 = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
            }
            android.graphics.ColorSpace colorSpace20 = colorSpace19;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace20, (String)"{\n                if (th\u2026          }\n            }");
            colorSpace = colorSpace20;
        }
        return colorSpace;
    }

    @JvmStatic
    @DoNotInline
    @RequiresApi(value=26)
    @NotNull
    public static final ColorSpace composeColorSpace(@NotNull android.graphics.ColorSpace $this$composeColorSpace) {
        ColorSpace colorSpace;
        Intrinsics.checkNotNullParameter((Object)$this$composeColorSpace, (String)"<this>");
        int n = $this$composeColorSpace.getId();
        if (n == ColorSpace.Named.SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getSrgb();
        } else if (n == ColorSpace.Named.ACES.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAces();
        } else if (n == ColorSpace.Named.ACESCG.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAcescg();
        } else if (n == ColorSpace.Named.ADOBE_RGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAdobeRgb();
        } else if (n == ColorSpace.Named.BT2020.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getBt2020();
        } else if (n == ColorSpace.Named.BT709.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getBt709();
        } else if (n == ColorSpace.Named.CIE_LAB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getCieLab();
        } else if (n == ColorSpace.Named.CIE_XYZ.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getCieXyz();
        } else if (n == ColorSpace.Named.DCI_P3.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getDciP3();
        } else if (n == ColorSpace.Named.DISPLAY_P3.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getDisplayP3();
        } else if (n == ColorSpace.Named.EXTENDED_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getExtendedSrgb();
        } else if (n == ColorSpace.Named.LINEAR_EXTENDED_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getLinearExtendedSrgb();
        } else if (n == ColorSpace.Named.LINEAR_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getLinearSrgb();
        } else if (n == ColorSpace.Named.NTSC_1953.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getNtsc1953();
        } else if (n == ColorSpace.Named.PRO_PHOTO_RGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getProPhotoRgb();
        } else if (n == ColorSpace.Named.SMPTE_C.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getSmpteC();
        } else {
            Rgb rgb;
            if ($this$composeColorSpace instanceof ColorSpace.Rgb) {
                ColorSpace.Rgb.TransferParameters transferParams = ((ColorSpace.Rgb)$this$composeColorSpace).getTransferParameters();
                WhitePoint whitePoint = ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint().length == 3 ? new WhitePoint(((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[0], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[1], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[2]) : new WhitePoint(((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[0], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[1]);
                TransferParameters composeTransferParams = transferParams != null ? new TransferParameters(transferParams.g, transferParams.a, transferParams.b, transferParams.c, transferParams.d, transferParams.e, transferParams.f) : null;
                String string = ((ColorSpace.Rgb)$this$composeColorSpace).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
                float[] fArray = ((ColorSpace.Rgb)$this$composeColorSpace).getPrimaries();
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"this.primaries");
                rgb = new Rgb(string, fArray, whitePoint, ((ColorSpace.Rgb)$this$composeColorSpace).getTransform(), arg_0 -> ColorSpaceVerificationHelper.composeColorSpace$lambda$2($this$composeColorSpace, arg_0), arg_0 -> ColorSpaceVerificationHelper.composeColorSpace$lambda$3($this$composeColorSpace, arg_0), $this$composeColorSpace.getMinValue(0), $this$composeColorSpace.getMaxValue(0), composeTransferParams, ((ColorSpace.Rgb)$this$composeColorSpace).getId());
            } else {
                rgb = ColorSpaces.INSTANCE.getSrgb();
            }
            colorSpace = rgb;
        }
        return colorSpace;
    }

    private static final double androidColorSpace$lambda$0(Function1 $tmp0, double p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke((Object)p0)).doubleValue();
    }

    private static final double androidColorSpace$lambda$1(Function1 $tmp0, double p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke((Object)p0)).doubleValue();
    }

    private static final double composeColorSpace$lambda$2(android.graphics.ColorSpace $this_composeColorSpace, double x) {
        Intrinsics.checkNotNullParameter((Object)$this_composeColorSpace, (String)"$this_composeColorSpace");
        return ((ColorSpace.Rgb)$this_composeColorSpace).getOetf().applyAsDouble(x);
    }

    private static final double composeColorSpace$lambda$3(android.graphics.ColorSpace $this_composeColorSpace, double x) {
        Intrinsics.checkNotNullParameter((Object)$this_composeColorSpace, (String)"$this_composeColorSpace");
        return ((ColorSpace.Rgb)$this_composeColorSpace).getEotf().applyAsDouble(x);
    }
}

