/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.ui.lint.ModifierParameterDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/lint/ModifierParameterDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UMethod;", "Companion", "ui-lint"})
public final class ModifierParameterDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ModifierParameter = Issue.Companion.create("ModifierParameter", "Guidelines for Modifier parameters in a Composable function", "The first (or only) Modifier parameter in a Composable function should follow the following rules:\n- Be named `" + ModifierParameterDetectorKt.access$getModifierParameterName$p() + "`\n- Have a type of `" + Names.Ui.INSTANCE.getModifier().getShortName() + "`\n- Either have no default value, or have a default value of `" + Names.Ui.INSTANCE.getModifier().getShortName() + "`\n- If optional, be the first optional parameter in the parameter list", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ModifierParameterDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UMethod>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitMethod(@NotNull UMethod node) {
                Object v0;
                UParameter parameter;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!ComposableUtilsKt.isComposable((PsiMethod)node)) {
                        return;
                    }
                    if (!PsiUtilsKt.getReturnsUnit((PsiMethod)node)) {
                        return;
                    }
                    Iterable $this$firstOrNull$iv = node.getUastParameters();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        parameter = (UParameter)element$iv;
                        boolean bl = false;
                        if (!(parameter.getSourcePsi() instanceof KtParameter && PsiUtilsKt.inheritsFrom(parameter.getType(), Names.Ui.INSTANCE.getModifier()))) continue;
                        v0 = element$iv;
                        break block11;
                    }
                    v0 = null;
                }
                UParameter uParameter = v0;
                if (uParameter == null) {
                    return;
                }
                UParameter modifierParameter = uParameter;
                UElement modifierParameterElement = (UElement)modifierParameter;
                PsiElement psiElement = modifierParameter.getSourcePsi();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                KtParameter source = (KtParameter)psiElement;
                String modifierName = Names.Ui.INSTANCE.getModifier().getShortName();
                if (!Intrinsics.areEqual((Object)modifierParameter.getName(), (Object)ModifierParameterDetectorKt.access$getModifierParameterName$p())) {
                    this.$context.report(ModifierParameterDetector.Companion.getModifierParameter(), modifierParameterElement, this.$context.getNameLocation(modifierParameterElement), modifierName + " parameter should be named " + ModifierParameterDetectorKt.access$getModifierParameterName$p(), LintFix.Companion.create().replace().name("Change name to " + ModifierParameterDetectorKt.access$getModifierParameterName$p()).text(modifierParameter.getName()).with(ModifierParameterDetectorKt.access$getModifierParameterName$p()).autoFix().build());
                }
                if (!Intrinsics.areEqual((Object)modifierParameter.getType().getCanonicalText(), (Object)Names.Ui.INSTANCE.getModifier().getJavaFqn())) {
                    Issue issue = ModifierParameterDetector.Companion.getModifierParameter();
                    Location location = this.$context.getNameLocation(modifierParameterElement);
                    String string = modifierName + " parameter should have a type of " + modifierName;
                    LintFix.ReplaceStringBuilder replaceStringBuilder = LintFix.Companion.create().replace().range(this.$context.getLocation(modifierParameterElement)).name("Change type to " + modifierName);
                    KtTypeReference ktTypeReference = source.getTypeReference();
                    Intrinsics.checkNotNull((Object)ktTypeReference);
                    this.$context.report(issue, modifierParameterElement, location, string, replaceStringBuilder.text(ktTypeReference.getText()).with(modifierName).autoFix().build());
                }
                if (source.hasDefaultValue()) {
                    int optionalParameterIndex;
                    int index;
                    block12: {
                        int n;
                        KtNameReferenceExpression referenceExpression;
                        KtExpression ktExpression = source.getDefaultValue();
                        Intrinsics.checkNotNull((Object)ktExpression);
                        KtExpression defaultValue = ktExpression;
                        parameter = source.getDefaultValue();
                        KtNameReferenceExpression ktNameReferenceExpression = referenceExpression = parameter instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)parameter : null;
                        if (!Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)modifierName)) {
                            this.$context.report(ModifierParameterDetector.Companion.getModifierParameter(), modifierParameterElement, this.$context.getNameLocation(modifierParameterElement), "Optional " + modifierName + " parameter should have a default value of `" + modifierName + "`", LintFix.Companion.create().replace().range(this.$context.getLocation(modifierParameterElement)).name("Change default value to " + modifierName).text(defaultValue.getText()).with(modifierName).autoFix().build());
                        }
                        index = node.getUastParameters().indexOf(modifierParameter);
                        List $this$indexOfFirst$iv = node.getUastParameters();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (E item$iv : $this$indexOfFirst$iv) {
                            UParameter parameter2 = (UParameter)item$iv;
                            boolean bl = false;
                            PsiElement psiElement2 = parameter2.getSourcePsi();
                            KtParameter ktParameter = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
                            boolean bl2 = ktParameter != null ? ktParameter.hasDefaultValue() : false;
                            if (bl2) {
                                n = index$iv;
                                break block12;
                            }
                            ++index$iv;
                        }
                        n = optionalParameterIndex = -1;
                    }
                    if (index != optionalParameterIndex) {
                        JavaContext.report$default((JavaContext)this.$context, (Issue)ModifierParameterDetector.Companion.getModifierParameter(), (UElement)modifierParameterElement, (Location)this.$context.getNameLocation(modifierParameterElement), (String)(modifierName + " parameter should be the first optional parameter"), null, (int)16, null);
                    }
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/lint/ModifierParameterDetector$Companion;", "", "()V", "ModifierParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getModifierParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getModifierParameter() {
            return ModifierParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

