/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.contentcapture.ContentCaptureManager;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat_androidKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\nH\u0002\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\nH\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\"*\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018G@GX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0019"}, d2={"value", "", "DisableContentCapture", "getDisableContentCapture$annotations", "()V", "getDisableContentCapture", "()Z", "setDisableContentCapture", "(Z)V", "isRtl", "Landroidx/compose/ui/semantics/SemanticsNode;", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "accessibilityEquals", "Landroidx/compose/ui/semantics/AccessibilityAction;", "other", "", "enabled", "excludeLineAndPageGranularities", "findClosestParentNode", "Landroidx/compose/ui/node/LayoutNode;", "selector", "Lkotlin/Function1;", "propertiesDeleted", "oldConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "ui_release"})
public final class AndroidComposeViewAccessibilityDelegateCompat_androidKt {
    private static final LayoutNode findClosestParentNode(LayoutNode $this$findClosestParentNode, Function1<? super LayoutNode, Boolean> selector) {
        for (LayoutNode currentParent = $this$findClosestParentNode.getParent$ui_release(); currentParent != null; currentParent = currentParent.getParent$ui_release()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean enabled(SemanticsNode $this$enabled) {
        return !$this$enabled.getConfig().contains(SemanticsProperties.INSTANCE.getDisabled());
    }

    private static final boolean propertiesDeleted(SemanticsNode $this$propertiesDeleted, SemanticsConfiguration oldConfig) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : oldConfig) {
            if ($this$propertiesDeleted.getConfig().contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static final boolean isRtl(SemanticsNode $this$isRtl) {
        return $this$isRtl.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean excludeLineAndPageGranularities(SemanticsNode $this$excludeLineAndPageGranularities) {
        if ($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release().contains(SemanticsProperties.INSTANCE.getEditableText()) && !Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull($this$excludeLineAndPageGranularities.getUnmergedConfig$ui_release(), SemanticsProperties.INSTANCE.getFocused()), (Object)true)) {
            return true;
        }
        LayoutNode ancestor2 = AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($this$excludeLineAndPageGranularities.getLayoutNode$ui_release(), (Function1<? super LayoutNode, Boolean>)((Function1)excludeLineAndPageGranularities.ancestor.1.INSTANCE));
        if (ancestor2 == null) return false;
        SemanticsConfiguration semanticsConfiguration = ancestor2.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration == null) return true;
        boolean bl = Intrinsics.areEqual((Object)SemanticsConfigurationKt.getOrNull(semanticsConfiguration, SemanticsProperties.INSTANCE.getFocused()), (Object)true);
        if (bl) return false;
        return true;
    }

    private static final boolean accessibilityEquals(AccessibilityAction<?> $this$accessibilityEquals, Object other) {
        if ($this$accessibilityEquals == other) {
            return true;
        }
        if (!(other instanceof AccessibilityAction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$accessibilityEquals.getLabel(), (Object)((AccessibilityAction)other).getLabel())) {
            return false;
        }
        if ($this$accessibilityEquals.getAction() == null && ((AccessibilityAction)other).getAction() != null) {
            return false;
        }
        return $this$accessibilityEquals.getAction() == null || ((AccessibilityAction)other).getAction() != null;
    }

    @ExperimentalComposeUiApi
    public static final boolean getDisableContentCapture() {
        return ContentCaptureManager.Companion.isEnabled();
    }

    @ExperimentalComposeUiApi
    public static final void setDisableContentCapture(boolean value) {
        ContentCaptureManager.Companion.setEnabled(value);
    }

    @Deprecated(message="Use ContentCapture.isEnabled instead", replaceWith=@ReplaceWith(expression="!ContentCaptureManager.isEnabled", imports={"androidx.compose.ui.contentcapture.ContentCaptureManager.Companion.isEnabled"}), level=DeprecationLevel.WARNING)
    @ExperimentalComposeUiApi
    public static /* synthetic */ void getDisableContentCapture$annotations() {
    }

    public static final /* synthetic */ boolean access$isRtl(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.isRtl($receiver);
    }

    public static final /* synthetic */ boolean access$enabled(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.enabled($receiver);
    }

    public static final /* synthetic */ boolean access$excludeLineAndPageGranularities(SemanticsNode $receiver) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.excludeLineAndPageGranularities($receiver);
    }

    public static final /* synthetic */ LayoutNode access$findClosestParentNode(LayoutNode $receiver, Function1 selector) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.findClosestParentNode($receiver, (Function1<? super LayoutNode, Boolean>)selector);
    }

    public static final /* synthetic */ boolean access$accessibilityEquals(AccessibilityAction $receiver, Object other) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.accessibilityEquals($receiver, other);
    }

    public static final /* synthetic */ boolean access$propertiesDeleted(SemanticsNode $receiver, SemanticsConfiguration oldConfig) {
        return AndroidComposeViewAccessibilityDelegateCompat_androidKt.propertiesDeleted($receiver, oldConfig);
    }
}

