/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import android.view.inputmethod.CursorAnchorInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.AndroidMatrixConversions_androidKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.input.pointer.PositionCalculator;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.CursorAnchorInfoBuilder_androidKt;
import androidx.compose.ui.text.input.CursorAnchorInfoController;
import androidx.compose.ui.text.input.InputMethodManager;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Only exists to support the legacy TextInputService APIs. It is not used by any Compose code. A copy of this class in foundation is used by the legacy BasicTextField.")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\"\u001a\u00020\u001dJ6\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010&\u001a\u00020\u001dH\u0002JB\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Landroidx/compose/ui/text/input/CursorAnchorInfoController;", "", "rootPositionCalculator", "Landroidx/compose/ui/input/pointer/PositionCalculator;", "inputMethodManager", "Landroidx/compose/ui/text/input/InputMethodManager;", "(Landroidx/compose/ui/input/pointer/PositionCalculator;Landroidx/compose/ui/text/input/InputMethodManager;)V", "androidMatrix", "Landroid/graphics/Matrix;", "builder", "Landroid/view/inputmethod/CursorAnchorInfo$Builder;", "decorationBoxBounds", "Landroidx/compose/ui/geometry/Rect;", "hasPendingImmediateRequest", "", "includeCharacterBounds", "includeEditorBounds", "includeInsertionMarker", "includeLineBounds", "innerTextFieldBounds", "lock", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "monitorEnabled", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "textFieldToRootTransform", "Lkotlin/Function1;", "", "textFieldValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "invalidate", "requestUpdate", "immediate", "monitor", "updateCursorAnchorInfo", "updateTextLayoutResult", "ui_release"})
@StabilityInferred(parameters=0)
public final class CursorAnchorInfoController {
    @NotNull
    private final PositionCalculator rootPositionCalculator;
    @NotNull
    private final InputMethodManager inputMethodManager;
    @NotNull
    private final Object lock;
    private boolean monitorEnabled;
    private boolean hasPendingImmediateRequest;
    private boolean includeInsertionMarker;
    private boolean includeCharacterBounds;
    private boolean includeEditorBounds;
    private boolean includeLineBounds;
    @Nullable
    private TextFieldValue textFieldValue;
    @Nullable
    private TextLayoutResult textLayoutResult;
    @Nullable
    private OffsetMapping offsetMapping;
    @NotNull
    private Function1<? super Matrix, Unit> textFieldToRootTransform;
    @Nullable
    private Rect innerTextFieldBounds;
    @Nullable
    private Rect decorationBoxBounds;
    @NotNull
    private final CursorAnchorInfo.Builder builder;
    @NotNull
    private final float[] matrix;
    @NotNull
    private final android.graphics.Matrix androidMatrix;
    public static final int $stable = 8;

    public CursorAnchorInfoController(@NotNull PositionCalculator rootPositionCalculator, @NotNull InputMethodManager inputMethodManager) {
        this.rootPositionCalculator = rootPositionCalculator;
        this.inputMethodManager = inputMethodManager;
        this.lock = new Object();
        this.textFieldToRootTransform = textFieldToRootTransform.1.INSTANCE;
        this.builder = new CursorAnchorInfo.Builder();
        this.matrix = Matrix.constructor-impl$default(null, (int)1, null);
        this.androidMatrix = new android.graphics.Matrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestUpdate(boolean immediate, boolean monitor, boolean includeInsertionMarker, boolean includeCharacterBounds, boolean includeEditorBounds, boolean includeLineBounds) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.includeInsertionMarker = includeInsertionMarker;
            this.includeCharacterBounds = includeCharacterBounds;
            this.includeEditorBounds = includeEditorBounds;
            this.includeLineBounds = includeLineBounds;
            if (immediate) {
                this.hasPendingImmediateRequest = true;
                if (this.textFieldValue != null) {
                    this.updateCursorAnchorInfo();
                }
            }
            this.monitorEnabled = monitor;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTextLayoutResult(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Function1<? super Matrix, Unit> textFieldToRootTransform2, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.textFieldValue = textFieldValue;
            this.offsetMapping = offsetMapping;
            this.textLayoutResult = textLayoutResult;
            this.textFieldToRootTransform = textFieldToRootTransform2;
            this.innerTextFieldBounds = innerTextFieldBounds;
            this.decorationBoxBounds = decorationBoxBounds;
            if (this.hasPendingImmediateRequest || this.monitorEnabled) {
                this.updateCursorAnchorInfo();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.textFieldValue = null;
            this.offsetMapping = null;
            this.textLayoutResult = null;
            this.textFieldToRootTransform = invalidate.1.1.INSTANCE;
            this.innerTextFieldBounds = null;
            this.decorationBoxBounds = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateCursorAnchorInfo() {
        if (!this.inputMethodManager.isActive()) {
            return;
        }
        this.textFieldToRootTransform.invoke((Object)Matrix.box-impl((float[])this.matrix));
        this.rootPositionCalculator.localToScreen-58bKbWc(this.matrix);
        AndroidMatrixConversions_androidKt.setFrom-EL8BTi8((android.graphics.Matrix)this.androidMatrix, (float[])this.matrix);
        TextFieldValue textFieldValue = this.textFieldValue;
        Intrinsics.checkNotNull((Object)textFieldValue);
        OffsetMapping offsetMapping = this.offsetMapping;
        Intrinsics.checkNotNull((Object)offsetMapping);
        TextLayoutResult textLayoutResult = this.textLayoutResult;
        Intrinsics.checkNotNull((Object)textLayoutResult);
        Rect rect = this.innerTextFieldBounds;
        Intrinsics.checkNotNull((Object)rect);
        Rect rect2 = this.decorationBoxBounds;
        Intrinsics.checkNotNull((Object)rect2);
        this.inputMethodManager.updateCursorAnchorInfo(CursorAnchorInfoBuilder_androidKt.build(this.builder, textFieldValue, offsetMapping, textLayoutResult, this.androidMatrix, rect, rect2, this.includeInsertionMarker, this.includeCharacterBounds, this.includeEditorBounds, this.includeLineBounds));
        this.hasPendingImmediateRequest = false;
    }
}

