/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import android.graphics.Rect;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import java.text.BreakIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators;", "", "()V", "AbstractTextSegmentIterator", "CharacterTextSegmentIterator", "LineTextSegmentIterator", "PageTextSegmentIterator", "ParagraphTextSegmentIterator", "TextSegmentIterator", "WordTextSegmentIterator", "ui_release"})
@StabilityInferred(parameters=1)
public final class AccessibilityIterators {
    public static final int $stable;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$TextSegmentIterator;", "()V", "segment", "", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getRange", "start", "", "end", "initialize", "", "ui_release"})
    @StabilityInferred(parameters=0)
    public static abstract class AbstractTextSegmentIterator
    implements TextSegmentIterator {
        protected String text;
        @NotNull
        private final int[] segment = new int[2];
        public static final int $stable = 8;

        @NotNull
        protected final String getText() {
            String string = this.text;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            return null;
        }

        protected final void setText(@NotNull String string) {
            this.text = string;
        }

        public void initialize(@NotNull String text) {
            this.setText(text);
        }

        @Nullable
        protected final int[] getRange(int start, int end) {
            if (start < 0 || end < 0 || start == end) {
                return null;
            }
            this.segment[0] = start;
            this.segment[1] = end;
            return this.segment;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$CharacterTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "impl", "Ljava/text/BreakIterator;", "following", "", "current", "", "initialize", "", "text", "", "onLocaleChanged", "preceding", "Companion", "ui_release"})
    @StabilityInferred(parameters=0)
    public static class CharacterTextSegmentIterator
    extends AbstractTextSegmentIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private BreakIterator impl;
        public static final int $stable = 8;
        @Nullable
        private static CharacterTextSegmentIterator instance;

        private CharacterTextSegmentIterator(Locale locale) {
            this.onLocaleChanged(locale);
        }

        @Override
        public void initialize(@NotNull String text) {
            super.initialize(text);
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            breakIterator.setText(text);
        }

        @Override
        @Nullable
        public int[] following(int current) {
            int end;
            int start;
            block7: {
                BreakIterator breakIterator;
                int textLength = this.getText().length();
                if (textLength <= 0) {
                    return null;
                }
                if (current >= textLength) {
                    return null;
                }
                start = current;
                if (start < 0) {
                    start = 0;
                }
                do {
                    BreakIterator breakIterator2;
                    if ((breakIterator2 = this.impl) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                        breakIterator2 = null;
                    }
                    if (breakIterator2.isBoundary(start)) break block7;
                    breakIterator = this.impl;
                    if (breakIterator != null) continue;
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                    breakIterator = null;
                } while ((start = breakIterator.following(start)) != -1);
                return null;
            }
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            if ((end = breakIterator.following(start)) == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        @Override
        @Nullable
        public int[] preceding(int current) {
            int start;
            int end;
            block7: {
                BreakIterator breakIterator;
                int textLength = this.getText().length();
                if (textLength <= 0) {
                    return null;
                }
                if (current <= 0) {
                    return null;
                }
                end = current;
                if (end > textLength) {
                    end = textLength;
                }
                do {
                    BreakIterator breakIterator2;
                    if ((breakIterator2 = this.impl) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                        breakIterator2 = null;
                    }
                    if (breakIterator2.isBoundary(end)) break block7;
                    breakIterator = this.impl;
                    if (breakIterator != null) continue;
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                    breakIterator = null;
                } while ((end = breakIterator.preceding(end)) != -1);
                return null;
            }
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            if ((start = breakIterator.preceding(end)) == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final void onLocaleChanged(Locale locale) {
            this.impl = BreakIterator.getCharacterInstance(locale);
        }

        public /* synthetic */ CharacterTextSegmentIterator(Locale locale, DefaultConstructorMarker $constructor_marker) {
            this(locale);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$CharacterTextSegmentIterator$Companion;", "", "()V", "instance", "Landroidx/compose/ui/platform/AccessibilityIterators$CharacterTextSegmentIterator;", "getInstance", "locale", "Ljava/util/Locale;", "ui_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CharacterTextSegmentIterator getInstance(@NotNull Locale locale) {
                if (instance == null) {
                    instance = new CharacterTextSegmentIterator(locale, null);
                }
                CharacterTextSegmentIterator characterTextSegmentIterator = instance;
                Intrinsics.checkNotNull((Object)characterTextSegmentIterator, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityIterators.CharacterTextSegmentIterator");
                return characterTextSegmentIterator;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$LineTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "()V", "layoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "following", "", "current", "", "getLineEdgeIndex", "lineNumber", "direction", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "initialize", "", "text", "", "preceding", "Companion", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class LineTextSegmentIterator
    extends AbstractTextSegmentIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private TextLayoutResult layoutResult;
        public static final int $stable = 8;
        @Nullable
        private static LineTextSegmentIterator lineInstance;
        @NotNull
        private static final ResolvedTextDirection DirectionStart;
        @NotNull
        private static final ResolvedTextDirection DirectionEnd;

        private LineTextSegmentIterator() {
        }

        public final void initialize(@NotNull String text, @NotNull TextLayoutResult layoutResult) {
            this.setText(text);
            this.layoutResult = layoutResult;
        }

        @Override
        @Nullable
        public int[] following(int current) {
            TextLayoutResult textLayoutResult;
            int nextLine;
            int n;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current >= this.getText().length()) {
                return null;
            }
            if (current < 0) {
                TextLayoutResult textLayoutResult2 = this.layoutResult;
                if (textLayoutResult2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult2 = null;
                }
                n = textLayoutResult2.getLineForOffset(0);
            } else {
                int currentLine;
                TextLayoutResult textLayoutResult3 = this.layoutResult;
                if (textLayoutResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult3 = null;
                }
                n = nextLine = this.getLineEdgeIndex(currentLine = textLayoutResult3.getLineForOffset(current), DirectionStart) == current ? currentLine : currentLine + 1;
            }
            if ((textLayoutResult = this.layoutResult) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult = null;
            }
            if (nextLine >= textLayoutResult.getLineCount()) {
                return null;
            }
            int start = this.getLineEdgeIndex(nextLine, DirectionStart);
            int end = this.getLineEdgeIndex(nextLine, DirectionEnd) + 1;
            return this.getRange(start, end);
        }

        @Override
        @Nullable
        public int[] preceding(int current) {
            int previousLine;
            int n;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current <= 0) {
                return null;
            }
            if (current > this.getText().length()) {
                TextLayoutResult textLayoutResult = this.layoutResult;
                if (textLayoutResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult = null;
                }
                n = textLayoutResult.getLineForOffset(this.getText().length());
            } else {
                int currentLine;
                TextLayoutResult textLayoutResult = this.layoutResult;
                if (textLayoutResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult = null;
                }
                n = previousLine = this.getLineEdgeIndex(currentLine = textLayoutResult.getLineForOffset(current), DirectionEnd) + 1 == current ? currentLine : currentLine - 1;
            }
            if (previousLine < 0) {
                return null;
            }
            int start = this.getLineEdgeIndex(previousLine, DirectionStart);
            int end = this.getLineEdgeIndex(previousLine, DirectionEnd) + 1;
            return this.getRange(start, end);
        }

        private final int getLineEdgeIndex(int lineNumber, ResolvedTextDirection direction) {
            int n;
            ResolvedTextDirection paragraphDirection;
            TextLayoutResult textLayoutResult = this.layoutResult;
            if (textLayoutResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult = null;
            }
            int lineStart = textLayoutResult.getLineStart(lineNumber);
            TextLayoutResult textLayoutResult2 = this.layoutResult;
            if (textLayoutResult2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult2 = null;
            }
            if (direction != (paragraphDirection = textLayoutResult2.getParagraphDirection(lineStart))) {
                TextLayoutResult textLayoutResult3 = this.layoutResult;
                if (textLayoutResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult3 = null;
                }
                n = textLayoutResult3.getLineStart(lineNumber);
            } else {
                TextLayoutResult textLayoutResult4 = this.layoutResult;
                if (textLayoutResult4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult4 = null;
                }
                n = TextLayoutResult.getLineEnd$default((TextLayoutResult)textLayoutResult4, (int)lineNumber, (boolean)false, (int)2, null) - 1;
            }
            return n;
        }

        public /* synthetic */ LineTextSegmentIterator(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DirectionStart = ResolvedTextDirection.Rtl;
            DirectionEnd = ResolvedTextDirection.Ltr;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$LineTextSegmentIterator$Companion;", "", "()V", "DirectionEnd", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "DirectionStart", "lineInstance", "Landroidx/compose/ui/platform/AccessibilityIterators$LineTextSegmentIterator;", "getInstance", "ui_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LineTextSegmentIterator getInstance() {
                if (lineInstance == null) {
                    lineInstance = new LineTextSegmentIterator(null);
                }
                LineTextSegmentIterator lineTextSegmentIterator = lineInstance;
                Intrinsics.checkNotNull((Object)lineTextSegmentIterator, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityIterators.LineTextSegmentIterator");
                return lineTextSegmentIterator;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$PageTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "()V", "layoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "node", "Landroidx/compose/ui/semantics/SemanticsNode;", "tempRect", "Landroid/graphics/Rect;", "following", "", "current", "", "getLineEdgeIndex", "lineNumber", "direction", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "initialize", "", "text", "", "preceding", "Companion", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class PageTextSegmentIterator
    extends AbstractTextSegmentIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private TextLayoutResult layoutResult;
        private SemanticsNode node;
        @NotNull
        private Rect tempRect = new Rect();
        public static final int $stable = 8;
        @Nullable
        private static PageTextSegmentIterator pageInstance;
        @NotNull
        private static final ResolvedTextDirection DirectionStart;
        @NotNull
        private static final ResolvedTextDirection DirectionEnd;

        private PageTextSegmentIterator() {
        }

        public final void initialize(@NotNull String text, @NotNull TextLayoutResult layoutResult, @NotNull SemanticsNode node) {
            this.setText(text);
            this.layoutResult = layoutResult;
            this.node = node;
        }

        @Override
        @Nullable
        public int[] following(int current) {
            int n;
            float lastLineTop;
            TextLayoutResult textLayoutResult;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current >= this.getText().length()) {
                return null;
            }
            int pageHeight = 0;
            try {
                SemanticsNode semanticsNode2 = this.node;
                if (semanticsNode2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"node");
                    semanticsNode2 = null;
                }
                pageHeight = MathKt.roundToInt((float)semanticsNode2.getBoundsInRoot().getHeight());
            }
            catch (IllegalStateException e) {
                return null;
            }
            int start = RangesKt.coerceAtLeast((int)0, (int)current);
            TextLayoutResult textLayoutResult2 = this.layoutResult;
            if (textLayoutResult2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult2 = null;
            }
            int currentLine = textLayoutResult2.getLineForOffset(start);
            TextLayoutResult textLayoutResult3 = this.layoutResult;
            if (textLayoutResult3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult3 = null;
            }
            float currentLineTop = textLayoutResult3.getLineTop(currentLine);
            float nextPageStartY = currentLineTop + (float)pageHeight;
            TextLayoutResult textLayoutResult4 = this.layoutResult;
            if (textLayoutResult4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult4 = null;
            }
            if ((textLayoutResult = this.layoutResult) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult = null;
            }
            if (nextPageStartY < (lastLineTop = textLayoutResult4.getLineTop(textLayoutResult.getLineCount() - 1))) {
                TextLayoutResult textLayoutResult5 = this.layoutResult;
                if (textLayoutResult5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult5 = null;
                }
                n = textLayoutResult5.getLineForVerticalPosition(nextPageStartY) - 1;
            } else {
                TextLayoutResult textLayoutResult6 = this.layoutResult;
                if (textLayoutResult6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult6 = null;
                }
                n = textLayoutResult6.getLineCount() - 1;
            }
            int currentPageEndLine = n;
            int end = this.getLineEdgeIndex(currentPageEndLine, DirectionEnd) + 1;
            return this.getRange(start, end);
        }

        @Override
        @Nullable
        public int[] preceding(int current) {
            int currentPageStartLine;
            int n;
            float currentLineTop;
            float previousPageEndY;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current <= 0) {
                return null;
            }
            int pageHeight = 0;
            try {
                SemanticsNode semanticsNode2 = this.node;
                if (semanticsNode2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"node");
                    semanticsNode2 = null;
                }
                pageHeight = MathKt.roundToInt((float)semanticsNode2.getBoundsInRoot().getHeight());
            }
            catch (IllegalStateException e) {
                return null;
            }
            int end = RangesKt.coerceAtMost((int)this.getText().length(), (int)current);
            TextLayoutResult textLayoutResult = this.layoutResult;
            if (textLayoutResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult = null;
            }
            int currentLine = textLayoutResult.getLineForOffset(end);
            TextLayoutResult textLayoutResult2 = this.layoutResult;
            if (textLayoutResult2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult2 = null;
            }
            if ((previousPageEndY = (currentLineTop = textLayoutResult2.getLineTop(currentLine)) - (float)pageHeight) > 0.0f) {
                TextLayoutResult textLayoutResult3 = this.layoutResult;
                if (textLayoutResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult3 = null;
                }
                n = textLayoutResult3.getLineForVerticalPosition(previousPageEndY);
            } else {
                n = currentPageStartLine = 0;
            }
            if (end == this.getText().length() && currentPageStartLine < currentLine) {
                ++currentPageStartLine;
            }
            int start = this.getLineEdgeIndex(currentPageStartLine, DirectionStart);
            return this.getRange(start, end);
        }

        private final int getLineEdgeIndex(int lineNumber, ResolvedTextDirection direction) {
            int n;
            ResolvedTextDirection paragraphDirection;
            TextLayoutResult textLayoutResult = this.layoutResult;
            if (textLayoutResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult = null;
            }
            int lineStart = textLayoutResult.getLineStart(lineNumber);
            TextLayoutResult textLayoutResult2 = this.layoutResult;
            if (textLayoutResult2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                textLayoutResult2 = null;
            }
            if (direction != (paragraphDirection = textLayoutResult2.getParagraphDirection(lineStart))) {
                TextLayoutResult textLayoutResult3 = this.layoutResult;
                if (textLayoutResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult3 = null;
                }
                n = textLayoutResult3.getLineStart(lineNumber);
            } else {
                TextLayoutResult textLayoutResult4 = this.layoutResult;
                if (textLayoutResult4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutResult");
                    textLayoutResult4 = null;
                }
                n = TextLayoutResult.getLineEnd$default((TextLayoutResult)textLayoutResult4, (int)lineNumber, (boolean)false, (int)2, null) - 1;
            }
            return n;
        }

        public /* synthetic */ PageTextSegmentIterator(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DirectionStart = ResolvedTextDirection.Rtl;
            DirectionEnd = ResolvedTextDirection.Ltr;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$PageTextSegmentIterator$Companion;", "", "()V", "DirectionEnd", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "DirectionStart", "pageInstance", "Landroidx/compose/ui/platform/AccessibilityIterators$PageTextSegmentIterator;", "getInstance", "ui_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PageTextSegmentIterator getInstance() {
                if (pageInstance == null) {
                    pageInstance = new PageTextSegmentIterator(null);
                }
                PageTextSegmentIterator pageTextSegmentIterator = pageInstance;
                Intrinsics.checkNotNull((Object)pageTextSegmentIterator, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityIterators.PageTextSegmentIterator");
                return pageTextSegmentIterator;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$ParagraphTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "()V", "following", "", "current", "", "isEndBoundary", "", "index", "isStartBoundary", "preceding", "Companion", "ui_release"})
    @StabilityInferred(parameters=1)
    public static final class ParagraphTextSegmentIterator
    extends AbstractTextSegmentIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable;
        @Nullable
        private static ParagraphTextSegmentIterator instance;

        private ParagraphTextSegmentIterator() {
        }

        @Override
        @Nullable
        public int[] following(int current) {
            int end;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current >= textLength) {
                return null;
            }
            int start = current;
            if (start < 0) {
                start = 0;
            }
            while (start < textLength && this.getText().charAt(start) == '\n' && !this.isStartBoundary(start)) {
                ++start;
            }
            if (start >= textLength) {
                return null;
            }
            for (end = start + 1; end < textLength && !this.isEndBoundary(end); ++end) {
            }
            return this.getRange(start, end);
        }

        @Override
        @Nullable
        public int[] preceding(int current) {
            int start;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current <= 0) {
                return null;
            }
            int end = current;
            if (end > textLength) {
                end = textLength;
            }
            while (end > 0 && this.getText().charAt(end - 1) == '\n' && !this.isEndBoundary(end)) {
                --end;
            }
            if (end <= 0) {
                return null;
            }
            for (start = end - 1; start > 0 && !this.isStartBoundary(start); --start) {
            }
            return this.getRange(start, end);
        }

        private final boolean isStartBoundary(int index) {
            return this.getText().charAt(index) != '\n' && (index == 0 || this.getText().charAt(index - 1) == '\n');
        }

        private final boolean isEndBoundary(int index) {
            return index > 0 && this.getText().charAt(index - 1) != '\n' && (index == this.getText().length() || this.getText().charAt(index) == '\n');
        }

        public /* synthetic */ ParagraphTextSegmentIterator(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$ParagraphTextSegmentIterator$Companion;", "", "()V", "instance", "Landroidx/compose/ui/platform/AccessibilityIterators$ParagraphTextSegmentIterator;", "getInstance", "ui_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ParagraphTextSegmentIterator getInstance() {
                if (instance == null) {
                    instance = new ParagraphTextSegmentIterator(null);
                }
                ParagraphTextSegmentIterator paragraphTextSegmentIterator = instance;
                Intrinsics.checkNotNull((Object)paragraphTextSegmentIterator, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityIterators.ParagraphTextSegmentIterator");
                return paragraphTextSegmentIterator;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$TextSegmentIterator;", "", "following", "", "current", "", "preceding", "ui_release"})
    public static interface TextSegmentIterator {
        @Nullable
        public int[] following(int var1);

        @Nullable
        public int[] preceding(int var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$WordTextSegmentIterator;", "Landroidx/compose/ui/platform/AccessibilityIterators$AbstractTextSegmentIterator;", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "impl", "Ljava/text/BreakIterator;", "following", "", "current", "", "initialize", "", "text", "", "isEndBoundary", "", "index", "isLetterOrDigit", "isStartBoundary", "onLocaleChanged", "preceding", "Companion", "ui_release"})
    @StabilityInferred(parameters=0)
    public static final class WordTextSegmentIterator
    extends AbstractTextSegmentIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private BreakIterator impl;
        public static final int $stable = 8;
        @Nullable
        private static WordTextSegmentIterator instance;

        private WordTextSegmentIterator(Locale locale) {
            this.onLocaleChanged(locale);
        }

        @Override
        public void initialize(@NotNull String text) {
            super.initialize(text);
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            breakIterator.setText(text);
        }

        private final void onLocaleChanged(Locale locale) {
            this.impl = BreakIterator.getWordInstance(locale);
        }

        @Override
        @Nullable
        public int[] following(int current) {
            int end;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current >= this.getText().length()) {
                return null;
            }
            int start = current;
            if (start < 0) {
                start = 0;
            }
            while (!this.isLetterOrDigit(start) && !this.isStartBoundary(start)) {
                BreakIterator breakIterator = this.impl;
                if (breakIterator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                    breakIterator = null;
                }
                if ((start = breakIterator.following(start)) != -1) continue;
                return null;
            }
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            if ((end = breakIterator.following(start)) == -1 || !this.isEndBoundary(end)) {
                return null;
            }
            return this.getRange(start, end);
        }

        @Override
        @Nullable
        public int[] preceding(int current) {
            int start;
            int textLength = this.getText().length();
            if (textLength <= 0) {
                return null;
            }
            if (current <= 0) {
                return null;
            }
            int end = current;
            if (end > textLength) {
                end = textLength;
            }
            while (end > 0 && !this.isLetterOrDigit(end - 1) && !this.isEndBoundary(end)) {
                BreakIterator breakIterator = this.impl;
                if (breakIterator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                    breakIterator = null;
                }
                if ((end = breakIterator.preceding(end)) != -1) continue;
                return null;
            }
            BreakIterator breakIterator = this.impl;
            if (breakIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                breakIterator = null;
            }
            if ((start = breakIterator.preceding(end)) == -1 || !this.isStartBoundary(start)) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final boolean isStartBoundary(int index) {
            return this.isLetterOrDigit(index) && (index == 0 || !this.isLetterOrDigit(index - 1));
        }

        private final boolean isEndBoundary(int index) {
            return index > 0 && this.isLetterOrDigit(index - 1) && (index == this.getText().length() || !this.isLetterOrDigit(index));
        }

        private final boolean isLetterOrDigit(int index) {
            if (index >= 0 && index < this.getText().length()) {
                int codePoint = this.getText().codePointAt(index);
                return Character.isLetterOrDigit(codePoint);
            }
            return false;
        }

        public /* synthetic */ WordTextSegmentIterator(Locale locale, DefaultConstructorMarker $constructor_marker) {
            this(locale);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/platform/AccessibilityIterators$WordTextSegmentIterator$Companion;", "", "()V", "instance", "Landroidx/compose/ui/platform/AccessibilityIterators$WordTextSegmentIterator;", "getInstance", "locale", "Ljava/util/Locale;", "ui_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final WordTextSegmentIterator getInstance(@NotNull Locale locale) {
                if (instance == null) {
                    instance = new WordTextSegmentIterator(locale, null);
                }
                WordTextSegmentIterator wordTextSegmentIterator = instance;
                Intrinsics.checkNotNull((Object)wordTextSegmentIterator, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityIterators.WordTextSegmentIterator");
                return wordTextSegmentIterator;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

