/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector.compat;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.TypedValue;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.StrokeJoin;
import androidx.compose.ui.graphics.vector.ImageVector;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import androidx.compose.ui.graphics.vector.compat.AndroidVectorParser;
import androidx.compose.ui.graphics.vector.compat.AndroidVectorResources;
import androidx.compose.ui.unit.Dp;
import androidx.core.content.res.ComplexColorCompat;
import androidx.core.content.res.TypedArrayUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a'\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\rH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0013H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0011\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a*\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0000\u001a\f\u0010\"\u001a\u00020#*\u00020$H\u0000\u001a2\u0010%\u001a\u00020&*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u001aH\u0000\u001a<\u0010(\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u001d2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a2\u0010*\u001a\u00020&*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u001aH\u0000\u001a2\u0010+\u001a\u00020&*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u001aH\u0000\u001a\f\u0010,\u001a\u00020$*\u00020$H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006-"}, d2={"FILL_TYPE_WINDING", "", "LINECAP_BUTT", "LINECAP_ROUND", "LINECAP_SQUARE", "LINEJOIN_BEVEL", "LINEJOIN_MITER", "LINEJOIN_ROUND", "SHAPE_CLIP_PATH", "", "SHAPE_GROUP", "SHAPE_PATH", "getStrokeLineCap", "Landroidx/compose/ui/graphics/StrokeCap;", "id", "defValue", "getStrokeLineCap-CSYIeUk", "(II)I", "getStrokeLineJoin", "Landroidx/compose/ui/graphics/StrokeJoin;", "getStrokeLineJoin-kLtJ_vA", "obtainBrushFromComplexColor", "Landroidx/compose/ui/graphics/Brush;", "complexColor", "Landroidx/core/content/res/ComplexColorCompat;", "createVectorImageBuilder", "Landroidx/compose/ui/graphics/vector/ImageVector$Builder;", "Landroidx/compose/ui/graphics/vector/compat/AndroidVectorParser;", "res", "Landroid/content/res/Resources;", "theme", "Landroid/content/res/Resources$Theme;", "attrs", "Landroid/util/AttributeSet;", "isAtEnd", "", "Lorg/xmlpull/v1/XmlPullParser;", "parseClipPath", "", "builder", "parseCurrentVectorNode", "nestedGroups", "parseGroup", "parsePath", "seekToStartTag", "ui_release"})
@SourceDebugExtension(value={"SMAP\nXmlVectorParser.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlVectorParser.android.kt\nandroidx/compose/ui/graphics/vector/compat/XmlVectorParser_androidKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,726:1\n174#2:727\n174#2:728\n*S KotlinDebug\n*F\n+ 1 XmlVectorParser.android.kt\nandroidx/compose/ui/graphics/vector/compat/XmlVectorParser_androidKt\n*L\n239#1:727\n240#1:728\n*E\n"})
public final class XmlVectorParser_androidKt {
    private static final int LINECAP_BUTT = 0;
    private static final int LINECAP_ROUND = 1;
    private static final int LINECAP_SQUARE = 2;
    private static final int LINEJOIN_MITER = 0;
    private static final int LINEJOIN_ROUND = 1;
    private static final int LINEJOIN_BEVEL = 2;
    private static final int FILL_TYPE_WINDING;
    @NotNull
    private static final String SHAPE_CLIP_PATH = "clip-path";
    @NotNull
    private static final String SHAPE_GROUP = "group";
    @NotNull
    private static final String SHAPE_PATH = "path";

    private static final int getStrokeLineCap-CSYIeUk(int id, int defValue) {
        int n;
        switch (id) {
            case 0: {
                n = StrokeCap.Companion.getButt-KaPHkGw();
                break;
            }
            case 1: {
                n = StrokeCap.Companion.getRound-KaPHkGw();
                break;
            }
            case 2: {
                n = StrokeCap.Companion.getSquare-KaPHkGw();
                break;
            }
            default: {
                n = defValue;
            }
        }
        return n;
    }

    static /* synthetic */ int getStrokeLineCap-CSYIeUk$default(int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = StrokeCap.Companion.getButt-KaPHkGw();
        }
        return XmlVectorParser_androidKt.getStrokeLineCap-CSYIeUk(n, n2);
    }

    private static final int getStrokeLineJoin-kLtJ_vA(int id, int defValue) {
        int n;
        switch (id) {
            case 0: {
                n = StrokeJoin.Companion.getMiter-LxFBmk8();
                break;
            }
            case 1: {
                n = StrokeJoin.Companion.getRound-LxFBmk8();
                break;
            }
            case 2: {
                n = StrokeJoin.Companion.getBevel-LxFBmk8();
                break;
            }
            default: {
                n = defValue;
            }
        }
        return n;
    }

    static /* synthetic */ int getStrokeLineJoin-kLtJ_vA$default(int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = StrokeJoin.Companion.getMiter-LxFBmk8();
        }
        return XmlVectorParser_androidKt.getStrokeLineJoin-kLtJ_vA(n, n2);
    }

    public static final boolean isAtEnd(@NotNull XmlPullParser $this$isAtEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$isAtEnd, (String)"<this>");
        return $this$isAtEnd.getEventType() == 1 || $this$isAtEnd.getDepth() < 1 && $this$isAtEnd.getEventType() == 3;
    }

    public static final int parseCurrentVectorNode(@NotNull AndroidVectorParser $this$parseCurrentVectorNode, @NotNull Resources res, @NotNull AttributeSet attrs, @Nullable Resources.Theme theme, @NotNull ImageVector.Builder builder, int nestedGroups) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCurrentVectorNode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        switch ($this$parseCurrentVectorNode.getXmlParser().getEventType()) {
            case 2: {
                String string = $this$parseCurrentVectorNode.getXmlParser().getName();
                if (string == null) break;
                int n = -1;
                switch (string.hashCode()) {
                    case 3433509: {
                        if (string.equals(SHAPE_PATH)) {
                            n = 1;
                        }
                        break;
                    }
                    case -1649314686: {
                        if (string.equals(SHAPE_CLIP_PATH)) {
                            n = 2;
                        }
                        break;
                    }
                    case 98629247: {
                        if (string.equals(SHAPE_GROUP)) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        XmlVectorParser_androidKt.parsePath($this$parseCurrentVectorNode, res, theme, attrs, builder);
                        break;
                    }
                    case 2: {
                        XmlVectorParser_androidKt.parseClipPath($this$parseCurrentVectorNode, res, theme, attrs, builder);
                        return nestedGroups + 1;
                    }
                    case 3: {
                        XmlVectorParser_androidKt.parseGroup($this$parseCurrentVectorNode, res, theme, attrs, builder);
                    }
                }
                break;
            }
            case 3: {
                if (!Intrinsics.areEqual((Object)SHAPE_GROUP, (Object)$this$parseCurrentVectorNode.getXmlParser().getName())) break;
                int n = nestedGroups + 1;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    builder.clearGroup();
                }
                return 0;
            }
        }
        return nestedGroups;
    }

    public static /* synthetic */ int parseCurrentVectorNode$default(AndroidVectorParser androidVectorParser, Resources resources, AttributeSet attributeSet, Resources.Theme theme, ImageVector.Builder builder, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            theme = null;
        }
        return XmlVectorParser_androidKt.parseCurrentVectorNode(androidVectorParser, resources, attributeSet, theme, builder, n);
    }

    @NotNull
    public static final XmlPullParser seekToStartTag(@NotNull XmlPullParser $this$seekToStartTag) throws XmlPullParserException {
        Intrinsics.checkNotNullParameter((Object)$this$seekToStartTag, (String)"<this>");
        int type = $this$seekToStartTag.next();
        while (type != 2 && type != 1) {
            type = $this$seekToStartTag.next();
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return $this$seekToStartTag;
    }

    @NotNull
    public static final ImageVector.Builder createVectorImageBuilder(@NotNull AndroidVectorParser $this$createVectorImageBuilder, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs) {
        int n;
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$createVectorImageBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        TypedArray vectorAttrs = $this$createVectorImageBuilder.obtainAttributes(res, theme, attrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TYPE_ARRAY());
        boolean autoMirror = $this$createVectorImageBuilder.getNamedBoolean(vectorAttrs, "autoMirrored", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_AUTO_MIRRORED(), false);
        float viewportWidth = $this$createVectorImageBuilder.getNamedFloat(vectorAttrs, "viewportWidth", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_VIEWPORT_WIDTH(), 0.0f);
        float viewportHeight = $this$createVectorImageBuilder.getNamedFloat(vectorAttrs, "viewportHeight", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_VIEWPORT_HEIGHT(), 0.0f);
        if (viewportWidth <= 0.0f) {
            throw new XmlPullParserException(vectorAttrs.getPositionDescription() + "<VectorGraphic> tag requires viewportWidth > 0");
        }
        if (viewportHeight <= 0.0f) {
            throw new XmlPullParserException(vectorAttrs.getPositionDescription() + "<VectorGraphic> tag requires viewportHeight > 0");
        }
        float defaultWidth = $this$createVectorImageBuilder.getDimension(vectorAttrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_WIDTH(), 0.0f);
        float defaultHeight = $this$createVectorImageBuilder.getDimension(vectorAttrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_HEIGHT(), 0.0f);
        if (vectorAttrs.hasValue(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TINT())) {
            ColorStateList tintColorStateList;
            TypedValue value = new TypedValue();
            vectorAttrs.getValue(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TINT(), value);
            l = value.type == 2 ? Color.Companion.getUnspecified-0d7_KjU() : ((tintColorStateList = $this$createVectorImageBuilder.getNamedColorStateList(vectorAttrs, theme, "tint", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TINT())) != null ? ColorKt.Color((int)tintColorStateList.getDefaultColor()) : Color.Companion.getUnspecified-0d7_KjU());
        } else {
            l = Color.Companion.getUnspecified-0d7_KjU();
        }
        long tintColor = l;
        int blendModeValue = $this$createVectorImageBuilder.getInt(vectorAttrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TINT_MODE(), -1);
        if (blendModeValue != -1) {
            switch (blendModeValue) {
                case 3: {
                    n = BlendMode.Companion.getSrcOver-0nO6VwU();
                    break;
                }
                case 5: {
                    n = BlendMode.Companion.getSrcIn-0nO6VwU();
                    break;
                }
                case 9: {
                    n = BlendMode.Companion.getSrcAtop-0nO6VwU();
                    break;
                }
                case 14: {
                    n = BlendMode.Companion.getModulate-0nO6VwU();
                    break;
                }
                case 15: {
                    n = BlendMode.Companion.getScreen-0nO6VwU();
                    break;
                }
                case 16: {
                    n = BlendMode.Companion.getPlus-0nO6VwU();
                    break;
                }
                default: {
                    n = BlendMode.Companion.getSrcIn-0nO6VwU();
                    break;
                }
            }
        } else {
            n = BlendMode.Companion.getSrcIn-0nO6VwU();
        }
        int tintBlendMode = n;
        float $this$dp$iv = defaultWidth / res.getDisplayMetrics().density;
        boolean $i$f$getDp = false;
        float defaultWidthDp = Dp.constructor-impl((float)$this$dp$iv);
        float $this$dp$iv2 = defaultHeight / res.getDisplayMetrics().density;
        boolean $i$f$getDp2 = false;
        float defaultHeightDp = Dp.constructor-impl((float)$this$dp$iv2);
        vectorAttrs.recycle();
        return new ImageVector.Builder(null, defaultWidthDp, defaultHeightDp, viewportWidth, viewportHeight, tintColor, tintBlendMode, autoMirror, 1, null);
    }

    public static final void parsePath(@NotNull AndroidVectorParser $this$parsePath, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs, @NotNull ImageVector.Builder builder) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$parsePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TypedArray a = $this$parsePath.obtainAttributes(res, theme, attrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH());
        boolean hasPathData = TypedArrayUtils.hasAttribute((XmlPullParser)$this$parsePath.getXmlParser(), (String)"pathData");
        if (!hasPathData) {
            throw new IllegalArgumentException("No path data available");
        }
        String string = $this$parsePath.getString(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_NAME());
        if (string == null) {
            string = "";
        }
        String name = string;
        String pathStr = $this$parsePath.getString(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_PATH_DATA());
        List<PathNode> pathData = VectorKt.addPathNodes(pathStr);
        ComplexColorCompat fillColor = $this$parsePath.getNamedComplexColor(a, theme, "fillColor", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_FILL_COLOR(), 0);
        float fillAlpha = $this$parsePath.getNamedFloat(a, "fillAlpha", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_FILL_ALPHA(), 1.0f);
        int lineCap = $this$parsePath.getNamedInt(a, "strokeLineCap", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_LINE_CAP(), -1);
        int strokeLineCap = XmlVectorParser_androidKt.getStrokeLineCap-CSYIeUk(lineCap, StrokeCap.Companion.getButt-KaPHkGw());
        int lineJoin = $this$parsePath.getNamedInt(a, "strokeLineJoin", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_LINE_JOIN(), -1);
        int strokeLineJoin = XmlVectorParser_androidKt.getStrokeLineJoin-kLtJ_vA(lineJoin, StrokeJoin.Companion.getBevel-LxFBmk8());
        float strokeMiterLimit = $this$parsePath.getNamedFloat(a, "strokeMiterLimit", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_MITER_LIMIT(), 1.0f);
        ComplexColorCompat strokeColor = $this$parsePath.getNamedComplexColor(a, theme, "strokeColor", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_COLOR(), 0);
        float strokeAlpha = $this$parsePath.getNamedFloat(a, "strokeAlpha", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_ALPHA(), 1.0f);
        float strokeLineWidth = $this$parsePath.getNamedFloat(a, "strokeWidth", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_WIDTH(), 1.0f);
        float trimPathEnd = $this$parsePath.getNamedFloat(a, "trimPathEnd", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_TRIM_PATH_END(), 1.0f);
        float trimPathOffset = $this$parsePath.getNamedFloat(a, "trimPathOffset", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_TRIM_PATH_OFFSET(), 0.0f);
        float trimPathStart = $this$parsePath.getNamedFloat(a, "trimPathStart", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_TRIM_PATH_START(), 0.0f);
        int fillRule = $this$parsePath.getNamedInt(a, "fillType", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_TRIM_PATH_FILLTYPE(), FILL_TYPE_WINDING);
        a.recycle();
        Brush fillBrush = XmlVectorParser_androidKt.obtainBrushFromComplexColor(fillColor);
        Brush strokeBrush = XmlVectorParser_androidKt.obtainBrushFromComplexColor(strokeColor);
        int fillPathType = fillRule == 0 ? PathFillType.Companion.getNonZero-Rg-k1Os() : PathFillType.Companion.getEvenOdd-Rg-k1Os();
        builder.addPath-oIyEayM(pathData, fillPathType, name, fillBrush, fillAlpha, strokeBrush, strokeAlpha, strokeLineWidth, strokeLineCap, strokeLineJoin, strokeMiterLimit, trimPathStart, trimPathEnd, trimPathOffset);
    }

    private static final Brush obtainBrushFromComplexColor(ComplexColorCompat complexColor) {
        Shader shader;
        return complexColor.willDraw() ? ((shader = complexColor.getShader()) != null ? (Brush)BrushKt.ShaderBrush((Shader)shader) : (Brush)new SolidColor(ColorKt.Color((int)complexColor.getColor()), null)) : null;
    }

    public static final void parseClipPath(@NotNull AndroidVectorParser $this$parseClipPath, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs, @NotNull ImageVector.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$this$parseClipPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TypedArray a = $this$parseClipPath.obtainAttributes(res, theme, attrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_CLIP_PATH());
        String string = $this$parseClipPath.getString(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_CLIP_PATH_NAME());
        if (string == null) {
            string = "";
        }
        String name = string;
        List<PathNode> pathData = VectorKt.addPathNodes($this$parseClipPath.getString(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_CLIP_PATH_PATH_DATA()));
        a.recycle();
        ImageVector.Builder.addGroup$default(builder, name, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, pathData, 254, null);
    }

    public static final void parseGroup(@NotNull AndroidVectorParser $this$parseGroup, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs, @NotNull ImageVector.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$this$parseGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TypedArray a = $this$parseGroup.obtainAttributes(res, theme, attrs, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP());
        float rotate = $this$parseGroup.getNamedFloat(a, "rotation", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_ROTATION(), 0.0f);
        float pivotX = $this$parseGroup.getFloat(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_PIVOT_X(), 0.0f);
        float pivotY = $this$parseGroup.getFloat(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_PIVOT_Y(), 0.0f);
        float scaleX = $this$parseGroup.getNamedFloat(a, "scaleX", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_SCALE_X(), 1.0f);
        float scaleY = $this$parseGroup.getNamedFloat(a, "scaleY", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_SCALE_Y(), 1.0f);
        float translateX = $this$parseGroup.getNamedFloat(a, "translateX", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_TRANSLATE_X(), 0.0f);
        float translateY = $this$parseGroup.getNamedFloat(a, "translateY", AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_TRANSLATE_Y(), 0.0f);
        String string = $this$parseGroup.getString(a, AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_NAME());
        if (string == null) {
            string = "";
        }
        String name = string;
        a.recycle();
        builder.addGroup(name, rotate, pivotX, pivotY, scaleX, scaleY, translateX, translateY, VectorKt.getEmptyPath());
    }
}

