/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.layout;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u00020\u0007*\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\n\u001a\u00020\u0007*\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"boundsInParent", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "boundsInRoot", "boundsInWindow", "findRootCoordinates", "positionInParent", "Landroidx/compose/ui/geometry/Offset;", "(Landroidx/compose/ui/layout/LayoutCoordinates;)J", "positionInRoot", "positionInWindow", "ui_release"})
public final class LayoutCoordinatesKt {
    public static final long positionInRoot(@NotNull LayoutCoordinates $this$positionInRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInRoot, (String)"<this>");
        return $this$positionInRoot.localToRoot-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    public static final long positionInWindow(@NotNull LayoutCoordinates $this$positionInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInWindow, (String)"<this>");
        return $this$positionInWindow.localToWindow-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    @NotNull
    public static final Rect boundsInRoot(@NotNull LayoutCoordinates $this$boundsInRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInRoot, (String)"<this>");
        return LayoutCoordinates.localBoundingBoxOf$default(LayoutCoordinatesKt.findRootCoordinates($this$boundsInRoot), $this$boundsInRoot, false, 2, null);
    }

    @NotNull
    public static final Rect boundsInWindow(@NotNull LayoutCoordinates $this$boundsInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInWindow, (String)"<this>");
        LayoutCoordinates root2 = LayoutCoordinatesKt.findRootCoordinates($this$boundsInWindow);
        Rect bounds = LayoutCoordinatesKt.boundsInRoot($this$boundsInWindow);
        float rootWidth = IntSize.getWidth-impl((long)root2.getSize-YbymL2g());
        float rootHeight = IntSize.getHeight-impl((long)root2.getSize-YbymL2g());
        float boundsLeft = RangesKt.coerceIn((float)bounds.getLeft(), (float)0.0f, (float)rootWidth);
        float boundsTop = RangesKt.coerceIn((float)bounds.getTop(), (float)0.0f, (float)rootHeight);
        float boundsRight = RangesKt.coerceIn((float)bounds.getRight(), (float)0.0f, (float)rootWidth);
        float boundsBottom = RangesKt.coerceIn((float)bounds.getBottom(), (float)0.0f, (float)rootHeight);
        if (boundsLeft == boundsRight || boundsTop == boundsBottom) {
            return Rect.Companion.getZero();
        }
        long topLeft = root2.localToWindow-MK-Hz9U(OffsetKt.Offset((float)boundsLeft, (float)boundsTop));
        long topRight = root2.localToWindow-MK-Hz9U(OffsetKt.Offset((float)boundsRight, (float)boundsTop));
        long bottomRight = root2.localToWindow-MK-Hz9U(OffsetKt.Offset((float)boundsRight, (float)boundsBottom));
        long bottomLeft = root2.localToWindow-MK-Hz9U(OffsetKt.Offset((float)boundsLeft, (float)boundsBottom));
        float[] fArray = new float[]{Offset.getX-impl((long)topRight), Offset.getX-impl((long)bottomLeft), Offset.getX-impl((long)bottomRight)};
        float left = ComparisonsKt.minOf((float)Offset.getX-impl((long)topLeft), (float[])fArray);
        float[] fArray2 = new float[]{Offset.getY-impl((long)topRight), Offset.getY-impl((long)bottomLeft), Offset.getY-impl((long)bottomRight)};
        float top = ComparisonsKt.minOf((float)Offset.getY-impl((long)topLeft), (float[])fArray2);
        float[] fArray3 = new float[]{Offset.getX-impl((long)topRight), Offset.getX-impl((long)bottomLeft), Offset.getX-impl((long)bottomRight)};
        float right = ComparisonsKt.maxOf((float)Offset.getX-impl((long)topLeft), (float[])fArray3);
        float[] fArray4 = new float[]{Offset.getY-impl((long)topRight), Offset.getY-impl((long)bottomLeft), Offset.getY-impl((long)bottomRight)};
        float bottom = ComparisonsKt.maxOf((float)Offset.getY-impl((long)topLeft), (float[])fArray4);
        return new Rect(left, top, right, bottom);
    }

    public static final long positionInParent(@NotNull LayoutCoordinates $this$positionInParent) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInParent, (String)"<this>");
        LayoutCoordinates layoutCoordinates = $this$positionInParent.getParentLayoutCoordinates();
        return layoutCoordinates != null ? layoutCoordinates.localPositionOf-R5De75A($this$positionInParent, Offset.Companion.getZero-F1C5BW0()) : Offset.Companion.getZero-F1C5BW0();
    }

    @NotNull
    public static final Rect boundsInParent(@NotNull LayoutCoordinates $this$boundsInParent) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInParent, (String)"<this>");
        LayoutCoordinates layoutCoordinates = $this$boundsInParent.getParentLayoutCoordinates();
        if (layoutCoordinates == null || (layoutCoordinates = LayoutCoordinates.localBoundingBoxOf$default(layoutCoordinates, $this$boundsInParent, false, 2, null)) == null) {
            layoutCoordinates = new Rect(0.0f, 0.0f, (float)IntSize.getWidth-impl((long)$this$boundsInParent.getSize-YbymL2g()), (float)IntSize.getHeight-impl((long)$this$boundsInParent.getSize-YbymL2g()));
        }
        return layoutCoordinates;
    }

    @NotNull
    public static final LayoutCoordinates findRootCoordinates(@NotNull LayoutCoordinates $this$findRootCoordinates) {
        Intrinsics.checkNotNullParameter((Object)$this$findRootCoordinates, (String)"<this>");
        LayoutCoordinates root2 = $this$findRootCoordinates;
        LayoutCoordinates parent2 = root2.getParentLayoutCoordinates();
        while (parent2 != null) {
            root2 = parent2;
            parent2 = root2.getParentLayoutCoordinates();
        }
        LayoutCoordinates layoutCoordinates = root2;
        NodeCoordinator nodeCoordinator = layoutCoordinates instanceof NodeCoordinator ? (NodeCoordinator)layoutCoordinates : null;
        if (nodeCoordinator == null) {
            return root2;
        }
        NodeCoordinator rootCoordinator = nodeCoordinator;
        for (NodeCoordinator parentCoordinator = rootCoordinator.getWrappedBy$ui_release(); parentCoordinator != null; parentCoordinator = parentCoordinator.getWrappedBy$ui_release()) {
            rootCoordinator = parentCoordinator;
        }
        return rootCoordinator;
    }
}

