/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.runtime.lint.ProduceStateDetector;
import androidx.compose.runtime.lint.ProduceStateDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMultiResolvable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/runtime/lint/ProduceStateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nProduceStateDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProduceStateDetector.kt\nandroidx/compose/runtime/lint/ProduceStateDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class ProduceStateDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ProduceStateDoesNotAssignValue = Issue.Companion.create("ProduceStateDoesNotAssignValue", "produceState calls should assign `value` inside the producer lambda", "produceState returns an observable State using values assigned inside the producer lambda. If the lambda never assigns (i.e `value = foo`), then the State will never change. Make sure to assign a value when the source you are producing values from changes / emits a new value. For sample usage see the produceState documentation.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ProduceStateDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Runtime.INSTANCE.getProduceState().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (PsiUtilsKt.isInPackageName(method, Names.Runtime.INSTANCE.getPackageName())) {
            Object v1;
            block4: {
                Iterable iterable = node.getValueArguments();
                for (Object t : iterable) {
                    UExpression it = (UExpression)t;
                    boolean bl = false;
                    PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                    if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"producer")) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            UExpression uExpression = v1;
            if (uExpression == null) {
                return;
            }
            UExpression producer = uExpression;
            Ref.BooleanRef referencesReceiver = new Ref.BooleanRef();
            Ref.BooleanRef callsSetValue = new Ref.BooleanRef();
            producer.accept((UastVisitor)new AbstractUastVisitor(context, referencesReceiver, callsSetValue){
                @Nullable
                private final PsiClass mutableStatePsiClass;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.BooleanRef $referencesReceiver;
                final /* synthetic */ Ref.BooleanRef $callsSetValue;
                {
                    this.$context = $context;
                    this.$referencesReceiver = $referencesReceiver;
                    this.$callsSetValue = $callsSetValue;
                    this.mutableStatePsiClass = $context.getEvaluator().findClass(Names.Runtime.INSTANCE.getMutableState().getJavaFqn());
                }

                @Nullable
                public final PsiClass getMutableStatePsiClass() {
                    return this.mutableStatePsiClass;
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    boolean bl;
                    block4: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PsiMethod psiMethod = node.resolve();
                        if (psiMethod == null) {
                            return this.$referencesReceiver.element;
                        }
                        PsiMethod resolvedMethod = psiMethod;
                        PsiParameter[] psiParameterArray = resolvedMethod.getParameterList().getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"resolvedMethod.parameterList.parameters");
                        Object[] objectArray = psiParameterArray;
                        Ref.BooleanRef booleanRef = this.$referencesReceiver;
                        JavaContext javaContext = this.$context;
                        boolean $i$f$any = false;
                        for (void element$iv : $this$any$iv) {
                            PsiType type;
                            PsiParameter parameter = (PsiParameter)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)parameter.getType(), (String)"parameter.type");
                            if (PsiUtilsKt.inheritsFrom(type, ProduceStateDetectorKt.access$getProduceStateScopeName$p())) {
                                booleanRef.element = true;
                            }
                            if (this.mutableStatePsiClass != null && Intrinsics.areEqual((Object)javaContext.getEvaluator().getTypeClass(type), (Object)this.mutableStatePsiClass)) {
                                booleanRef.element = true;
                            }
                            if (!booleanRef.element) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                    return bl;
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    boolean bl;
                    block8: {
                        Object resolvedMethods;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!(node.getOperator() instanceof UastBinaryOperator.AssignOperator)) {
                            return this.$callsSetValue.element;
                        }
                        USimpleNameReferenceExpression uSimpleNameReferenceExpression = this.rightMostNameReference(node.getLeftOperand());
                        if (!Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null), (Object)"value")) {
                            return this.$callsSetValue.element;
                        }
                        Object object = node instanceof UMultiResolvable ? (UMultiResolvable)node : null;
                        if (object == null || (object = object.multiResolve()) == null) {
                            return this.$callsSetValue.element;
                        }
                        Object $this$any$iv = resolvedMethods = object;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv = iterator.next();
                                ResolveResult it = (ResolveResult)element$iv;
                                boolean bl2 = false;
                                PsiElement psiElement = it.getElement();
                                if (!this.isValueAccessorFromMutableState(psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.$callsSetValue.element = true;
                        return true;
                    }
                    PsiElement resolvedOperand = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
                    if (this.isValueAccessorFromMutableState(resolvedOperand instanceof PsiMethod ? (PsiMethod)resolvedOperand : null)) {
                        this.$callsSetValue.element = true;
                    }
                    return this.$callsSetValue.element;
                }

                private final USimpleNameReferenceExpression rightMostNameReference(UExpression $this$rightMostNameReference) {
                    USimpleNameReferenceExpression uSimpleNameReferenceExpression;
                    block2: {
                        while (true) {
                            UExpression uExpression;
                            if ((uExpression = $this$rightMostNameReference) instanceof USimpleNameReferenceExpression) {
                                uSimpleNameReferenceExpression = (USimpleNameReferenceExpression)$this$rightMostNameReference;
                                break block2;
                            }
                            if (!(uExpression instanceof UQualifiedReferenceExpression)) break;
                            visitMethodCall.1 var3_3 = this_;
                            UExpression uExpression2 = ((UQualifiedReferenceExpression)$this$rightMostNameReference).getSelector();
                            visitMethodCall.1 this_ = var3_3;
                            $this$rightMostNameReference = uExpression2;
                        }
                        uSimpleNameReferenceExpression = null;
                    }
                    return uSimpleNameReferenceExpression;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private final boolean isValueAccessorFromMutableState(PsiMethod $this$isValueAccessorFromMutableState) {
                    if ($this$isValueAccessorFromMutableState == null) return false;
                    if (!Intrinsics.areEqual((Object)$this$isValueAccessorFromMutableState.getName(), (Object)"setValue")) {
                        if (!Intrinsics.areEqual((Object)$this$isValueAccessorFromMutableState.getName(), (Object)"getValue")) return false;
                    }
                    PsiClass psiClass = $this$isValueAccessorFromMutableState.getContainingClass();
                    if (psiClass == null) return false;
                    if (!PsiUtilsKt.inheritsFrom(psiClass, Names.Runtime.INSTANCE.getMutableState())) return false;
                    return true;
                }
            });
            if (!callsSetValue.element && !referencesReceiver.element) {
                JavaContext.report$default((JavaContext)context, (Issue)ProduceStateDoesNotAssignValue, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"produceState calls should assign `value` inside the producer lambda", null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/ProduceStateDetector$Companion;", "", "()V", "ProduceStateDoesNotAssignValue", "Lcom/android/tools/lint/detector/api/Issue;", "getProduceStateDoesNotAssignValue", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getProduceStateDoesNotAssignValue() {
            return ProduceStateDoesNotAssignValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

