/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.WeakReference;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\"J\r\u0010#\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190(H\u0086\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00120\u0011X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotWeakSet;", "T", "", "()V", "hashes", "", "getHashes$runtime_release", "()[I", "setHashes$runtime_release", "([I)V", "size", "", "getSize$runtime_release", "()I", "setSize$runtime_release", "(I)V", "values", "", "Landroidx/compose/runtime/WeakReference;", "getValues$runtime_release", "()[Landroidx/compose/runtime/WeakReference;", "setValues$runtime_release", "([Landroidx/compose/runtime/WeakReference;)V", "[Landroidx/compose/runtime/WeakReference;", "add", "", "value", "(Ljava/lang/Object;)Z", "find", "hash", "(Ljava/lang/Object;I)I", "findExactIndex", "midIndex", "valueHash", "(ILjava/lang/Object;I)I", "isValid", "isValid$runtime_release", "removeIf", "", "block", "Lkotlin/Function1;", "runtime_release"})
@StabilityInferred(parameters=0)
public final class SnapshotWeakSet<T> {
    private int size;
    @NotNull
    private int[] hashes = new int[16];
    @NotNull
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime_release() {
        return this.size;
    }

    public final void setSize$runtime_release(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getHashes$runtime_release() {
        return this.hashes;
    }

    public final void setHashes$runtime_release(@NotNull int[] nArray) {
        this.hashes = nArray;
    }

    @NotNull
    public final WeakReference<T>[] getValues$runtime_release() {
        return this.values;
    }

    public final void setValues$runtime_release(@NotNull WeakReference<T>[] weakReferenceArray) {
        this.values = weakReferenceArray;
    }

    public final boolean add(@NotNull T value) {
        int index = 0;
        int size = this.size;
        int hash = ActualJvm_jvmKt.identityHashCode(value);
        if (size > 0) {
            index = this.find(value, hash);
            if (index >= 0) {
                return false;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        int capacity = this.values.length;
        if (size == capacity) {
            int newCapacity = capacity * 2;
            Object[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            ArraysKt.copyInto((Object[])this.values, (Object[])newValues, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((Object[])this.values, (Object[])newValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            ArraysKt.copyInto((int[])this.hashes, (int[])newHashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((int[])this.hashes, (int[])newHashes, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            ArraysKt.copyInto((Object[])this.values, (Object[])this.values, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
        }
        this.values[insertIndex] = new WeakReference<T>(value);
        this.hashes[insertIndex] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final void removeIf(@NotNull Function1<? super T, Boolean> block) {
        int i;
        boolean $i$f$removeIf = false;
        int size = this.getSize$runtime_release();
        int currentUsed = 0;
        for (i = 0; i < size; ++i) {
            Object value;
            WeakReference<T> entry;
            WeakReference<T> weakReference = entry = this.getValues$runtime_release()[i];
            Object object = value = weakReference != null ? weakReference.get() : null;
            if (value == null || ((Boolean)block.invoke(value)).booleanValue()) continue;
            if (currentUsed != i) {
                this.getValues$runtime_release()[currentUsed] = entry;
                this.getHashes$runtime_release()[currentUsed] = this.getHashes$runtime_release()[i];
            }
            ++currentUsed;
        }
        for (i = currentUsed; i < size; ++i) {
            this.getValues$runtime_release()[i] = null;
            this.getHashes$runtime_release()[i] = 0;
        }
        if (currentUsed != size) {
            this.setSize$runtime_release(currentUsed);
        }
    }

    private final int find(T value, int hash) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value == midVal) {
                return mid;
            }
            return this.findExactIndex(mid, value, hash);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, T value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i && this.hashes[i] == valueHash; --i) {
            Object v;
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v;
            if (this.hashes[i] != valueHash) {
                return -(i + 1);
            }
            WeakReference<T> weakReference = this.values[i];
            Object object = v = weakReference != null ? weakReference.get() : null;
            if (v != value) continue;
            return i;
        }
        return -(this.size + 1);
    }

    @TestOnly
    public final boolean isValid$runtime_release() {
        int i;
        int size = this.size;
        WeakReference<T>[] values2 = this.values;
        int[] hashes = this.hashes;
        int capacity = values2.length;
        if (size > capacity) {
            return false;
        }
        int previous = Integer.MIN_VALUE;
        for (i = 0; i < size; ++i) {
            WeakReference<T> entry;
            int hash = hashes[i];
            if (hash < previous) {
                return false;
            }
            if (values2[i] == null) {
                return false;
            }
            Object value = entry.get();
            if (value != null && hash != ActualJvm_jvmKt.identityHashCode(value)) {
                return false;
            }
            previous = hash;
        }
        for (i = size; i < capacity; ++i) {
            if (hashes[i] != 0) {
                return false;
            }
            if (values2[i] == null) continue;
            return false;
        }
        return true;
    }
}

