/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableSet.TrieNodeKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u000e\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016J1\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetMutableIterator;", "E", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetIterator;", "", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;)V", "expectedModCount", "", "lastIteratedElement", "Ljava/lang/Object;", "nextWasInvoked", "", "checkForComodification", "", "checkNextWasInvoked", "isCollision", "node", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "next", "()Ljava/lang/Object;", "remove", "resetPath", "hashCode", "element", "pathIndex", "(ILandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableSet/TrieNode;Ljava/lang/Object;I)V", "runtime_release"})
public final class PersistentHashSetMutableIterator<E>
extends PersistentHashSetIterator<E>
implements Iterator<E>,
KMutableIterator {
    @NotNull
    private final PersistentHashSetBuilder<E> builder;
    @Nullable
    private E lastIteratedElement;
    private boolean nextWasInvoked;
    private int expectedModCount;

    public PersistentHashSetMutableIterator(@NotNull PersistentHashSetBuilder<E> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super(builder.getNode$runtime_release());
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$runtime_release();
    }

    @Override
    public E next() {
        this.checkForComodification();
        Object next2 = super.next();
        this.lastIteratedElement = next2;
        this.nextWasInvoked = true;
        return next2;
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentElement = this.currentElement();
            Collection collection = this.builder;
            E e = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e);
            Object e2 = currentElement;
            this.resetPath(e2 != null ? e2.hashCode() : 0, this.builder.getNode$runtime_release(), currentElement, 0);
        } else {
            Collection collection = this.builder;
            E e = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e);
        }
        this.lastIteratedElement = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$runtime_release();
    }

    private final void resetPath(int hashCode, TrieNode<?> node, E element, int pathIndex) {
        if (this.isCollision(node)) {
            int index = ArraysKt.indexOf((Object[])node.getBuffer(), element);
            CommonFunctionsKt.assert(index != -1);
            this.getPath().get(pathIndex).reset(node.getBuffer(), index);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int position = 1 << TrieNodeKt.indexSegment(hashCode, pathIndex * 5);
        int index = node.indexOfCellAt$runtime_release(position);
        this.getPath().get(pathIndex).reset(node.getBuffer(), index);
        Object cell = node.getBuffer()[index];
        if (cell instanceof TrieNode) {
            this.resetPath(hashCode, (TrieNode)cell, element, pathIndex + 1);
        } else {
            this.setPathLastIndex(pathIndex);
        }
    }

    private final boolean isCollision(TrieNode<?> node) {
        return node.getBitmap() == 0;
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$runtime_release() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

