/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u0005H\u0002JD\u0010\u001c\u001a\u00020\u001326\u0010\u001d\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00130\u001eH\u0086\b\u00f8\u0001\u0000J\u0018\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u0015J\u0006\u0010%\u001a\u00020\u0015J\u0015\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#JD\u0010'\u001a\u00020\u001326\u0010\u001d\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00150\u001eH\u0086\b\u00f8\u0001\u0000J/\u0010(\u001a\u00020\u00132!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00150)H\u0086\b\u00f8\u0001\u0000J\u001e\u0010*\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010+R0\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR0\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0011\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"Landroidx/compose/runtime/collection/IdentityArrayMap;", "Key", "", "Value", "capacity", "", "(I)V", "<set-?>", "", "keys", "getKeys", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "size", "getSize", "()I", "values", "getValues", "clear", "", "contains", "", "key", "(Ljava/lang/Object;)Z", "find", "findExactIndex", "midIndex", "keyHash", "forEach", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "isNotEmpty", "remove", "removeIf", "removeValueIf", "Lkotlin/Function1;", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "runtime_release"})
@SourceDebugExtension(value={"SMAP\nIdentityArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityArrayMap.kt\nandroidx/compose/runtime/collection/IdentityArrayMap\n*L\n1#1,219:1\n125#1,22:220\n*S KotlinDebug\n*F\n+ 1 IdentityArrayMap.kt\nandroidx/compose/runtime/collection/IdentityArrayMap\n*L\n149#1:220,22\n*E\n"})
public final class IdentityArrayMap<Key, Value> {
    @NotNull
    private Object[] keys;
    @NotNull
    private Object[] values;
    private int size;

    public IdentityArrayMap(int capacity) {
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    public /* synthetic */ IdentityArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    @NotNull
    public final Object[] getKeys() {
        return this.keys;
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    public final boolean contains(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.find(key) >= 0;
    }

    @Nullable
    public final Value get(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        return (Value)(index >= 0 ? this.values[index] : null);
    }

    public final void set(@NotNull Key key, Value value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object[] keys = this.keys;
        Object[] values = this.values;
        int size = this.size;
        int index = this.find(key);
        if (index >= 0) {
            values[index] = value;
        } else {
            int insertIndex = -(index + 1);
            boolean resize = size == keys.length;
            Object[] destKeys = resize ? new Object[size * 2] : keys;
            ArraysKt.copyInto((Object[])keys, (Object[])destKeys, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            if (resize) {
                ArraysKt.copyInto$default((Object[])keys, (Object[])destKeys, (int)0, (int)0, (int)insertIndex, (int)6, null);
            }
            destKeys[insertIndex] = key;
            this.keys = destKeys;
            Object[] destValues = resize ? new Object[size * 2] : values;
            ArraysKt.copyInto((Object[])values, (Object[])destValues, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            if (resize) {
                ArraysKt.copyInto$default((Object[])values, (Object[])destValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            }
            destValues[insertIndex] = value;
            this.values = destValues;
            int n = this.size;
            this.size = n + 1;
        }
    }

    @Nullable
    public final Value remove(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            Object value = this.values[index];
            int size = this.size;
            Object[] keys = this.keys;
            Object[] values = this.values;
            ArraysKt.copyInto((Object[])keys, (Object[])keys, (int)index, (int)(index + 1), (int)size);
            ArraysKt.copyInto((Object[])values, (Object[])values, (int)index, (int)(index + 1), (int)size);
            int newSize = size - 1;
            keys[newSize] = null;
            values[newSize] = null;
            this.size = newSize;
            return (Value)value;
        }
        return null;
    }

    public final void clear() {
        this.size = 0;
        ArraysKt.fill$default((Object[])this.keys, null, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.values, null, (int)0, (int)0, (int)6, null);
    }

    public final void removeIf(@NotNull Function2<? super Key, ? super Value, Boolean> block) {
        int index;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$removeIf = false;
        int current = 0;
        int n = this.getSize();
        for (index = 0; index < n; ++index) {
            Object key;
            Intrinsics.checkNotNull((Object)this.getKeys()[index], (String)"null cannot be cast to non-null type Key of androidx.compose.runtime.collection.IdentityArrayMap");
            Object value = this.getValues()[index];
            if (((Boolean)block.invoke(key, value)).booleanValue()) continue;
            if (current != index) {
                this.getKeys()[current] = key;
                this.getValues()[current] = this.getValues()[index];
            }
            ++current;
        }
        if (this.getSize() > current) {
            n = this.getSize();
            for (index = current; index < n; ++index) {
                this.getKeys()[index] = null;
                this.getValues()[index] = null;
            }
            this.size = current;
        }
    }

    public final void removeValueIf(@NotNull Function1<? super Value, Boolean> block) {
        int index$iv;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$removeValueIf = false;
        IdentityArrayMap this_$iv = this;
        boolean $i$f$removeIf = false;
        int current$iv = 0;
        int n = this_$iv.getSize();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            Object value$iv;
            Intrinsics.checkNotNull((Object)this_$iv.getKeys()[index$iv], (String)"null cannot be cast to non-null type Key of androidx.compose.runtime.collection.IdentityArrayMap");
            Object value = value$iv = this_$iv.getValues()[index$iv];
            boolean bl = false;
            if (((Boolean)block.invoke(value)).booleanValue()) continue;
            if (current$iv != index$iv) {
                Object key$iv;
                this_$iv.getKeys()[current$iv] = key$iv;
                this_$iv.getValues()[current$iv] = this_$iv.getValues()[index$iv];
            }
            ++current$iv;
        }
        if (this_$iv.getSize() > current$iv) {
            n = this_$iv.getSize();
            for (index$iv = current$iv; index$iv < n; ++index$iv) {
                this_$iv.getKeys()[index$iv] = null;
                this_$iv.getValues()[index$iv] = null;
            }
            this_$iv.size = current$iv;
        }
    }

    public final void forEach(@NotNull Function2<? super Key, ? super Value, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        int n = this.getSize();
        for (int index = 0; index < n; ++index) {
            Object object = this.getKeys()[index];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type Key of androidx.compose.runtime.collection.IdentityArrayMap");
            block.invoke(object, this.getValues()[index]);
        }
    }

    private final int find(Object key) {
        int keyIdentity = ActualJvm_jvmKt.identityHashCode(key);
        int low = 0;
        int high = this.size - 1;
        Object[] keys = this.keys;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midKey = keys[mid];
            int midKeyHash = ActualJvm_jvmKt.identityHashCode(midKey);
            if (midKeyHash < keyIdentity) {
                low = mid + 1;
                continue;
            }
            if (midKeyHash > keyIdentity) {
                high = mid - 1;
                continue;
            }
            if (key == midKey) {
                return mid;
            }
            return this.findExactIndex(mid, key, keyIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object key, int keyHash) {
        Object k;
        int i;
        Object[] keys = this.keys;
        int size = this.size;
        for (i = midIndex - 1; -1 < i; --i) {
            k = keys[i];
            if (k == key) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(k) != keyHash) break;
        }
        for (i = midIndex + 1; i < size; ++i) {
            k = keys[i];
            if (k == key) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(k) == keyHash) continue;
            return -(i + 1);
        }
        return -(size + 1);
    }

    public IdentityArrayMap() {
        this(0, 1, null);
    }
}

