/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.material3.carousel.Arrangement;
import androidx.compose.material3.carousel.CarouselAlignment;
import androidx.compose.material3.carousel.CarouselDefaults;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001aD\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0001H\u0000\u001a(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\u0017"}, d2={"calculateMediumChildSize", "", "minimumMediumSize", "largeItemSize", "remainingSpace", "createLeftAlignedKeylineList", "Landroidx/compose/material3/carousel/KeylineList;", "carouselMainAxisSize", "itemSpacing", "leftAnchorSize", "rightAnchorSize", "arrangement", "Landroidx/compose/material3/carousel/Arrangement;", "multiBrowseKeylineList", "density", "Landroidx/compose/ui/unit/Density;", "preferredItemSize", "itemCount", "", "minSmallItemSize", "maxSmallItemSize", "uncontainedKeylineList", "itemSize", "material3_release"})
@SourceDebugExtension(value={"SMAP\nKeylines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keylines.kt\nandroidx/compose/material3/carousel/KeylinesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class KeylinesKt {
    @NotNull
    public static final KeylineList multiBrowseKeylineList(@NotNull Density density, float carouselMainAxisSize, float preferredItemSize, float itemSpacing, int itemCount, float minSmallItemSize, float maxSmallItemSize) {
        if (carouselMainAxisSize == 0.0f || preferredItemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        int[] nArray = new int[]{1};
        int[] smallCounts = nArray;
        int[] nArray2 = new int[]{1, 0};
        int[] mediumCounts = nArray2;
        float targetLargeSize = Math.min(preferredItemSize, carouselMainAxisSize);
        float targetSmallSize = RangesKt.coerceIn((float)(targetLargeSize / 3.0f), (float)minSmallItemSize, (float)maxSmallItemSize);
        float targetMediumSize = (targetLargeSize + targetSmallSize) / 2.0f;
        if (carouselMainAxisSize < minSmallItemSize * (float)2) {
            int[] nArray3 = new int[]{0};
            smallCounts = nArray3;
        }
        float minAvailableLargeSpace = carouselMainAxisSize - targetMediumSize * (float)ArraysKt.maxOrThrow((int[])mediumCounts) - maxSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts);
        int minLargeCount = Math.max(1, (int)Math.floor(minAvailableLargeSpace / targetLargeSize));
        int maxLargeCount = (int)Math.ceil(carouselMainAxisSize / targetLargeSize);
        int n = 0;
        int n2 = maxLargeCount - minLargeCount + 1;
        int[] nArray4 = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray4[n3] = maxLargeCount - n3;
        }
        int[] largeCounts = nArray4;
        Density $this$multiBrowseKeylineList_u24lambda_u242 = density;
        boolean bl = false;
        float anchorSize = $this$multiBrowseKeylineList_u24lambda_u242.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3_release());
        Arrangement arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, smallCounts, targetMediumSize, mediumCounts, targetLargeSize, largeCounts);
        if (arrangement != null && arrangement.itemCount() > itemCount) {
            int smallCount = arrangement.getSmallCount();
            int mediumCount = arrangement.getMediumCount();
            for (int keylineSurplus = arrangement.itemCount() - itemCount; keylineSurplus > 0; --keylineSurplus) {
                if (smallCount > 0) {
                    --smallCount;
                    continue;
                }
                if (mediumCount <= 1) continue;
                --mediumCount;
            }
            int[] nArray5 = new int[]{smallCount};
            int[] nArray6 = nArray5;
            nArray5 = new int[]{mediumCount};
            arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, nArray6, targetMediumSize, nArray5, targetLargeSize, largeCounts);
        }
        if (arrangement == null) {
            return KeylineListKt.emptyKeylineList();
        }
        return KeylinesKt.createLeftAlignedKeylineList(carouselMainAxisSize, itemSpacing, anchorSize, anchorSize, arrangement);
    }

    public static /* synthetic */ KeylineList multiBrowseKeylineList$default(Density density, float f, float f2, float f3, int n, float f4, float f5, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            Density $this$multiBrowseKeylineList_u24lambda_u240 = density;
            boolean bl = false;
            f4 = $this$multiBrowseKeylineList_u24lambda_u240.toPx-0680j_4(CarouselDefaults.INSTANCE.getMinSmallItemSize-D9Ej5fM$material3_release());
        }
        if ((n2 & 0x40) != 0) {
            Density $this$multiBrowseKeylineList_u24lambda_u241 = density;
            boolean bl = false;
            f5 = $this$multiBrowseKeylineList_u24lambda_u241.toPx-0680j_4(CarouselDefaults.INSTANCE.getMaxSmallItemSize-D9Ej5fM$material3_release());
        }
        return KeylinesKt.multiBrowseKeylineList(density, f, f2, f3, n, f4, f5);
    }

    @NotNull
    public static final KeylineList createLeftAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, @NotNull Arrangement arrangement) {
        return KeylineListKt.keylineListOf-WNYm7Xg(carouselMainAxisSize, itemSpacing, CarouselAlignment.Companion.getStart-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(leftAnchorSize, arrangement, rightAnchorSize){
            final /* synthetic */ float $leftAnchorSize;
            final /* synthetic */ Arrangement $arrangement;
            final /* synthetic */ float $rightAnchorSize;
            {
                this.$leftAnchorSize = $leftAnchorSize;
                this.$arrangement = $arrangement;
                this.$rightAnchorSize = $rightAnchorSize;
                super(1);
            }

            public final void invoke(@NotNull KeylineListScope $this$keylineListOf) {
                int it;
                $this$keylineListOf.add(this.$leftAnchorSize, true);
                int n = this.$arrangement.getLargeCount();
                Arrangement arrangement = this.$arrangement;
                int n2 = 0;
                while (n2 < n) {
                    it = n2++;
                    boolean bl = false;
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getLargeSize(), false, 2, null);
                }
                n = this.$arrangement.getMediumCount();
                arrangement = this.$arrangement;
                n2 = 0;
                while (n2 < n) {
                    it = n2++;
                    boolean bl = false;
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getMediumSize(), false, 2, null);
                }
                n = this.$arrangement.getSmallCount();
                arrangement = this.$arrangement;
                n2 = 0;
                while (n2 < n) {
                    it = n2++;
                    boolean bl = false;
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getSmallSize(), false, 2, null);
                }
                $this$keylineListOf.add(this.$rightAnchorSize, true);
            }
        }));
    }

    @NotNull
    public static final KeylineList uncontainedKeylineList(@NotNull Density density, float carouselMainAxisSize, float itemSize, float itemSpacing) {
        if (carouselMainAxisSize == 0.0f || itemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        float largeItemSize = Math.min(itemSize + itemSpacing, carouselMainAxisSize);
        int largeCount = Math.max(1, (int)Math.floor(carouselMainAxisSize / largeItemSize));
        float remainingSpace = carouselMainAxisSize - (float)largeCount * largeItemSize;
        int mediumCount = remainingSpace > 0.0f ? 1 : 0;
        Density $this$uncontainedKeylineList_u24lambda_u243 = density;
        boolean bl = false;
        float defaultAnchorSize = $this$uncontainedKeylineList_u24lambda_u243.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3_release());
        float mediumItemSize = KeylinesKt.calculateMediumChildSize(defaultAnchorSize, largeItemSize, remainingSpace);
        Arrangement arrangement = new Arrangement(0, 0.0f, 0, mediumItemSize, mediumCount, largeItemSize, largeCount);
        float xSmallSize = Math.min(defaultAnchorSize, itemSize);
        float leftAnchorSize = Math.max(xSmallSize, mediumItemSize * 0.5f);
        return KeylinesKt.createLeftAlignedKeylineList(carouselMainAxisSize, itemSpacing, leftAnchorSize, defaultAnchorSize, arrangement);
    }

    private static final float calculateMediumChildSize(float minimumMediumSize, float largeItemSize, float remainingSpace) {
        float largeItemThreshold;
        float mediumItemSize = minimumMediumSize;
        float sizeWithThirdCutOff = remainingSpace * 1.5f;
        if ((mediumItemSize = Math.max(sizeWithThirdCutOff, mediumItemSize)) > (largeItemThreshold = largeItemSize * 0.85f)) {
            float sizeWithFifthCutOff = remainingSpace * 1.2f;
            mediumItemSize = Math.max(largeItemThreshold, sizeWithFifthCutOff);
        }
        return mediumItemSize;
    }
}

