/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.ripple;

import android.content.Context;
import android.view.ViewGroup;
import androidx.compose.material.ripple.AndroidRippleIndicationInstance;
import androidx.compose.material.ripple.RippleHostMap;
import androidx.compose.material.ripple.RippleHostView;
import androidx.compose.ui.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0014J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0014J\n\u0010\u0019\u001a\u00020\u000f*\u00020\u001aJ\n\u0010\u001b\u001a\u00020\f*\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/material/ripple/RippleContainer;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "MaxRippleHosts", "", "nextHostIndex", "rippleHostMap", "Landroidx/compose/material/ripple/RippleHostMap;", "rippleHosts", "", "Landroidx/compose/material/ripple/RippleHostView;", "unusedRippleHosts", "onLayout", "", "changed", "", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "disposeRippleIfNeeded", "Landroidx/compose/material/ripple/AndroidRippleIndicationInstance;", "getRippleHostView", "material-ripple_release"})
@SourceDebugExtension(value={"SMAP\nRippleContainer.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RippleContainer.android.kt\nandroidx/compose/material/ripple/RippleContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class RippleContainer
extends ViewGroup {
    private final int MaxRippleHosts;
    @NotNull
    private final List<RippleHostView> rippleHosts;
    @NotNull
    private final List<RippleHostView> unusedRippleHosts;
    @NotNull
    private final RippleHostMap rippleHostMap;
    private int nextHostIndex;

    public RippleContainer(@NotNull Context context) {
        RippleHostView rippleHostView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.MaxRippleHosts = 5;
        this.rippleHosts = new ArrayList();
        this.unusedRippleHosts = new ArrayList();
        this.rippleHostMap = new RippleHostMap();
        this.setClipChildren(false);
        RippleHostView it = rippleHostView = new RippleHostView(context);
        boolean bl = false;
        this.addView(it);
        RippleHostView initialHostView = rippleHostView;
        this.rippleHosts.add(initialHostView);
        this.unusedRippleHosts.add(initialHostView);
        this.nextHostIndex = 1;
        this.setTag(R.id.hide_in_inspector_tag, true);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @NotNull
    public final RippleHostView getRippleHostView(@NotNull AndroidRippleIndicationInstance $this$getRippleHostView) {
        Intrinsics.checkNotNullParameter((Object)$this$getRippleHostView, (String)"<this>");
        RippleHostView existingRippleHostView = this.rippleHostMap.get($this$getRippleHostView);
        if (existingRippleHostView != null) {
            return existingRippleHostView;
        }
        RippleHostView rippleHostView = (RippleHostView)((Object)CollectionsKt.removeFirstOrNull(this.unusedRippleHosts));
        if (rippleHostView == null) {
            RippleHostView rippleHostView2;
            if (this.nextHostIndex > CollectionsKt.getLastIndex(this.rippleHosts)) {
                RippleHostView rippleHostView3;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                RippleHostView it = rippleHostView3 = new RippleHostView(context);
                boolean bl = false;
                this.addView(it);
                ((Collection)this.rippleHosts).add(it);
                rippleHostView2 = rippleHostView3;
            } else {
                RippleHostView host = this.rippleHosts.get(this.nextHostIndex);
                AndroidRippleIndicationInstance existingInstance = this.rippleHostMap.get(host);
                if (existingInstance != null) {
                    existingInstance.resetHostView();
                    this.rippleHostMap.remove(existingInstance);
                    host.disposeRipple();
                }
                rippleHostView2 = rippleHostView = host;
            }
            if (this.nextHostIndex < this.MaxRippleHosts - 1) {
                int n = this.nextHostIndex;
                this.nextHostIndex = n + 1;
            } else {
                this.nextHostIndex = 0;
            }
        }
        this.rippleHostMap.set($this$getRippleHostView, rippleHostView);
        return rippleHostView;
    }

    public final void disposeRippleIfNeeded(@NotNull AndroidRippleIndicationInstance $this$disposeRippleIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$disposeRippleIfNeeded, (String)"<this>");
        $this$disposeRippleIfNeeded.resetHostView();
        RippleHostView rippleHost = this.rippleHostMap.get($this$disposeRippleIfNeeded);
        if (rippleHost != null) {
            rippleHost.disposeRipple();
            this.rippleHostMap.remove($this$disposeRippleIfNeeded);
            this.unusedRippleHosts.add(rippleHost);
        }
    }
}

