/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.RocketLaunch: ImageVector
    get() {
        if (_rocketLaunch != null) {
            return _rocketLaunch!!
        }
        _rocketLaunch = materialIcon(name = "TwoTone.RocketLaunch") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.71f, 18.71f)
                curveToRelative(-0.28f, 0.28f, -2.17f, 0.76f, -2.17f, 0.76f)
                reflectiveCurveToRelative(0.47f, -1.88f, 0.76f, -2.17f)
                curveTo(5.47f, 17.11f, 5.72f, 17.0f, 6.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(7.0f, 18.28f, 6.89f, 18.53f, 6.71f, 18.71f)
                close()
                moveTo(7.41f, 10.83f)
                lineTo(5.5f, 10.01f)
                lineToRelative(1.97f, -1.97f)
                lineToRelative(1.44f, 0.29f)
                curveTo(8.34f, 9.16f, 7.83f, 10.03f, 7.41f, 10.83f)
                close()
                moveTo(13.99f, 18.5f)
                lineToRelative(-0.82f, -1.91f)
                curveToRelative(0.8f, -0.42f, 1.67f, -0.93f, 2.49f, -1.5f)
                lineToRelative(0.29f, 1.44f)
                lineTo(13.99f, 18.5f)
                close()
                moveTo(19.99f, 4.01f)
                curveToRelative(0.0f, 0.0f, -3.55f, -0.69f, -8.23f, 3.99f)
                curveToRelative(-1.32f, 1.32f, -2.4f, 3.38f, -2.73f, 4.04f)
                lineToRelative(2.93f, 2.93f)
                curveToRelative(0.65f, -0.32f, 2.71f, -1.4f, 4.04f, -2.73f)
                curveTo(20.68f, 7.56f, 19.99f, 4.01f, 19.99f, 4.01f)
                close()
                moveTo(15.0f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(17.0f, 10.1f, 16.1f, 11.0f, 15.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 15.0f)
                curveToRelative(-0.83f, 0.0f, -1.58f, 0.34f, -2.12f, 0.88f)
                curveTo(2.7f, 17.06f, 2.0f, 22.0f, 2.0f, 22.0f)
                reflectiveCurveToRelative(4.94f, -0.7f, 6.12f, -1.88f)
                curveTo(8.66f, 19.58f, 9.0f, 18.83f, 9.0f, 18.0f)
                curveTo(9.0f, 16.34f, 7.66f, 15.0f, 6.0f, 15.0f)
                close()
                moveTo(6.71f, 18.71f)
                curveToRelative(-0.28f, 0.28f, -2.17f, 0.76f, -2.17f, 0.76f)
                reflectiveCurveToRelative(0.47f, -1.88f, 0.76f, -2.17f)
                curveTo(5.47f, 17.11f, 5.72f, 17.0f, 6.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(7.0f, 18.28f, 6.89f, 18.53f, 6.71f, 18.71f)
                close()
                moveTo(17.42f, 13.65f)
                lineTo(17.42f, 13.65f)
                curveToRelative(6.36f, -6.36f, 4.24f, -11.31f, 4.24f, -11.31f)
                reflectiveCurveToRelative(-4.95f, -2.12f, -11.31f, 4.24f)
                lineToRelative(-2.49f, -0.5f)
                curveTo(7.21f, 5.95f, 6.53f, 6.16f, 6.05f, 6.63f)
                lineTo(2.0f, 10.69f)
                lineToRelative(5.0f, 2.14f)
                lineTo(11.17f, 17.0f)
                lineToRelative(2.14f, 5.0f)
                lineToRelative(4.05f, -4.05f)
                curveToRelative(0.47f, -0.47f, 0.68f, -1.15f, 0.55f, -1.81f)
                lineTo(17.42f, 13.65f)
                close()
                moveTo(7.41f, 10.83f)
                lineTo(5.5f, 10.01f)
                lineToRelative(1.97f, -1.97f)
                lineToRelative(1.44f, 0.29f)
                curveTo(8.34f, 9.16f, 7.83f, 10.03f, 7.41f, 10.83f)
                close()
                moveTo(13.99f, 18.5f)
                lineToRelative(-0.82f, -1.91f)
                curveToRelative(0.8f, -0.42f, 1.67f, -0.93f, 2.49f, -1.5f)
                lineToRelative(0.29f, 1.44f)
                lineTo(13.99f, 18.5f)
                close()
                moveTo(16.0f, 12.24f)
                curveToRelative(-1.32f, 1.32f, -3.38f, 2.4f, -4.04f, 2.73f)
                lineToRelative(-2.93f, -2.93f)
                curveToRelative(0.32f, -0.65f, 1.4f, -2.71f, 2.73f, -4.04f)
                curveToRelative(4.68f, -4.68f, 8.23f, -3.99f, 8.23f, -3.99f)
                reflectiveCurveTo(20.68f, 7.56f, 16.0f, 12.24f)
                close()
                moveTo(15.0f, 11.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(13.9f, 11.0f, 15.0f, 11.0f)
                close()
            }
        }
        return _rocketLaunch!!
    }

private var _rocketLaunch: ImageVector? = null
