/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Park: ImageVector
    get() {
        if (_park != null) {
            return _park!!
        }
        _park = materialIcon(name = "TwoTone.Park") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.26f, 10.0f)
                lineToRelative(1.9f, 0.0f)
                lineToRelative(-3.15f, -4.5f)
                lineToRelative(-3.13f, 4.5f)
                lineToRelative(1.81f, 0.0f)
                lineToRelative(-3.9f, 6.0f)
                lineToRelative(10.47f, 0.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 12.0f)
                horizontalLineToRelative(2.0f)
                lineTo(12.0f, 2.0f)
                lineTo(5.05f, 12.0f)
                horizontalLineTo(7.0f)
                lineToRelative(-3.9f, 6.0f)
                horizontalLineToRelative(6.92f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(3.95f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(21.0f)
                lineTo(17.0f, 12.0f)
                close()
                moveTo(6.79f, 16.0f)
                lineToRelative(3.9f, -6.0f)
                horizontalLineTo(8.88f)
                lineToRelative(3.13f, -4.5f)
                lineToRelative(3.15f, 4.5f)
                horizontalLineToRelative(-1.9f)
                lineToRelative(4.0f, 6.0f)
                horizontalLineTo(6.79f)
                close()
            }
        }
        return _park!!
    }

private var _park: ImageVector? = null
