/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Mode: ImageVector
    get() {
        if (_mode != null) {
            return _mode!!
        }
        _mode = materialIcon(name = "TwoTone.Mode") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.06f, 9.02f)
                lineTo(5.0f, 18.08f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(0.92f)
                lineToRelative(9.06f, -9.06f)
                close()
            }
            materialPath {
                moveTo(18.37f, 3.29f)
                curveToRelative(-0.2f, -0.2f, -0.45f, -0.29f, -0.71f, -0.29f)
                reflectiveCurveToRelative(-0.51f, 0.1f, -0.7f, 0.29f)
                lineToRelative(-1.83f, 1.83f)
                lineToRelative(3.75f, 3.75f)
                lineToRelative(1.83f, -1.83f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.34f, -2.34f)
                close()
                moveTo(17.81f, 9.94f)
                lineToRelative(-3.75f, -3.75f)
                lineTo(3.0f, 17.25f)
                lineTo(3.0f, 21.0f)
                horizontalLineToRelative(3.75f)
                lineTo(17.81f, 9.94f)
                close()
                moveTo(5.0f, 19.0f)
                verticalLineToRelative(-0.92f)
                lineToRelative(9.06f, -9.06f)
                lineToRelative(0.92f, 0.92f)
                lineTo(5.92f, 19.0f)
                lineTo(5.0f, 19.0f)
                close()
            }
        }
        return _mode!!
    }

private var _mode: ImageVector? = null
