/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ChangeHistory: ImageVector
    get() {
        if (_changeHistory != null) {
            return _changeHistory!!
        }
        _changeHistory = materialIcon(name = "TwoTone.ChangeHistory") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 7.77f)
                lineTo(5.61f, 18.0f)
                horizontalLineToRelative(12.78f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                lineTo(2.0f, 20.0f)
                horizontalLineToRelative(20.0f)
                lineTo(12.0f, 4.0f)
                close()
                moveTo(12.0f, 7.77f)
                lineTo(18.39f, 18.0f)
                lineTo(5.61f, 18.0f)
                lineTo(12.0f, 7.77f)
                close()
            }
        }
        return _changeHistory!!
    }

private var _changeHistory: ImageVector? = null
