/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AddHomeWork: ImageVector
    get() {
        if (_addHomeWork != null) {
            return _addHomeWork!!
        }
        _addHomeWork = materialIcon(name = "TwoTone.AddHomeWork") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 5.0f)
                verticalLineToRelative(1.4f)
                lineToRelative(5.0f, 3.57f)
                verticalLineToRelative(1.11f)
                curveToRelative(0.33f, -0.05f, 0.66f, -0.08f, 1.0f, -0.08f)
                curveToRelative(1.08f, 0.0f, 2.09f, 0.25f, 3.0f, 0.68f)
                verticalLineTo(5.0f)
                horizontalLineTo(12.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(6.68f)
                curveToRelative(0.75f, 0.36f, 1.43f, 0.84f, 2.0f, 1.42f)
                verticalLineTo(3.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(1.97f)
                lineToRelative(2.0f, 1.43f)
                verticalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 6.0f)
                lineToRelative(-7.0f, 5.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.68f)
                curveTo(11.25f, 20.09f, 11.0f, 19.08f, 11.0f, 18.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-6.97f)
                lineToRelative(5.0f, -3.57f)
                lineToRelative(5.0f, 3.57f)
                verticalLineToRelative(1.08f)
                curveToRelative(0.57f, -0.59f, 1.25f, -1.07f, 2.0f, -1.42f)
                verticalLineTo(11.0f)
                lineTo(8.0f, 6.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.0f, 8.46f)
                lineToRelative(-5.0f, 3.57f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, -1.91f, 0.76f, -3.63f, 2.0f, -4.89f)
                verticalLineToRelative(-1.08f)
                lineTo(8.0f, 8.46f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(21.0f, 18.5f)
                horizontalLineToRelative(-2.5f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(15.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.5f)
                horizontalLineTo(21.0f)
                verticalLineTo(18.5f)
                close()
            }
        }
        return _addHomeWork!!
    }

private var _addHomeWork: ImageVector? = null
