/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Texture: ImageVector
    get() {
        if (_texture != null) {
            return _texture!!
        }
        _texture = materialIcon(name = "Sharp.Texture") {
            materialPath {
                moveTo(19.66f, 3.0f)
                lineTo(3.07f, 19.59f)
                lineTo(3.07f, 21.0f)
                horizontalLineToRelative(1.41f)
                lineTo(21.07f, 4.42f)
                lineTo(21.07f, 3.0f)
                close()
                moveTo(11.95f, 3.0f)
                lineToRelative(-8.88f, 8.88f)
                verticalLineToRelative(2.83f)
                lineTo(14.78f, 3.0f)
                close()
                moveTo(3.07f, 3.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(4.0f, -4.0f)
                close()
                moveTo(21.07f, 21.0f)
                verticalLineToRelative(-4.0f)
                lineToRelative(-4.0f, 4.0f)
                close()
                moveTo(12.19f, 21.0f)
                lineToRelative(8.88f, -8.88f)
                lineTo(21.07f, 9.29f)
                lineTo(9.36f, 21.0f)
                close()
            }
        }
        return _texture!!
    }

private var _texture: ImageVector? = null
