/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Hardware: ImageVector
    get() {
        if (_hardware != null) {
            return _hardware!!
        }
        _hardware = materialIcon(name = "Sharp.Hardware") {
            materialPath {
                moveTo(18.0f, 3.0f)
                lineToRelative(-3.0f, 3.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(9.0f)
                curveTo(6.24f, 3.0f, 4.0f, 5.24f, 4.0f, 8.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(8.0f)
                lineToRelative(3.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 13.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(9.0f)
                close()
            }
        }
        return _hardware!!
    }

private var _hardware: ImageVector? = null
