/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EditLocation: ImageVector
    get() {
        if (_editLocation != null) {
            return _editLocation!!
        }
        _editLocation = materialIcon(name = "Sharp.EditLocation") {
            materialPath {
                moveTo(18.11f, 1.77f)
                lineTo(19.78f, 0.1f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(-1.67f, 1.67f)
                lineToRelative(-2.12f, -2.12f)
                close()
                moveTo(17.11f, 2.77f)
                lineToRelative(2.12f, 2.12f)
                lineTo(13.12f, 11.0f)
                lineTo(11.0f, 11.0f)
                lineTo(11.0f, 8.89f)
                lineToRelative(6.11f, -6.12f)
                close()
                moveTo(15.13f, 2.64f)
                lineTo(9.5f, 8.27f)
                verticalLineToRelative(4.24f)
                horizontalLineToRelative(4.24f)
                lineToRelative(5.62f, -5.62f)
                curveToRelative(0.41f, 0.99f, 0.64f, 2.1f, 0.64f, 3.32f)
                curveToRelative(0.0f, 3.32f, -2.67f, 7.25f, -8.0f, 11.8f)
                curveToRelative(-5.33f, -4.55f, -8.0f, -8.48f, -8.0f, -11.8f)
                curveToRelative(0.0f, -4.98f, 3.8f, -8.2f, 8.0f, -8.2f)
                curveToRelative(1.09f, 0.0f, 2.16f, 0.22f, 3.13f, 0.63f)
                close()
            }
        }
        return _editLocation!!
    }

private var _editLocation: ImageVector? = null
