/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DoNotTouch: ImageVector
    get() {
        if (_doNotTouch != null) {
            return _doNotTouch!!
        }
        _doNotTouch = materialIcon(name = "Sharp.DoNotTouch") {
            materialPath {
                moveTo(13.0f, 10.17f)
                lineToRelative(-2.5f, -2.5f)
                verticalLineTo(1.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(10.17f)
                close()
                moveTo(20.0f, 4.0f)
                horizontalLineToRelative(-2.5f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(9.17f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(9.5f, 3.0f)
                horizontalLineTo(7.01f)
                verticalLineToRelative(1.18f)
                lineTo(9.5f, 6.67f)
                verticalLineTo(3.0f)
                close()
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(7.0f, 9.83f)
                verticalLineToRelative(4.3f)
                lineToRelative(-3.32f, -1.9f)
                lineTo(2.0f, 13.88f)
                lineTo(9.68f, 22.0f)
                horizontalLineToRelative(9.54f)
                lineToRelative(0.56f, 0.61f)
                lineTo(21.19f, 21.19f)
                close()
            }
        }
        return _doNotTouch!!
    }

private var _doNotTouch: ImageVector? = null
