/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.VolumeOff: ImageVector
    get() {
        if (_volumeOff != null) {
            return _volumeOff!!
        }
        _volumeOff = materialIcon(name = "Rounded.VolumeOff") {
            materialPath {
                moveTo(3.63f, 3.63f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(7.29f, 8.7f)
                lineTo(7.0f, 9.0f)
                lineTo(4.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(3.29f, 3.29f)
                curveToRelative(0.63f, 0.63f, 1.71f, 0.18f, 1.71f, -0.71f)
                verticalLineToRelative(-4.17f)
                lineToRelative(4.18f, 4.18f)
                curveToRelative(-0.49f, 0.37f, -1.02f, 0.68f, -1.6f, 0.91f)
                curveToRelative(-0.36f, 0.15f, -0.58f, 0.53f, -0.58f, 0.92f)
                curveToRelative(0.0f, 0.72f, 0.73f, 1.18f, 1.39f, 0.91f)
                curveToRelative(0.8f, -0.33f, 1.55f, -0.77f, 2.22f, -1.31f)
                lineToRelative(1.34f, 1.34f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(5.05f, 3.63f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.42f, 0.0f)
                close()
                moveTo(19.0f, 12.0f)
                curveToRelative(0.0f, 0.82f, -0.15f, 1.61f, -0.41f, 2.34f)
                lineToRelative(1.53f, 1.53f)
                curveToRelative(0.56f, -1.17f, 0.88f, -2.48f, 0.88f, -3.87f)
                curveToRelative(0.0f, -3.83f, -2.4f, -7.11f, -5.78f, -8.4f)
                curveToRelative(-0.59f, -0.23f, -1.22f, 0.23f, -1.22f, 0.86f)
                verticalLineToRelative(0.19f)
                curveToRelative(0.0f, 0.38f, 0.25f, 0.71f, 0.61f, 0.85f)
                curveTo(17.18f, 6.54f, 19.0f, 9.06f, 19.0f, 12.0f)
                close()
                moveTo(10.29f, 5.71f)
                lineToRelative(-0.17f, 0.17f)
                lineTo(12.0f, 7.76f)
                lineTo(12.0f, 6.41f)
                curveToRelative(0.0f, -0.89f, -1.08f, -1.33f, -1.71f, -0.7f)
                close()
                moveTo(16.5f, 12.0f)
                curveToRelative(0.0f, -1.77f, -1.02f, -3.29f, -2.5f, -4.03f)
                verticalLineToRelative(1.79f)
                lineToRelative(2.48f, 2.48f)
                curveToRelative(0.01f, -0.08f, 0.02f, -0.16f, 0.02f, -0.24f)
                close()
            }
        }
        return _volumeOff!!
    }

private var _volumeOff: ImageVector? = null
