/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SurroundSound: ImageVector
    get() {
        if (_surroundSound != null) {
            return _surroundSound!!
        }
        _surroundSound = materialIcon(name = "Rounded.SurroundSound") {
            materialPath {
                moveTo(20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(7.11f, 16.89f)
                curveToRelative(-0.43f, 0.43f, -1.14f, 0.39f, -1.51f, -0.09f)
                curveTo(4.53f, 15.39f, 4.0f, 13.69f, 4.0f, 12.0f)
                reflectiveCurveToRelative(0.53f, -3.38f, 1.59f, -4.8f)
                curveToRelative(0.37f, -0.48f, 1.08f, -0.53f, 1.51f, -0.1f)
                curveToRelative(0.35f, 0.35f, 0.39f, 0.9f, 0.1f, 1.29f)
                curveTo(6.4f, 9.46f, 6.0f, 10.73f, 6.0f, 12.0f)
                reflectiveCurveToRelative(0.4f, 2.53f, 1.2f, 3.6f)
                curveToRelative(0.3f, 0.39f, 0.26f, 0.94f, -0.09f, 1.29f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                close()
                moveTo(16.9f, 16.9f)
                curveToRelative(-0.35f, -0.35f, -0.39f, -0.9f, -0.09f, -1.29f)
                curveTo(17.6f, 14.54f, 18.0f, 13.27f, 18.0f, 12.0f)
                reflectiveCurveToRelative(-0.4f, -2.53f, -1.2f, -3.6f)
                curveToRelative(-0.3f, -0.39f, -0.26f, -0.95f, 0.09f, -1.3f)
                curveToRelative(0.43f, -0.43f, 1.14f, -0.39f, 1.51f, 0.09f)
                curveToRelative(1.07f, 1.41f, 1.6f, 3.1f, 1.6f, 4.8f)
                curveToRelative(0.0f, 1.69f, -0.53f, 3.38f, -1.59f, 4.8f)
                curveToRelative(-0.37f, 0.49f, -1.08f, 0.54f, -1.51f, 0.11f)
                close()
                moveTo(12.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _surroundSound!!
    }

private var _surroundSound: ImageVector? = null
