/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Sick: ImageVector
    get() {
        if (_sick != null) {
            return _sick!!
        }
        _sick = materialIcon(name = "Rounded.Sick") {
            materialPath {
                moveTo(23.0f, 7.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -0.78f, 0.99f, -2.44f, 1.58f, -3.36f)
                curveToRelative(0.2f, -0.31f, 0.64f, -0.31f, 0.84f, 0.0f)
                curveTo(22.01f, 4.56f, 23.0f, 6.22f, 23.0f, 7.0f)
                close()
                moveTo(21.86f, 10.38f)
                curveTo(21.94f, 10.91f, 22.0f, 11.45f, 22.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, -4.48f, 10.0f, -10.01f, 10.0f)
                curveTo(6.47f, 22.0f, 2.0f, 17.52f, 2.0f, 12.0f)
                curveTo(2.0f, 6.48f, 6.47f, 2.0f, 11.99f, 2.0f)
                curveToRelative(2.45f, 0.0f, 4.69f, 0.88f, 6.43f, 2.34f)
                curveTo(17.91f, 5.29f, 17.5f, 6.27f, 17.5f, 7.0f)
                curveToRelative(0.0f, 1.93f, 1.57f, 3.5f, 3.5f, 3.5f)
                curveTo(21.3f, 10.5f, 21.58f, 10.45f, 21.86f, 10.38f)
                close()
                moveTo(14.03f, 10.03f)
                lineToRelative(1.06f, 1.06f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineTo(15.62f, 9.5f)
                lineToRelative(0.53f, -0.53f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                reflectiveCurveToRelative(-0.77f, -0.29f, -1.06f, 0.0f)
                lineToRelative(-1.06f, 1.06f)
                curveTo(13.74f, 9.26f, 13.74f, 9.74f, 14.03f, 10.03f)
                close()
                moveTo(8.38f, 9.5f)
                lineToRelative(-0.53f, 0.53f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(1.06f, -1.06f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineTo(8.91f, 7.91f)
                curveToRelative(-0.29f, -0.29f, -0.77f, -0.29f, -1.06f, 0.0f)
                reflectiveCurveToRelative(-0.29f, 0.77f, 0.0f, 1.06f)
                lineTo(8.38f, 9.5f)
                close()
                moveTo(16.47f, 15.8f)
                curveToRelative(-1.0f, -1.39f, -2.62f, -2.3f, -4.47f, -2.3f)
                curveToRelative(-0.87f, 0.0f, -1.69f, 0.2f, -2.43f, 0.56f)
                lineTo(5.99f, 12.0f)
                curveToRelative(0.0f, -0.52f, -0.26f, -1.02f, -0.74f, -1.29f)
                curveToRelative(-0.8f, -0.46f, -1.84f, -0.11f, -2.17f, 0.8f)
                curveToRelative(-0.21f, 0.57f, -0.03f, 1.25f, 0.44f, 1.64f)
                curveToRelative(0.52f, 0.44f, 1.2f, 0.45f, 1.72f, 0.16f)
                lineToRelative(2.97f, 1.72f)
                curveToRelative(-0.25f, 0.24f, -0.48f, 0.5f, -0.68f, 0.78f)
                curveTo(7.17f, 16.3f, 7.53f, 17.0f, 8.15f, 17.0f)
                curveToRelative(0.23f, 0.0f, 0.46f, -0.1f, 0.6f, -0.3f)
                curveTo(9.47f, 15.68f, 10.65f, 15.0f, 12.0f, 15.0f)
                reflectiveCurveToRelative(2.53f, 0.68f, 3.25f, 1.7f)
                curveToRelative(0.14f, 0.19f, 0.36f, 0.3f, 0.6f, 0.3f)
                horizontalLineToRelative(0.0f)
                curveTo(16.47f, 17.0f, 16.83f, 16.3f, 16.47f, 15.8f)
                close()
            }
        }
        return _sick!!
    }

private var _sick: ImageVector? = null
