/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RestaurantMenu: ImageVector
    get() {
        if (_restaurantMenu != null) {
            return _restaurantMenu!!
        }
        _restaurantMenu = materialIcon(name = "Rounded.RestaurantMenu") {
            materialPath {
                moveTo(8.1f, 13.34f)
                lineToRelative(2.83f, -2.83f)
                lineToRelative(-6.19f, -6.18f)
                curveToRelative(-0.48f, -0.48f, -1.31f, -0.35f, -1.61f, 0.27f)
                curveToRelative(-0.71f, 1.49f, -0.45f, 3.32f, 0.78f, 4.56f)
                lineToRelative(4.19f, 4.18f)
                close()
                moveTo(14.88f, 11.53f)
                curveToRelative(1.53f, 0.71f, 3.68f, 0.21f, 5.27f, -1.38f)
                curveToRelative(1.91f, -1.91f, 2.28f, -4.65f, 0.81f, -6.12f)
                curveToRelative(-1.46f, -1.46f, -4.2f, -1.1f, -6.12f, 0.81f)
                curveToRelative(-1.59f, 1.59f, -2.09f, 3.74f, -1.38f, 5.27f)
                lineTo(4.4f, 19.17f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineTo(12.0f, 14.41f)
                lineToRelative(6.18f, 6.18f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(13.41f, 13.0f)
                lineToRelative(1.47f, -1.47f)
                close()
            }
        }
        return _restaurantMenu!!
    }

private var _restaurantMenu: ImageVector? = null
