/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Opacity: ImageVector
    get() {
        if (_opacity != null) {
            return _opacity!!
        }
        _opacity = materialIcon(name = "Rounded.Opacity") {
            materialPath {
                moveTo(17.65f, 7.56f)
                lineTo(17.65f, 7.56f)
                lineTo(12.7f, 2.69f)
                curveToRelative(-0.39f, -0.38f, -1.01f, -0.38f, -1.4f, 0.0f)
                lineTo(6.35f, 7.56f)
                lineToRelative(0.0f, 0.0f)
                curveTo(4.9f, 8.99f, 4.0f, 10.96f, 4.0f, 13.13f)
                curveTo(4.0f, 17.48f, 7.58f, 21.0f, 12.0f, 21.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, -3.52f, 8.0f, -7.87f)
                curveTo(20.0f, 10.96f, 19.1f, 8.99f, 17.65f, 7.56f)
                close()
                moveTo(7.75f, 8.99f)
                lineTo(12.0f, 4.81f)
                lineToRelative(4.25f, 4.18f)
                curveToRelative(0.88f, 0.87f, 2.04f, 2.59f, 1.67f, 5.01f)
                horizontalLineTo(6.07f)
                curveTo(5.7f, 11.58f, 6.87f, 9.85f, 7.75f, 8.99f)
                close()
            }
        }
        return _opacity!!
    }

private var _opacity: ImageVector? = null
