/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LinkedCamera: ImageVector
    get() {
        if (_linkedCamera != null) {
            return _linkedCamera!!
        }
        _linkedCamera = materialIcon(name = "Rounded.LinkedCamera") {
            materialPath {
                moveTo(12.0f, 13.0f)
                moveToRelative(-2.5f, 0.0f)
                arcToRelative(2.5f, 2.5f, 0.0f, true, true, 5.0f, 0.0f)
                arcToRelative(2.5f, 2.5f, 0.0f, true, true, -5.0f, 0.0f)
            }
            materialPath {
                moveTo(16.6f, 2.37f)
                curveToRelative(2.1f, 0.27f, 3.77f, 1.93f, 4.03f, 4.03f)
                curveTo(20.67f, 6.74f, 20.95f, 7.0f, 21.29f, 7.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.0f, 0.71f, -0.34f, 0.66f, -0.73f)
                curveToRelative(-0.33f, -2.72f, -2.5f, -4.89f, -5.22f, -5.22f)
                curveTo(16.34f, 1.0f, 16.0f, 1.32f, 16.0f, 1.71f)
                lineToRelative(0.0f, 0.0f)
                curveTo(16.0f, 2.05f, 16.26f, 2.33f, 16.6f, 2.37f)
                close()
            }
            materialPath {
                moveTo(19.23f, 6.19f)
                curveTo(18.93f, 5.0f, 18.0f, 4.07f, 16.81f, 3.77f)
                curveTo(16.4f, 3.67f, 16.0f, 3.99f, 16.0f, 4.42f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, 0.29f, 0.19f, 0.57f, 0.48f, 0.64f)
                curveToRelative(0.72f, 0.18f, 1.29f, 0.74f, 1.46f, 1.46f)
                curveTo(18.01f, 6.81f, 18.28f, 7.0f, 18.58f, 7.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(19.01f, 7.0f, 19.33f, 6.6f, 19.23f, 6.19f)
                close()
            }
            materialPath {
                moveTo(17.0f, 8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(9.88f)
                curveTo(9.32f, 3.0f, 8.78f, 3.24f, 8.4f, 3.65f)
                lineTo(7.17f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 5.0f, 2.0f, 5.9f, 2.0f, 7.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(17.0f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(-2.48f, 0.0f, -4.5f, -2.02f, -4.5f, -4.5f)
                reflectiveCurveTo(9.52f, 8.5f, 12.0f, 8.5f)
                reflectiveCurveToRelative(4.5f, 2.02f, 4.5f, 4.5f)
                reflectiveCurveTo(14.48f, 17.5f, 12.0f, 17.5f)
                close()
            }
        }
        return _linkedCamera!!
    }

private var _linkedCamera: ImageVector? = null
