/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.KeyboardOptionKey: ImageVector
    get() {
        if (_keyboardOptionKey != null) {
            return _keyboardOptionKey!!
        }
        _keyboardOptionKey = materialIcon(name = "Rounded.KeyboardOptionKey") {
            materialPath {
                moveTo(15.0f, 6.0f)
                lineTo(15.0f, 6.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(15.45f, 5.0f, 15.0f, 5.45f, 15.0f, 6.0f)
                close()
            }
            materialPath {
                moveTo(9.58f, 6.0f)
                curveTo(9.22f, 5.38f, 8.56f, 5.0f, 7.85f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 5.0f, 3.0f, 5.45f, 3.0f, 6.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.85f)
                lineToRelative(6.35f, 11.0f)
                curveToRelative(0.36f, 0.62f, 1.02f, 1.0f, 1.73f, 1.0f)
                horizontalLineTo(20.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.07f)
                lineTo(9.58f, 6.0f)
                close()
            }
        }
        return _keyboardOptionKey!!
    }

private var _keyboardOptionKey: ImageVector? = null
