/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FireTruck: ImageVector
    get() {
        if (_fireTruck != null) {
            return _fireTruck!!
        }
        _fireTruck = materialIcon(name = "Rounded.FireTruck") {
            materialPath {
                moveTo(22.9f, 10.69f)
                lineToRelative(-1.44f, -4.32f)
                curveTo(21.18f, 5.55f, 20.42f, 5.0f, 19.56f, 5.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.68f)
                curveTo(23.0f, 11.11f, 22.97f, 10.9f, 22.9f, 10.69f)
                close()
                moveTo(7.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(7.55f, 19.0f, 7.0f, 19.0f)
                close()
                moveTo(17.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(17.55f, 19.0f, 17.0f, 19.0f)
                close()
                moveTo(14.0f, 11.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(5.56f)
                lineToRelative(1.33f, 4.0f)
                horizontalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(10.25f, 8.5f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(0.25f)
                curveTo(10.66f, 6.5f, 11.0f, 6.16f, 11.0f, 5.75f)
                verticalLineToRelative(0.0f)
                curveTo(11.0f, 5.34f, 10.66f, 5.0f, 10.25f, 5.0f)
                horizontalLineToRelative(-8.5f)
                curveTo(1.34f, 5.0f, 1.0f, 5.34f, 1.0f, 5.75f)
                verticalLineToRelative(0.0f)
                curveTo(1.0f, 6.16f, 1.34f, 6.5f, 1.75f, 6.5f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(1.75f)
                curveTo(1.34f, 8.5f, 1.0f, 8.84f, 1.0f, 9.25f)
                verticalLineToRelative(0.0f)
                curveTo(1.0f, 9.66f, 1.34f, 10.0f, 1.75f, 10.0f)
                horizontalLineToRelative(8.5f)
                curveTo(10.66f, 10.0f, 11.0f, 9.66f, 11.0f, 9.25f)
                verticalLineToRelative(0.0f)
                curveTo(11.0f, 8.84f, 10.66f, 8.5f, 10.25f, 8.5f)
                close()
                moveTo(5.25f, 8.5f)
                horizontalLineTo(3.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.75f)
                verticalLineTo(8.5f)
                close()
                moveTo(8.5f, 8.5f)
                horizontalLineTo(6.75f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(8.5f)
                verticalLineTo(8.5f)
                close()
            }
        }
        return _fireTruck!!
    }

private var _fireTruck: ImageVector? = null
