/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Chalet: ImageVector
    get() {
        if (_chalet != null) {
            return _chalet!!
        }
        _chalet = materialIcon(name = "Rounded.Chalet") {
            materialPath {
                moveTo(10.0f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.67f)
                lineToRelative(-0.38f, 0.38f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(6.09f, -6.09f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(6.09f, 6.09f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.02f, 0.0f, 1.41f)
                verticalLineToRelative(0.0f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineTo(15.0f, 15.33f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-4.0f)
                curveTo(11.0f, 15.45f, 10.55f, 15.0f, 10.0f, 15.0f)
                close()
                moveTo(17.5f, 7.5f)
                verticalLineToRelative(0.89f)
                lineToRelative(-1.08f, 1.08f)
                curveToRelative(-0.18f, 0.18f, -0.21f, 0.48f, -0.05f, 0.69f)
                curveToRelative(0.19f, 0.23f, 0.53f, 0.24f, 0.74f, 0.04f)
                lineToRelative(0.39f, -0.39f)
                verticalLineToRelative(0.69f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                verticalLineTo(9.81f)
                lineToRelative(0.39f, 0.39f)
                curveToRelative(0.21f, 0.21f, 0.55f, 0.19f, 0.74f, -0.04f)
                curveToRelative(0.17f, -0.2f, 0.14f, -0.5f, -0.05f, -0.69f)
                lineTo(18.5f, 8.39f)
                curveToRelative(0.0f, 0.0f, 0.0f, -0.89f, 0.0f, -0.89f)
                horizontalLineToRelative(0.89f)
                lineToRelative(1.08f, 1.08f)
                curveToRelative(0.18f, 0.18f, 0.48f, 0.21f, 0.69f, 0.05f)
                curveToRelative(0.23f, -0.19f, 0.24f, -0.53f, 0.04f, -0.74f)
                lineTo(20.81f, 7.5f)
                horizontalLineToRelative(0.69f)
                curveTo(21.78f, 7.5f, 22.0f, 7.28f, 22.0f, 7.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                lineToRelative(-0.69f, 0.0f)
                lineToRelative(0.39f, -0.39f)
                curveToRelative(0.21f, -0.21f, 0.19f, -0.55f, -0.04f, -0.74f)
                curveToRelative(-0.2f, -0.17f, -0.5f, -0.14f, -0.69f, 0.05f)
                lineTo(19.39f, 6.5f)
                curveToRelative(0.0f, 0.0f, -0.89f, 0.0f, -0.89f, 0.0f)
                verticalLineTo(5.61f)
                lineToRelative(1.08f, -1.08f)
                curveToRelative(0.18f, -0.18f, 0.21f, -0.48f, 0.05f, -0.69f)
                curveToRelative(-0.19f, -0.23f, -0.53f, -0.24f, -0.74f, -0.04f)
                lineTo(18.5f, 4.19f)
                verticalLineTo(3.5f)
                curveTo(18.5f, 3.22f, 18.28f, 3.0f, 18.0f, 3.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineToRelative(0.69f)
                lineTo(17.11f, 3.8f)
                curveToRelative(-0.21f, -0.21f, -0.55f, -0.19f, -0.74f, 0.04f)
                curveToRelative(-0.17f, 0.2f, -0.14f, 0.5f, 0.05f, 0.69f)
                lineToRelative(1.08f, 1.08f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.89f, 0.0f, 0.89f)
                horizontalLineToRelative(-0.89f)
                lineToRelative(-1.08f, -1.08f)
                curveToRelative(-0.18f, -0.18f, -0.48f, -0.21f, -0.69f, -0.05f)
                curveToRelative(-0.23f, 0.19f, -0.24f, 0.53f, -0.04f, 0.74f)
                lineToRelative(0.39f, 0.39f)
                horizontalLineTo(14.5f)
                curveTo(14.22f, 6.5f, 14.0f, 6.72f, 14.0f, 7.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                lineToRelative(0.69f, 0.0f)
                lineTo(14.8f, 7.89f)
                curveToRelative(-0.21f, 0.21f, -0.19f, 0.55f, 0.04f, 0.74f)
                curveToRelative(0.2f, 0.17f, 0.5f, 0.14f, 0.69f, -0.05f)
                lineToRelative(1.08f, -1.08f)
                curveTo(16.61f, 7.5f, 17.5f, 7.5f, 17.5f, 7.5f)
                close()
            }
        }
        return _chalet!!
    }

private var _chalet: ImageVector? = null
