/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ViewCompact: ImageVector
    get() {
        if (_viewCompact != null) {
            return _viewCompact!!
        }
        _viewCompact = materialIcon(name = "Outlined.ViewCompact") {
            materialPath {
                moveTo(2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(2.0f)
                close()
                moveTo(6.5f, 18.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(18.0f)
                close()
                moveTo(6.5f, 13.25f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(13.25f)
                close()
                moveTo(6.5f, 8.5f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(8.5f)
                close()
                moveTo(11.0f, 18.0f)
                horizontalLineTo(8.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(11.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(11.0f, 13.25f)
                horizontalLineTo(8.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(11.0f)
                verticalLineTo(13.25f)
                close()
                moveTo(11.0f, 8.5f)
                horizontalLineTo(8.5f)
                verticalLineTo(6.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(8.5f)
                close()
                moveTo(15.5f, 18.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(18.0f)
                close()
                moveTo(15.5f, 13.25f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(13.25f)
                close()
                moveTo(15.5f, 8.5f)
                horizontalLineTo(13.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(8.5f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineToRelative(-2.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(20.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(20.0f, 13.25f)
                horizontalLineToRelative(-2.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(20.0f)
                verticalLineTo(13.25f)
                close()
                moveTo(20.0f, 8.5f)
                horizontalLineToRelative(-2.5f)
                verticalLineTo(6.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(8.5f)
                close()
            }
        }
        return _viewCompact!!
    }

private var _viewCompact: ImageVector? = null
