/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RememberMe: ImageVector
    get() {
        if (_rememberMe != null) {
            return _rememberMe!!
        }
        _rememberMe = materialIcon(name = "Outlined.RememberMe") {
            materialPath {
                moveTo(17.0f, 1.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 1.0f, 5.0f, 1.9f, 5.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(19.0f, 1.9f, 18.1f, 1.0f, 17.0f, 1.0f)
                close()
                moveTo(17.0f, 21.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(17.0f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-0.48f)
                curveTo(8.47f, 16.53f, 10.22f, 16.0f, 12.0f, 16.0f)
                reflectiveCurveToRelative(3.53f, 0.53f, 5.0f, 1.52f)
                verticalLineTo(18.0f)
                close()
                moveTo(17.0f, 15.21f)
                curveTo(15.5f, 14.44f, 13.8f, 14.0f, 12.0f, 14.0f)
                reflectiveCurveToRelative(-3.5f, 0.44f, -5.0f, 1.21f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(15.21f)
                close()
                moveTo(17.0f, 4.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 13.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveTo(10.34f, 13.0f, 12.0f, 13.0f)
                close()
                moveTo(12.0f, 9.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(11.45f, 9.0f, 12.0f, 9.0f)
                close()
            }
        }
        return _rememberMe!!
    }

private var _rememberMe: ImageVector? = null
