/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AirlineStops: ImageVector
    get() {
        if (_airlineStops != null) {
            return _airlineStops!!
        }
        _airlineStops = materialIcon(name = "Outlined.AirlineStops") {
            materialPath {
                moveTo(19.0f, 8.7f)
                curveToRelative(-2.46f, 1.5f, -5.5f, 4.17f, -6.0f, 8.3f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(-0.5f, -4.5f, -4.37f, -8.0f, -9.0f, -8.0f)
                verticalLineTo(7.0f)
                curveToRelative(4.39f, 0.0f, 8.22f, 2.55f, 10.0f, 6.3f)
                curveToRelative(1.38f, -2.97f, 3.86f, -5.03f, 5.96f, -6.31f)
                lineTo(14.0f, 7.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(8.7f)
                close()
            }
        }
        return _airlineStops!!
    }

private var _airlineStops: ImageVector? = null
