/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SpeakerNotesOff: ImageVector
    get() {
        if (_speakerNotesOff != null) {
            return _speakerNotesOff!!
        }
        _speakerNotesOff = materialIcon(name = "Filled.SpeakerNotesOff") {
            materialPath {
                moveTo(10.54f, 11.0f)
                lineToRelative(-0.54f, -0.54f)
                lineTo(7.54f, 8.0f)
                lineTo(6.0f, 6.46f)
                lineTo(2.38f, 2.84f)
                lineTo(1.27f, 1.73f)
                lineTo(0.0f, 3.0f)
                lineToRelative(2.01f, 2.01f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(9.0f)
                lineToRelative(5.73f, 5.73f)
                lineTo(22.0f, 22.46f)
                lineTo(17.54f, 18.0f)
                lineToRelative(-7.0f, -7.0f)
                close()
                moveTo(8.0f, 14.0f)
                lineTo(6.0f, 14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(6.0f, 11.0f)
                lineTo(6.0f, 9.0f)
                lineToRelative(2.0f, 2.0f)
                lineTo(6.0f, 11.0f)
                close()
                moveTo(20.0f, 2.0f)
                lineTo(4.08f, 2.0f)
                lineTo(10.0f, 7.92f)
                lineTo(10.0f, 6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-7.92f)
                lineToRelative(1.0f, 1.0f)
                lineTo(18.0f, 9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.92f)
                lineToRelative(6.99f, 6.99f)
                curveTo(21.14f, 17.95f, 22.0f, 17.08f, 22.0f, 16.0f)
                lineTo(22.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _speakerNotesOff!!
    }

private var _speakerNotesOff: ImageVector? = null
