/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Rowing: ImageVector
    get() {
        if (_rowing != null) {
            return _rowing!!
        }
        _rowing = materialIcon(name = "Filled.Rowing") {
            materialPath {
                moveTo(8.5f, 14.5f)
                lineTo(4.0f, 19.0f)
                lineToRelative(1.5f, 1.5f)
                lineTo(9.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                lineTo(8.5f, 14.5f)
                close()
                moveTo(15.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(16.1f, 1.0f, 15.0f, 1.0f)
                close()
                moveTo(21.0f, 21.01f)
                lineTo(18.0f, 24.0f)
                lineToRelative(-2.99f, -3.01f)
                verticalLineTo(19.5f)
                lineToRelative(-7.1f, -7.09f)
                curveTo(7.6f, 12.46f, 7.3f, 12.48f, 7.0f, 12.48f)
                verticalLineToRelative(-2.16f)
                curveToRelative(1.66f, 0.03f, 3.61f, -0.87f, 4.67f, -2.04f)
                lineToRelative(1.4f, -1.55f)
                curveTo(13.42f, 6.34f, 14.06f, 6.0f, 14.72f, 6.0f)
                horizontalLineToRelative(0.03f)
                curveTo(15.99f, 6.01f, 17.0f, 7.02f, 17.0f, 8.26f)
                verticalLineToRelative(5.75f)
                curveToRelative(0.0f, 0.84f, -0.35f, 1.61f, -0.92f, 2.16f)
                lineToRelative(-3.58f, -3.58f)
                verticalLineToRelative(-2.27f)
                curveToRelative(-0.63f, 0.52f, -1.43f, 1.02f, -2.29f, 1.39f)
                lineTo(16.5f, 18.0f)
                horizontalLineTo(18.0f)
                lineTo(21.0f, 21.01f)
                close()
            }
        }
        return _rowing!!
    }

private var _rowing: ImageVector? = null
