/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PeopleOutline: ImageVector
    get() {
        if (_peopleOutline != null) {
            return _peopleOutline!!
        }
        _peopleOutline = materialIcon(name = "Filled.PeopleOutline") {
            materialPath {
                moveTo(16.5f, 13.0f)
                curveToRelative(-1.2f, 0.0f, -3.07f, 0.34f, -4.5f, 1.0f)
                curveToRelative(-1.43f, -0.67f, -3.3f, -1.0f, -4.5f, -1.0f)
                curveTo(5.33f, 13.0f, 1.0f, 14.08f, 1.0f, 16.25f)
                lineTo(1.0f, 19.0f)
                horizontalLineToRelative(22.0f)
                verticalLineToRelative(-2.75f)
                curveToRelative(0.0f, -2.17f, -4.33f, -3.25f, -6.5f, -3.25f)
                close()
                moveTo(12.5f, 17.5f)
                horizontalLineToRelative(-10.0f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -0.54f, 2.56f, -1.75f, 5.0f, -1.75f)
                reflectiveCurveToRelative(5.0f, 1.21f, 5.0f, 1.75f)
                verticalLineToRelative(1.25f)
                close()
                moveTo(21.5f, 17.5f)
                lineTo(14.0f, 17.5f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -0.46f, -0.2f, -0.86f, -0.52f, -1.22f)
                curveToRelative(0.88f, -0.3f, 1.96f, -0.53f, 3.02f, -0.53f)
                curveToRelative(2.44f, 0.0f, 5.0f, 1.21f, 5.0f, 1.75f)
                verticalLineToRelative(1.25f)
                close()
                moveTo(7.5f, 12.0f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveTo(9.43f, 5.0f, 7.5f, 5.0f)
                reflectiveCurveTo(4.0f, 6.57f, 4.0f, 8.5f)
                reflectiveCurveTo(5.57f, 12.0f, 7.5f, 12.0f)
                close()
                moveTo(7.5f, 6.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                close()
                moveTo(16.5f, 12.0f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveTo(18.43f, 5.0f, 16.5f, 5.0f)
                reflectiveCurveTo(13.0f, 6.57f, 13.0f, 8.5f)
                reflectiveCurveToRelative(1.57f, 3.5f, 3.5f, 3.5f)
                close()
                moveTo(16.5f, 6.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                close()
            }
        }
        return _peopleOutline!!
    }

private var _peopleOutline: ImageVector? = null
