/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AddToDrive: ImageVector
    get() {
        if (_addToDrive != null) {
            return _addToDrive!!
        }
        _addToDrive = materialIcon(name = "Filled.AddToDrive") {
            materialPath {
                moveTo(20.0f, 21.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(15.03f, 21.5f)
                horizontalLineTo(5.66f)
                curveToRelative(-0.72f, 0.0f, -1.38f, -0.38f, -1.73f, -1.0f)
                lineTo(1.57f, 16.4f)
                curveToRelative(-0.36f, -0.62f, -0.35f, -1.38f, 0.01f, -2.0f)
                lineTo(7.92f, 3.49f)
                curveTo(8.28f, 2.88f, 8.94f, 2.5f, 9.65f, 2.5f)
                horizontalLineToRelative(4.7f)
                curveToRelative(0.71f, 0.0f, 1.37f, 0.38f, 1.73f, 0.99f)
                lineToRelative(4.48f, 7.71f)
                curveTo(20.06f, 11.07f, 19.54f, 11.0f, 19.0f, 11.0f)
                curveToRelative(-0.28f, 0.0f, -0.56f, 0.02f, -0.84f, 0.06f)
                lineTo(14.35f, 4.5f)
                horizontalLineToRelative(-4.7f)
                lineTo(3.31f, 15.41f)
                lineToRelative(2.35f, 4.09f)
                horizontalLineToRelative(7.89f)
                curveTo(13.9f, 20.27f, 14.4f, 20.95f, 15.03f, 21.5f)
                close()
                moveTo(13.34f, 15.0f)
                curveTo(13.12f, 15.63f, 13.0f, 16.3f, 13.0f, 17.0f)
                horizontalLineTo(7.25f)
                lineToRelative(-0.73f, -1.27f)
                lineToRelative(4.58f, -7.98f)
                horizontalLineToRelative(1.8f)
                lineToRelative(2.53f, 4.42f)
                curveToRelative(-0.56f, 0.42f, -1.05f, 0.93f, -1.44f, 1.51f)
                lineToRelative(-2.0f, -3.49f)
                lineTo(9.25f, 15.0f)
                horizontalLineTo(13.34f)
                close()
            }
        }
        return _addToDrive!!
    }

private var _addToDrive: ImageVector? = null
