/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import android.os.Build;
import android.view.View;
import androidx.compose.foundation.layout.WindowInsetsHolder;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Landroidx/compose/foundation/layout/InsetsListener;", "Landroidx/core/view/WindowInsetsAnimationCompat$Callback;", "Ljava/lang/Runnable;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "Landroid/view/View$OnAttachStateChangeListener;", "composeInsets", "Landroidx/compose/foundation/layout/WindowInsetsHolder;", "(Landroidx/compose/foundation/layout/WindowInsetsHolder;)V", "getComposeInsets", "()Landroidx/compose/foundation/layout/WindowInsetsHolder;", "prepared", "", "getPrepared", "()Z", "setPrepared", "(Z)V", "savedInsets", "Landroidx/core/view/WindowInsetsCompat;", "getSavedInsets", "()Landroidx/core/view/WindowInsetsCompat;", "setSavedInsets", "(Landroidx/core/view/WindowInsetsCompat;)V", "onApplyWindowInsets", "view", "Landroid/view/View;", "insets", "onEnd", "", "animation", "Landroidx/core/view/WindowInsetsAnimationCompat;", "onPrepare", "onProgress", "runningAnimations", "", "onStart", "Landroidx/core/view/WindowInsetsAnimationCompat$BoundsCompat;", "bounds", "onViewAttachedToWindow", "onViewDetachedFromWindow", "v", "run", "foundation-layout_release"})
final class InsetsListener
extends WindowInsetsAnimationCompat.Callback
implements Runnable,
OnApplyWindowInsetsListener,
View.OnAttachStateChangeListener {
    @NotNull
    private final WindowInsetsHolder composeInsets;
    private boolean prepared;
    @Nullable
    private WindowInsetsCompat savedInsets;

    public InsetsListener(@NotNull WindowInsetsHolder composeInsets) {
        Intrinsics.checkNotNullParameter((Object)composeInsets, (String)"composeInsets");
        super(composeInsets.getConsumes() ? 0 : 1);
        this.composeInsets = composeInsets;
    }

    @NotNull
    public final WindowInsetsHolder getComposeInsets() {
        return this.composeInsets;
    }

    public final boolean getPrepared() {
        return this.prepared;
    }

    public final void setPrepared(boolean bl) {
        this.prepared = bl;
    }

    @Nullable
    public final WindowInsetsCompat getSavedInsets() {
        return this.savedInsets;
    }

    public final void setSavedInsets(@Nullable WindowInsetsCompat windowInsetsCompat) {
        this.savedInsets = windowInsetsCompat;
    }

    public void onPrepare(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.prepared = true;
        super.onPrepare(animation);
    }

    @NotNull
    public WindowInsetsAnimationCompat.BoundsCompat onStart(@NotNull WindowInsetsAnimationCompat animation, @NotNull WindowInsetsAnimationCompat.BoundsCompat bounds) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.prepared = false;
        WindowInsetsAnimationCompat.BoundsCompat boundsCompat = super.onStart(animation, bounds);
        Intrinsics.checkNotNullExpressionValue((Object)boundsCompat, (String)"super.onStart(animation, bounds)");
        return boundsCompat;
    }

    @NotNull
    public WindowInsetsCompat onProgress(@NotNull WindowInsetsCompat insets, @NotNull List<WindowInsetsAnimationCompat> runningAnimations) {
        WindowInsetsCompat windowInsetsCompat;
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Intrinsics.checkNotNullParameter(runningAnimations, (String)"runningAnimations");
        WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    public void onEnd(@NotNull WindowInsetsAnimationCompat animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.prepared = false;
        WindowInsetsCompat insets = this.savedInsets;
        if (animation.getDurationMillis() != 0L && insets != null) {
            this.composeInsets.update(insets, animation.getTypeMask());
        }
        this.savedInsets = null;
        super.onEnd(animation);
    }

    @NotNull
    public WindowInsetsCompat onApplyWindowInsets(@NotNull View view, @NotNull WindowInsetsCompat insets) {
        WindowInsetsCompat windowInsetsCompat;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        if (this.prepared) {
            this.savedInsets = insets;
            if (Build.VERSION.SDK_INT == 30) {
                view.post((Runnable)this);
            }
            return insets;
        }
        WindowInsetsHolder.update$default(this.composeInsets, insets, 0, 2, null);
        if (this.composeInsets.getConsumes()) {
            WindowInsetsCompat windowInsetsCompat2 = WindowInsetsCompat.CONSUMED;
            windowInsetsCompat = windowInsetsCompat2;
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"CONSUMED");
        } else {
            windowInsetsCompat = insets;
        }
        return windowInsetsCompat;
    }

    @Override
    public void run() {
        block1: {
            if (!this.prepared) break block1;
            this.prepared = false;
            WindowInsetsCompat windowInsetsCompat = this.savedInsets;
            if (windowInsetsCompat != null) {
                WindowInsetsCompat it = windowInsetsCompat;
                boolean bl = false;
                WindowInsetsHolder.update$default(this.composeInsets, it, 0, 2, null);
                this.savedInsets = null;
            }
        }
    }

    public void onViewAttachedToWindow(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.requestApplyInsets();
    }

    public void onViewDetachedFromWindow(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
    }
}

