/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.foundation.text

import androidx.compose.foundation.implementedInJetBrainsFork
import androidx.compose.ui.input.key.Key

internal actual val platformDefaultKeyMapping: KeyMapping = implementedInJetBrainsFork()

internal actual object MappedKeys {
    actual val A: Key = implementedInJetBrainsFork()
    actual val C: Key = implementedInJetBrainsFork()
    actual val H: Key = implementedInJetBrainsFork()
    actual val V: Key = implementedInJetBrainsFork()
    actual val X: Key = implementedInJetBrainsFork()
    actual val Y: Key = implementedInJetBrainsFork()
    actual val Z: Key = implementedInJetBrainsFork()
    actual val Backslash: Key = implementedInJetBrainsFork()
    actual val DirectionLeft: Key = implementedInJetBrainsFork()
    actual val DirectionRight: Key = implementedInJetBrainsFork()
    actual val DirectionUp: Key = implementedInJetBrainsFork()
    actual val DirectionDown: Key = implementedInJetBrainsFork()
    actual val PageUp: Key = implementedInJetBrainsFork()
    actual val PageDown: Key = implementedInJetBrainsFork()
    actual val MoveHome: Key = implementedInJetBrainsFork()
    actual val MoveEnd: Key = implementedInJetBrainsFork()
    actual val Insert: Key = implementedInJetBrainsFork()
    actual val Enter: Key = implementedInJetBrainsFork()
    actual val Backspace: Key = implementedInJetBrainsFork()
    actual val Delete: Key = implementedInJetBrainsFork()
    actual val Paste: Key = implementedInJetBrainsFork()
    actual val Cut: Key = implementedInJetBrainsFork()
    actual val Copy: Key = implementedInJetBrainsFork()
    actual val Tab: Key = implementedInJetBrainsFork()
}
