/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.ui.text.input.OffsetMapping;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/foundation/text/ValidatingOffsetMapping;", "Landroidx/compose/ui/text/input/OffsetMapping;", "delegate", "originalLength", "", "transformedLength", "(Landroidx/compose/ui/text/input/OffsetMapping;II)V", "originalToTransformed", "offset", "transformedToOriginal", "foundation_release"})
final class ValidatingOffsetMapping
implements OffsetMapping {
    @NotNull
    private final OffsetMapping delegate;
    private final int originalLength;
    private final int transformedLength;

    public ValidatingOffsetMapping(@NotNull OffsetMapping delegate, int originalLength, int transformedLength) {
        this.delegate = delegate;
        this.originalLength = originalLength;
        this.transformedLength = transformedLength;
    }

    public int originalToTransformed(int offset) {
        int n;
        int transformedOffset = n = this.delegate.originalToTransformed(offset);
        boolean bl = false;
        if (!(0 <= transformedOffset ? transformedOffset <= this.transformedLength : false)) {
            boolean bl2 = false;
            String string2 = "OffsetMapping.originalToTransformed returned invalid mapping: " + offset + " -> " + transformedOffset + " is not in range of transformed text [0, " + this.transformedLength + ']';
            throw new IllegalStateException(string2.toString());
        }
        return n;
    }

    public int transformedToOriginal(int offset) {
        int n;
        int originalOffset = n = this.delegate.transformedToOriginal(offset);
        boolean bl = false;
        if (!(0 <= originalOffset ? originalOffset <= this.originalLength : false)) {
            boolean bl2 = false;
            String string2 = "OffsetMapping.transformedToOriginal returned invalid mapping: " + offset + " -> " + originalOffset + " is not in range of original text [0, " + this.originalLength + ']';
            throw new IllegalStateException(string2.toString());
        }
        return n;
    }
}

